/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.dialogs;

import java.util.Iterator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.Session;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.usermanager.Messages;
import org.netxms.ui.eclipse.usermanager.UserComparator;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SelectUserDialog
extends Dialog {
    private TableViewer userList;
    private Session session;
    Class<? extends AbstractUserObject> classFilter;
    private boolean multiSelection = true;
    private AbstractUserObject[] selection;

    public SelectUserDialog(Shell parentShell, Class<? extends AbstractUserObject> classFilter) {
        super(parentShell);
        this.classFilter = classFilter;
    }

    public void enableMultiSelection(boolean enable) {
        this.multiSelection = enable;
    }

    protected void configureShell(Shell newShell) {
        Messages.get();
        newShell.setText(Messages.SelectUserDialog_Title);
        super.configureShell(newShell);
    }

    protected Control createDialogArea(Composite parent) {
        this.session = ConsoleSharedData.getSession();
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        dialogArea.setLayout((Layout)layout);
        Label label = new Label(dialogArea, 0);
        Messages.get();
        label.setText(Messages.SelectUserDialog_AvailableUsers);
        String[] stringArray = new String[1];
        Messages.get();
        stringArray[0] = Messages.SelectUserDialog_LoginName;
        String[] columnNames = stringArray;
        int[] columnWidths = new int[]{250};
        this.userList = new SortableTableViewer(dialogArea, columnNames, columnWidths, 0, 128, 0x800 | (this.multiSelection ? 2 : 0) | 0x10000);
        this.userList.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.userList.setLabelProvider((IBaseLabelProvider)new WorkbenchLabelProvider());
        this.userList.setComparator((ViewerComparator)new UserComparator());
        this.userList.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SelectUserDialog.this.okPressed();
            }
        });
        this.userList.addFilter(new ViewerFilter(){

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                return SelectUserDialog.this.classFilter.isInstance(element);
            }
        });
        this.userList.setInput((Object)((UserManager)this.session).getUserDatabaseObjects());
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.heightHint = 300;
        this.userList.getControl().setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        IStructuredSelection sel = (IStructuredSelection)this.userList.getSelection();
        if (sel.size() == 0) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.SelectUserDialog_Warning, (String)Messages.SelectUserDialog_WarningText);
            return;
        }
        this.selection = new AbstractUserObject[sel.size()];
        Iterator it = sel.iterator();
        int i = 0;
        while (it.hasNext()) {
            this.selection[i] = (AbstractUserObject)it.next();
            ++i;
        }
        super.okPressed();
    }

    public AbstractUserObject[] getSelection() {
        return this.selection;
    }
}

