/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.snmp.MibObject;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpObjectIdFormatException;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.dialogs.MibWalkDialog;
import org.netxms.ui.eclipse.snmp.shared.MibCache;
import org.netxms.ui.eclipse.snmp.widgets.MibBrowser;
import org.netxms.ui.eclipse.snmp.widgets.MibObjectDetails;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MibSelectionDialog
extends Dialog {
    private long nodeId = 0L;
    private MibBrowser mibTree;
    private Text oid;
    private MibObjectDetails details;
    private MibObject selectedObject;
    private SnmpObjectId selectedObjectId;
    private SnmpObjectId initialSelection;
    private boolean updateObjectId = true;

    public MibSelectionDialog(Shell parentShell, SnmpObjectId initialSelection, long nodeId) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.initialSelection = initialSelection;
        this.nodeId = nodeId;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.MibSelectionDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("MibSelectionDialog.cx"), settings.getInt("MibSelectionDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        MibObject object;
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = this.nodeId != 0L ? 3 : 2;
        dialogArea.setLayout((Layout)layout);
        Composite mibTreeGroup = new Composite(dialogArea, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        mibTreeGroup.setLayout((Layout)layout);
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.verticalSpan = 2;
        mibTreeGroup.setLayoutData((Object)gd);
        Label label = new Label(mibTreeGroup, 0);
        Messages.get();
        label.setText(Messages.MibSelectionDialog_MIBTree);
        this.mibTree = new MibBrowser(mibTreeGroup, 2048);
        gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.widthHint = 500;
        gd.heightHint = 250;
        this.mibTree.setLayoutData(gd);
        this.mibTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                MibSelectionDialog.this.onMibTreeSelectionChanged();
            }
        });
        Messages.get();
        this.oid = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)500, (String)Messages.MibSelectionDialog_OID, (String)"", (Object)"WidgetHelper::default_layout_data");
        this.oid.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                MibSelectionDialog.this.onManualOidChange();
            }
        });
        if (this.nodeId != 0L) {
            Button button = new Button(dialogArea, 8);
            Messages.get();
            button.setText(Messages.MibSelectionDialog_Walk);
            gd = new GridData();
            gd.widthHint = 90;
            gd.verticalAlignment = 1024;
            button.setLayoutData((Object)gd);
            button.addSelectionListener(new SelectionListener(){

                public void widgetSelected(SelectionEvent e) {
                    MibSelectionDialog.this.doWalk();
                }

                public void widgetDefaultSelected(SelectionEvent e) {
                    this.widgetSelected(e);
                }
            });
        }
        this.details = new MibObjectDetails(dialogArea, 0, false, this.mibTree);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.verticalAlignment = 4;
        gd.horizontalSpan = this.nodeId != 0L ? 2 : 1;
        this.details.setLayoutData(gd);
        if (this.initialSelection != null && (object = MibCache.getMibTree().findObject(this.initialSelection, false)) != null) {
            this.mibTree.setSelection(object);
        }
        return dialogArea;
    }

    private void onMibTreeSelectionChanged() {
        MibObject object = this.mibTree.getSelection();
        if (object != null && this.updateObjectId) {
            SnmpObjectId objectId = object.getObjectId();
            this.oid.setText(objectId != null ? objectId.toString() : "");
        }
        this.details.setObject(object);
    }

    protected void okPressed() {
        try {
            this.selectedObjectId = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openWarning((Shell)shell, (String)Messages.MibSelectionDialog_Warning, (String)Messages.MibSelectionDialog_EnterValidOID);
            return;
        }
        this.selectedObject = this.mibTree.getSelection();
        if (this.selectedObject == null) {
            this.selectedObject = MibCache.getMibTree().findObject(this.selectedObjectId, false);
            if (this.selectedObject == null) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.MibSelectionDialog_Warning, (String)Messages.MibSelectionDialog_WarningText);
                return;
            }
        }
        this.saveSettings();
        super.okPressed();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("MibSelectionDialog.cx", size.x);
        settings.put("MibSelectionDialog.cy", size.y);
    }

    public MibObject getSelectedObject() {
        return this.selectedObject;
    }

    private void onManualOidChange() {
        MibObject o = MibCache.findObject(this.oid.getText(), false);
        if (o != null) {
            this.updateObjectId = false;
            this.mibTree.setSelection(o);
            this.updateObjectId = true;
        }
    }

    private void doWalk() {
        try {
            SnmpValue v;
            SnmpObjectId root = SnmpObjectId.parseSnmpObjectId((String)this.oid.getText());
            MibWalkDialog dlg = new MibWalkDialog(this.getShell(), this.nodeId, root);
            if (dlg.open() == 0 && (v = dlg.getValue()) != null) {
                this.oid.setText(v.getName());
            }
        }
        catch (SnmpObjectIdFormatException snmpObjectIdFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.MibSelectionDialog_Error, (String)Messages.MibSelectionDialog_OIDParseError);
        }
    }

    public SnmpObjectId getSelectedObjectId() {
        return this.selectedObjectId;
    }
}

