/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.views.helpers;

import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.swt.graphics.Color;
import org.netxms.client.maps.elements.NetworkMapDCIContainer;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.ui.eclipse.networkmaps.views.helpers.DecorationLayerAbstractFigure;
import org.netxms.ui.eclipse.networkmaps.views.helpers.ExtendedGraphViewer;
import org.netxms.ui.eclipse.networkmaps.views.helpers.LinkDciValueProvider;
import org.netxms.ui.eclipse.networkmaps.views.helpers.MapLabelProvider;
import org.netxms.ui.eclipse.tools.ColorConverter;

public class DCIContainerFigure
extends DecorationLayerAbstractFigure {
    private static final int BORDER_SIZE = 7;
    private static final int MARGIN = 7;
    private LinkDciValueProvider dciValueProvider;
    private NetworkMapDCIContainer container;
    private Label label;
    Color borderColor;
    Color backgroundColor;

    public DCIContainerFigure(NetworkMapDCIContainer container, MapLabelProvider labelProvider, ExtendedGraphViewer viewer) {
        super((NetworkMapElement)container, viewer);
        this.container = container;
        this.dciValueProvider = LinkDciValueProvider.getInstance();
        String text = this.dciValueProvider.getDciDataAsString(container.getDciAsList());
        this.backgroundColor = labelProvider.getColors().create(ColorConverter.rgbFromInt((int)container.getBackgroundColor()));
        Color textColor = labelProvider.getColors().create(ColorConverter.rgbFromInt((int)container.getTextColor()));
        this.borderColor = labelProvider.getColors().create(ColorConverter.rgbFromInt((int)container.getBorderColor()));
        this.label = new Label(text.isEmpty() ? "Empty DCI container" : text);
        this.label.setFont(labelProvider.getTitleFont());
        this.add((IFigure)this.label);
        Dimension d = this.label.getPreferredSize();
        this.label.setSize(d.width + 7, d.height + 7);
        int border = 0;
        if (container.isBorderRequired()) {
            this.label.setLocation(new Point(7, 7));
            border = 7;
        }
        this.setSize(d.width + border * 2 + 7, d.height + border * 2 + 7);
        this.label.setForegroundColor(textColor);
        this.label.setBackgroundColor(this.backgroundColor);
    }

    @Override
    protected void paintFigure(Graphics gc) {
        gc.setAntialias(1);
        if (this.container.isBorderRequired()) {
            Rectangle rect = new Rectangle(this.label.getClientArea());
            gc.setForegroundColor(this.borderColor);
            gc.setLineWidth(7);
            gc.setLineStyle(1);
            gc.drawRoundRectangle(rect, 8, 8);
        }
        gc.setBackgroundColor(this.backgroundColor);
        gc.fillRoundRectangle(this.label.getBounds(), 8, 8);
    }

    @Override
    public void refresh() {
        String text = this.dciValueProvider.getDciDataAsString(this.container.getDciAsList());
        this.label.setText(text.isEmpty() ? "Empty DCI container" : text);
        Dimension d = this.label.getPreferredSize();
        this.label.setSize(d.width + 7, d.height + 7);
        int border = this.container.isBorderRequired() ? 7 : 0;
        this.setSize(d.width + border * 2 + 7, d.height + border * 2 + 7);
        this.repaint();
    }
}

