/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.propertypages;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.client.NXCObjectModificationData;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectbrowser.widgets.ObjectSelector;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class Communication
extends PropertyPage {
    private AbstractNode node;
    private LabeledText primaryName;
    private LabeledText agentPort;
    private LabeledText agentSharedSecret;
    private Combo agentAuthMethod;
    private Button agentForceEncryption;
    private Button agentIsRemote;
    private ObjectSelector agentProxy;
    private Combo snmpVersion;
    private LabeledText snmpPort;
    private Combo snmpAuth;
    private Combo snmpPriv;
    private ObjectSelector snmpProxy;
    private LabeledText snmpAuthName;
    private LabeledText snmpAuthPassword;
    private LabeledText snmpPrivPassword;
    private boolean primaryNameChanged = false;

    protected Control createContents(Composite parent) {
        String string;
        this.node = (AbstractNode)this.getElement().getAdapter(AbstractNode.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogArea.setLayout((Layout)dialogLayout);
        Group generalGroup = new Group(dialogArea, 0);
        Messages.get();
        generalGroup.setText(Messages.Communication_GroupGeneral);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        generalGroup.setLayoutData((Object)gd);
        GridLayout generalGroupLayout = new GridLayout();
        generalGroup.setLayout((Layout)generalGroupLayout);
        this.primaryName = new LabeledText((Composite)generalGroup, 0);
        Messages.get();
        this.primaryName.setLabel(Messages.Communication_PrimaryHostName);
        this.primaryName.setText(this.node.getPrimaryName());
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.primaryName.setLayoutData((Object)gd);
        this.primaryName.getTextControl().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                Communication.this.primaryNameChanged = true;
            }
        });
        this.agentIsRemote = new Button((Composite)generalGroup, 32);
        this.agentIsRemote.setText("This is address of remote management node");
        this.agentIsRemote.setSelection((this.node.getFlags() & 0x80) != 0);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.agentIsRemote.setLayoutData((Object)gd);
        Group agentGroup = new Group(dialogArea, 0);
        Messages.get();
        agentGroup.setText(Messages.Communication_GroupAgent);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        agentGroup.setLayoutData((Object)gd);
        FormLayout agentGroupLayout = new FormLayout();
        agentGroupLayout.marginWidth = 4;
        agentGroupLayout.marginHeight = 4;
        agentGroupLayout.spacing = 8;
        agentGroup.setLayout((Layout)agentGroupLayout);
        this.agentPort = new LabeledText((Composite)agentGroup, 0);
        Messages.get();
        this.agentPort.setLabel(Messages.Communication_TCPPort);
        this.agentPort.setText(Integer.toString(this.node.getAgentPort()));
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentPort.setLayoutData((Object)fd);
        this.agentProxy = new ObjectSelector((Composite)agentGroup, 0, true);
        Messages.get();
        this.agentProxy.setLabel(Messages.Communication_Proxy);
        this.agentProxy.setObjectId(this.node.getProxyNodeId());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentPort, 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment(0, 0);
        this.agentProxy.setLayoutData((Object)fd);
        this.agentForceEncryption = new Button((Composite)agentGroup, 32);
        Messages.get();
        this.agentForceEncryption.setText(Messages.Communication_ForceEncryption);
        this.agentForceEncryption.setSelection((this.node.getFlags() & 0x8000000) != 0);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentPort, 0, 1024);
        this.agentForceEncryption.setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        Messages.get();
        this.agentAuthMethod = WidgetHelper.createLabeledCombo((Composite)agentGroup, (int)2056, (String)Messages.Communication_AuthMethod, (Object)fd);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthNone);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthPlain);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthMD5);
        Messages.get();
        this.agentAuthMethod.add(Messages.Communication_AuthSHA1);
        this.agentAuthMethod.select(this.node.getAgentAuthMethod());
        this.agentAuthMethod.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Communication.this.agentSharedSecret.getTextControl().setEnabled(Communication.this.agentAuthMethod.getSelectionIndex() != 0);
            }
        });
        this.agentSharedSecret = new LabeledText((Composite)agentGroup, 0);
        Messages.get();
        this.agentSharedSecret.setLabel(Messages.Communication_SharedSecret);
        this.agentSharedSecret.setText(this.node.getAgentSharedSecret());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.agentAuthMethod.getParent(), 0, 131072);
        fd.right = new FormAttachment(100, 0);
        fd.top = new FormAttachment((Control)this.agentForceEncryption, 0, 1024);
        this.agentSharedSecret.setLayoutData((Object)fd);
        this.agentSharedSecret.getTextControl().setEnabled(this.node.getAgentAuthMethod() != 0);
        Group snmpGroup = new Group(dialogArea, 0);
        Messages.get();
        snmpGroup.setText(Messages.Communication_GroupSNMP);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        snmpGroup.setLayoutData((Object)gd);
        FormLayout snmpGroupLayout = new FormLayout();
        snmpGroupLayout.marginWidth = 4;
        snmpGroupLayout.marginHeight = 4;
        snmpGroupLayout.spacing = 8;
        snmpGroup.setLayout((Layout)snmpGroupLayout);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        Messages.get();
        this.snmpVersion = WidgetHelper.createLabeledCombo((Composite)snmpGroup, (int)2056, (String)Messages.Communication_Version, (Object)fd);
        this.snmpVersion.add("1");
        this.snmpVersion.add("2c");
        this.snmpVersion.add("3");
        this.snmpVersion.select(this.snmpVersionToIndex(this.node.getSnmpVersion()));
        this.snmpVersion.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }

            public void widgetSelected(SelectionEvent e) {
                Communication.this.onSnmpVersionChange();
            }
        });
        this.snmpPort = new LabeledText((Composite)snmpGroup, 0);
        Messages.get();
        this.snmpPort.setLabel(Messages.Communication_UDPPort);
        this.snmpPort.setText(Integer.toString(this.node.getSnmpPort()));
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        Messages.get();
        this.snmpAuth = WidgetHelper.createLabeledCombo((Composite)snmpGroup, (int)2056, (String)Messages.Communication_Authentication, (Object)fd);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthNone);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthMD5);
        Messages.get();
        this.snmpAuth.add(Messages.Communication_AuthSHA1);
        this.snmpAuth.select(this.node.getSnmpAuthMethod());
        this.snmpAuth.setEnabled(this.node.getSnmpVersion() == 3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 131072);
        fd.top = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 1024);
        Messages.get();
        this.snmpPriv = WidgetHelper.createLabeledCombo((Composite)snmpGroup, (int)2056, (String)Messages.Communication_Encryption, (Object)fd);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncNone);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncDES);
        Messages.get();
        this.snmpPriv.add(Messages.Communication_EncAES);
        this.snmpPriv.select(this.node.getSnmpPrivMethod());
        this.snmpPriv.setEnabled(this.node.getSnmpVersion() == 3);
        this.snmpProxy = new ObjectSelector((Composite)snmpGroup, 0, true);
        Messages.get();
        this.snmpProxy.setLabel(Messages.Communication_Proxy);
        this.snmpProxy.setObjectId(this.node.getSnmpProxyId());
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 1024);
        fd.right = new FormAttachment((Control)this.snmpPriv.getParent(), 0, 131072);
        this.snmpProxy.setLayoutData((Object)fd);
        this.snmpAuthName = new LabeledText((Composite)snmpGroup, 0);
        if (this.node.getSnmpVersion() == 3) {
            Messages.get();
            string = Messages.Communication_UserName;
        } else {
            Messages.get();
            string = Messages.Communication_Community;
        }
        this.snmpAuthName.setLabel(string);
        this.snmpAuthName.setText(this.node.getSnmpAuthName());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpProxy, 0, 131072);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthName.setLayoutData((Object)fd);
        this.snmpAuthPassword = new LabeledText((Composite)snmpGroup, 0);
        Messages.get();
        this.snmpAuthPassword.setLabel(Messages.Communication_AuthPassword);
        this.snmpAuthPassword.setText(this.node.getSnmpAuthPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpAuth.getParent(), 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpAuthPassword.setLayoutData((Object)fd);
        this.snmpAuthPassword.getTextControl().setEnabled(this.node.getSnmpVersion() == 3);
        this.snmpPrivPassword = new LabeledText((Composite)snmpGroup, 0);
        Messages.get();
        this.snmpPrivPassword.setLabel(Messages.Communication_EncPassword);
        this.snmpPrivPassword.setText(this.node.getSnmpPrivPassword());
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment((Control)this.snmpProxy, 0, 128);
        fd.right = new FormAttachment(100, 0);
        this.snmpPrivPassword.setLayoutData((Object)fd);
        this.snmpPrivPassword.getTextControl().setEnabled(this.node.getSnmpVersion() == 3);
        fd = new FormData();
        fd.left = new FormAttachment((Control)this.snmpVersion.getParent(), 0, 131072);
        fd.right = new FormAttachment((Control)this.snmpAuthName, 0, 16384);
        fd.top = new FormAttachment(0, 0);
        this.snmpPort.setLayoutData((Object)fd);
        return dialogArea;
    }

    private int snmpVersionToIndex(int version) {
        switch (version) {
            case 0: {
                return 0;
            }
            case 1: {
                return 1;
            }
            case 3: {
                return 2;
            }
        }
        return 0;
    }

    private int snmpIndexToVersion(int index) {
        int[] nArray = new int[3];
        nArray[1] = 1;
        nArray[2] = 3;
        int[] versions = nArray;
        return versions[index];
    }

    private void onSnmpVersionChange() {
        String string;
        boolean isV3;
        boolean bl = isV3 = this.snmpVersion.getSelectionIndex() == 2;
        if (isV3) {
            Messages.get();
            string = Messages.Communication_UserName;
        } else {
            Messages.get();
            string = Messages.Communication_Community;
        }
        this.snmpAuthName.setLabel(string);
        this.snmpAuth.setEnabled(isV3);
        this.snmpPriv.setEnabled(isV3);
        this.snmpAuthPassword.getTextControl().setEnabled(isV3);
        this.snmpPrivPassword.getTextControl().setEnabled(isV3);
    }

    protected boolean applyChanges(final boolean isApply) {
        final NXCObjectModificationData md = new NXCObjectModificationData(this.node.getObjectId());
        if (this.primaryNameChanged) {
            String hostName = this.primaryName.getText().trim();
            if (!hostName.matches("^([A-Za-z0-9\\-]+\\.)*[A-Za-z0-9\\-]+$")) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)String.format(Messages.Communication_WarningInvalidHostname, hostName));
                return false;
            }
            md.setPrimaryName(hostName);
        }
        if (isApply) {
            this.setValid(false);
        }
        try {
            md.setAgentPort(Integer.parseInt(this.agentPort.getText(), 10));
        }
        catch (NumberFormatException numberFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)Messages.Communication_WarningInvalidAgentPort);
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setAgentProxy(this.agentProxy.getObjectId());
        md.setAgentAuthMethod(this.agentAuthMethod.getSelectionIndex());
        md.setAgentSecret(this.agentSharedSecret.getText());
        md.setSnmpVersion(this.snmpIndexToVersion(this.snmpVersion.getSelectionIndex()));
        try {
            md.setSnmpPort(Integer.parseInt(this.snmpPort.getText(), 10));
        }
        catch (NumberFormatException numberFormatException) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialog.openWarning((Shell)shell, (String)Messages.Communication_Warning, (String)Messages.Communication_WarningInvalidSNMPPort);
            if (isApply) {
                this.setValid(true);
            }
            return false;
        }
        md.setSnmpProxy(this.snmpProxy.getObjectId());
        md.setSnmpAuthMethod(this.snmpAuth.getSelectionIndex());
        md.setSnmpPrivMethod(this.snmpPriv.getSelectionIndex());
        md.setSnmpAuthName(this.snmpAuthName.getText());
        md.setSnmpAuthPassword(this.snmpAuthPassword.getText());
        md.setSnmpPrivPassword(this.snmpPrivPassword.getText());
        int flags = this.node.getFlags();
        flags = this.agentForceEncryption.getSelection() ? (flags |= 0x8000000) : (flags &= 0xF7FFFFFF);
        flags = this.agentIsRemote.getSelection() ? (flags |= 0x80) : (flags &= 0xFFFFFF7F);
        md.setObjectFlags(flags);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(String.format(Messages.Communication_JobName, this.node.getObjectName()), null, "org.netxms.ui.eclipse.objectmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.modifyObject(md);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.Communication_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Communication.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
        return true;
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    protected void performDefaults() {
        super.performDefaults();
        this.agentPort.setText("4700");
        this.agentForceEncryption.setSelection(false);
        this.agentAuthMethod.select(0);
        this.agentProxy.setObjectId(0L);
        this.agentSharedSecret.setText("");
        this.agentSharedSecret.getTextControl().setEnabled(false);
        this.snmpVersion.select(0);
        this.snmpAuth.select(0);
        this.snmpPriv.select(0);
        this.snmpAuthName.setText("public");
        this.snmpAuthPassword.setText("");
        this.snmpPrivPassword.setText("");
        this.snmpProxy.setObjectId(0L);
        this.onSnmpVersionChange();
    }
}

