/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.preferencepages;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.progress.UIJob;
import org.netxms.client.NXCException;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerFile;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.AlarmNotifier;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class AlarmMelody
extends PreferencePage
implements IWorkbenchPreferencePage {
    public static final String ID = "org.netxms.ui.eclipse.alarmviewer.views.AlarmMelodyView";
    private NXCSession session;
    private ServerFile[] serverFiles = null;
    private IPreferenceStore ps;
    private URL workspaceUrl;
    private Set<String> melodyList = new HashSet<String>();
    private List<String> currentMelodyList = new ArrayList<String>();
    private Set<String> oldMelodyList = new HashSet<String>();
    private List<String> newMelodyList = new ArrayList<String>();
    private List<Combo> comboList = new ArrayList<Combo>();

    public void init(IWorkbench workbench) {
        this.setPreferenceStore(Activator.getDefault().getPreferenceStore());
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.ps = Activator.getDefault().getPreferenceStore();
        this.workspaceUrl = Platform.getInstanceLocation().getURL();
    }

    protected Control createContents(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        Combo newCombo = null;
        int i = 0;
        while (i < 5) {
            newCombo = WidgetHelper.createLabeledCombo((Composite)dialogArea, (int)12, (String)StatusDisplayInfo.getStatusText((int)i), (Object)"WidgetHelper::default_layout_data");
            newCombo.setEnabled(false);
            this.comboList.add(i, newCombo);
            ++i;
        }
        Messages.get();
        new UIJob(Messages.AlarmMelody_JobGetMelodyList){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                String[] s;
                try {
                    s = new String[]{"wav"};
                    AlarmMelody.this.serverFiles = AlarmMelody.this.session.listServerFiles(s);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    AlarmMelody.this.getShell().getDisplay().asyncExec(new Runnable(){

                        @Override
                        public void run() {
                            Shell shell = AlarmMelody.this.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmMelody_ErrorGettingMelodyList, (String)(String.valueOf(Messages.AlarmMelody_ErrorGettingMelodyListDescription) + e.getMessage()));
                        }
                    });
                }
                ServerFile[] serverFileArray = AlarmMelody.this.serverFiles;
                int n = serverFileArray.length;
                int n2 = 0;
                while (n2 < n) {
                    s = serverFileArray[n2];
                    AlarmMelody.this.melodyList.add(s.getName());
                    ++n2;
                }
                AlarmMelody.this.melodyList.add("");
                int i = 0;
                while (i < 5) {
                    AlarmMelody.this.currentMelodyList.add(i, AlarmMelody.this.ps.getString("ALARM_NOTIFIER.MELODY." + AlarmNotifier.severityArray[i]));
                    ++i;
                }
                AlarmMelody.this.melodyList.addAll(AlarmMelody.this.currentMelodyList);
                Combo newCombo = null;
                int i2 = 0;
                while (i2 < 5) {
                    newCombo = (Combo)AlarmMelody.this.comboList.get(i2);
                    newCombo.setEnabled(true);
                    newCombo.setItems(AlarmMelody.this.melodyList.toArray(new String[AlarmMelody.this.melodyList.size()]));
                    newCombo.select(newCombo.indexOf((String)AlarmMelody.this.currentMelodyList.get(i2)));
                    ++i2;
                }
                return Status.OK_STATUS;
            }
        }.schedule();
        return dialogArea;
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int i = 0;
        while (i < 5) {
            this.newMelodyList.add(this.comboList.get(i).getText());
            ++i;
        }
        Messages.get();
        new UIJob(Messages.AlarmMelody_SaveClientSelection){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                int i = 0;
                while (i < 5) {
                    AlarmMelody.this.changeMelody((String)AlarmMelody.this.newMelodyList.get(i), AlarmNotifier.severityArray[i], i);
                    ++i;
                }
                for (String oldName : AlarmMelody.this.oldMelodyList) {
                    if (AlarmMelody.this.currentMelodyList.contains(oldName)) continue;
                    File file = new File(AlarmMelody.this.workspaceUrl.getPath(), oldName);
                    file.delete();
                }
                if (isApply) {
                    AlarmMelody.this.setValid(true);
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    private void changeMelody(String melodyName, String severity, int id) {
        String oldMelodyName = this.currentMelodyList.get(id);
        if (!melodyName.equals(oldMelodyName)) {
            try {
                if (!AlarmMelody.checkMelodyExists(melodyName, this.workspaceUrl)) {
                    AlarmMelody.downloadSoundFile(this.session, melodyName, this.workspaceUrl);
                }
                this.ps.setValue("ALARM_NOTIFIER.MELODY." + severity, melodyName);
                this.currentMelodyList.set(id, melodyName);
                this.oldMelodyList.add(oldMelodyName);
            }
            catch (Exception e) {
                this.getShell().getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = AlarmMelody.this.getShell();
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmMelody_ErrorMelodyNotExists, (String)(String.valueOf(Messages.AlarmMelody_ErrorMelodyNotExistsDescription) + e.getMessage()));
                    }
                });
                this.ps.setValue("ALARM_NOTIFIER.MELODY." + severity, "");
            }
        }
    }

    private static boolean checkMelodyExists(String melodyName, URL workspaceUrl) {
        if (workspaceUrl != null && melodyName != null && !melodyName.equals("")) {
            File f = new File(workspaceUrl.getPath(), melodyName);
            return f.isFile();
        }
        return true;
    }

    private static void downloadSoundFile(NXCSession session, String melodyName, URL workspaceUrl) throws NXCException, IOException {
        File serverFile = session.downloadFileFromServer(melodyName);
        AbstractInterruptibleChannel src = null;
        AbstractInterruptibleChannel dest = null;
        try {
            try {
                src = new FileInputStream(serverFile).getChannel();
                File f = new File(workspaceUrl.getPath(), melodyName);
                f.createNewFile();
                dest = new FileOutputStream(f).getChannel();
                ((FileChannel)dest).transferFrom((ReadableByteChannel)((Object)src), 0L, ((FileChannel)src).size());
            }
            catch (IOException e) {
                Activator.logError("Cannot copy sound file", e);
                if (src != null) {
                    src.close();
                }
                if (dest != null) {
                    dest.close();
                }
            }
        }
        finally {
            if (src != null) {
                src.close();
            }
            if (dest != null) {
                dest.close();
            }
        }
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

