/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.propertypages;

import java.util.Calendar;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.api.client.reporting.ReportingJob;

public class General
extends PropertyPage {
    public static final String ID = "org.netxms.ui.eclipse.reporter.propertypages.General";
    private Composite dailyComposite;
    private Composite weeklyComposite;
    private Composite monthlyComposite;
    private Composite onceComposite;
    private Button onceButton;
    private Button dailyButton;
    private Button weeklyButton;
    private Button monthlyButton;
    private Button[] monthlyButtons;
    private Button[] weeklyButtons;
    public int type;
    private DateTime executionDate;
    private DateTime executionTime;
    private ReportingJob job = null;

    protected Control createContents(Composite parent) {
        this.job = (ReportingJob)this.getElement().getAdapter(ReportingJob.class);
        Composite dialogArea = new Composite(parent, 0);
        GridLayout dialogLayout = new GridLayout();
        dialogLayout.marginWidth = 0;
        dialogLayout.marginHeight = 0;
        dialogLayout.numColumns = 4;
        dialogLayout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)dialogLayout);
        this.onceButton = new Button(dialogArea, 16);
        this.onceButton.setText("Once");
        this.onceButton.addSelectionListener((SelectionListener)new GranularitySelectorListener(0, true, false, false, false));
        this.dailyButton = new Button(dialogArea, 16);
        this.dailyButton.setText("Daily");
        this.dailyButton.addSelectionListener((SelectionListener)new GranularitySelectorListener(1, false, true, false, false));
        this.weeklyButton = new Button(dialogArea, 16);
        this.weeklyButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.weeklyButton.setText("Weekly");
        this.weeklyButton.addSelectionListener((SelectionListener)new GranularitySelectorListener(2, false, false, true, false));
        this.monthlyButton = new Button(dialogArea, 16);
        this.monthlyButton.setLayoutData((Object)new GridData(16384, 0x1000000, false, false, 1, 1));
        this.monthlyButton.setText("Monthly");
        this.monthlyButton.addSelectionListener((SelectionListener)new GranularitySelectorListener(3, false, false, false, true));
        this.onceComposite = this.createOnce(dialogArea);
        this.dailyComposite = this.createDaily(dialogArea);
        this.weeklyComposite = this.createWeekly(dialogArea);
        this.monthlyComposite = this.createMonthly(dialogArea);
        this.type = 0;
        this.onceButton.setSelection(true);
        return dialogArea;
    }

    private Composite createOnce(Composite group) {
        DateTime startTime;
        Composite onceComposite = new Composite(group, 0);
        onceComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        onceComposite.setLayout((Layout)new GridLayout(4, false));
        final DateTime startDate = new DateTime(onceComposite, 36);
        this.executionTime = startTime = new DateTime(onceComposite, 128);
        this.executionDate = startDate;
        this.onceButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.executionTime = startTime;
                General.this.executionDate = startDate;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return onceComposite;
    }

    private Composite createDaily(Composite group) {
        Composite dailyComposite = new Composite(group, 0);
        dailyComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        dailyComposite.setLayout((Layout)new GridLayout(4, false));
        dailyComposite.setVisible(false);
        final DateTime startTime = new DateTime(dailyComposite, 128);
        this.dailyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.executionTime = startTime;
                General.this.executionDate = null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return dailyComposite;
    }

    protected Composite createWeekly(Composite group) {
        Composite weeklyComposite = new Composite(group, 0);
        weeklyComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        weeklyComposite.setLayout((Layout)new GridLayout(7, false));
        weeklyComposite.setVisible(false);
        String[] dayOfWeek = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};
        this.weeklyButtons = new Button[7];
        int i = 0;
        while (i < 7) {
            this.weeklyButtons[i] = new Button(weeklyComposite, 32);
            this.weeklyButtons[i].setText(dayOfWeek[i]);
            ++i;
        }
        final DateTime startTime = new DateTime(weeklyComposite, 128);
        startTime.setLayoutData((Object)new GridData(16384, 128, false, false, 7, 1));
        this.weeklyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.executionTime = startTime;
                General.this.executionDate = null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return weeklyComposite;
    }

    private Composite createMonthly(Composite group) {
        Composite monthlyComposite = new Composite(group, 0);
        monthlyComposite.setLayoutData((Object)new GridData(16384, 0x1000000, true, false, 4, 1));
        monthlyComposite.setLayout((Layout)new GridLayout(7, true));
        monthlyComposite.setVisible(false);
        this.monthlyButtons = new Button[31];
        int i = 0;
        while (i < 31) {
            this.monthlyButtons[i] = new Button(monthlyComposite, 32);
            this.monthlyButtons[i].setText(Integer.toString(i + 1));
            ++i;
        }
        final DateTime startTime = new DateTime(monthlyComposite, 128);
        startTime.setLayoutData((Object)new GridData(16384, 128, false, false, 7, 1));
        this.monthlyButton.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                General.this.executionTime = startTime;
                General.this.executionDate = null;
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        return monthlyComposite;
    }

    protected boolean applyChanges(boolean isApply) {
        Calendar calendar = Calendar.getInstance();
        switch (this.type) {
            case 0: {
                calendar.set(1, this.executionDate.getYear());
                calendar.set(2, this.executionDate.getMonth());
                calendar.set(5, this.executionDate.getDay());
                calendar.set(11, this.executionTime.getHours());
                calendar.set(12, this.executionTime.getMinutes());
                break;
            }
            case 1: {
                calendar.set(11, this.executionTime.getHours());
                calendar.set(12, this.executionTime.getMinutes());
                break;
            }
            case 2: {
                calendar.set(11, this.executionTime.getHours());
                calendar.set(12, this.executionTime.getMinutes());
                int outWeeklyMask = 0;
                int i = 0;
                while (i < 7) {
                    outWeeklyMask <<= 1;
                    outWeeklyMask += this.weeklyButtons[i].getSelection() ? 1 : 0;
                    ++i;
                }
                this.job.setDaysOfWeek(outWeeklyMask);
                break;
            }
            case 3: {
                calendar.set(11, this.executionTime.getHours());
                calendar.set(12, this.executionTime.getMinutes());
                int outMonthlyMask = 0;
                int i = 0;
                while (i < 31) {
                    outMonthlyMask <<= 1;
                    outMonthlyMask += this.monthlyButtons[i].getSelection() ? 1 : 0;
                    ++i;
                }
                this.job.setDaysOfMonth(outMonthlyMask);
                break;
            }
        }
        this.job.setStartTime(calendar.getTime());
        this.job.setType(this.type);
        return true;
    }

    private void changeVisibility(boolean onceVisible, boolean dailyVisible, boolean weeklyVisible, boolean monthlyVisible) {
        this.onceComposite.setVisible(onceVisible);
        ((GridData)this.onceComposite.getLayoutData()).exclude = !onceVisible;
        this.dailyComposite.setVisible(dailyVisible);
        ((GridData)this.dailyComposite.getLayoutData()).exclude = !dailyVisible;
        this.weeklyComposite.setVisible(weeklyVisible);
        ((GridData)this.weeklyComposite.getLayoutData()).exclude = !weeklyVisible;
        this.monthlyComposite.setVisible(monthlyVisible);
        ((GridData)this.monthlyComposite.getLayoutData()).exclude = !monthlyVisible;
        this.getShell().layout(true, true);
        this.getShell().pack();
    }

    public boolean performOk() {
        return this.applyChanges(false);
    }

    protected void performApply() {
        this.applyChanges(true);
    }

    private final class GranularitySelectorListener
    implements SelectionListener {
        private boolean dailyVisible;
        private boolean weeklyVisible;
        private boolean monthlyVisible;
        private Boolean onceVisible;
        private int type;

        private GranularitySelectorListener(int type, Boolean onceVisible, boolean dailyVisible, boolean weeklyVisible, boolean monthlyVisible) {
            this.type = type;
            this.onceVisible = onceVisible;
            this.dailyVisible = dailyVisible;
            this.weeklyVisible = weeklyVisible;
            this.monthlyVisible = monthlyVisible;
        }

        public void widgetSelected(SelectionEvent e) {
            General.this.type = this.type;
            General.this.changeVisibility(this.onceVisible, this.dailyVisible, this.weeklyVisible, this.monthlyVisible);
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    }
}

