/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IOConsole;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.console.TextConsole;
import org.eclipse.ui.console.TextConsoleViewer;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class LocalCommandResults
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.LocalCommandResults";
    private long nodeId;
    private long toolId;
    private TextConsoleViewer viewer;
    private IOConsole console;
    private Process process;
    private boolean running = false;
    private String lastCommand = null;
    private Object mutex = new Object();
    private Action actionClear;
    private Action actionScrollLock;
    private Action actionTerminate;
    private Action actionRestart;
    private Action actionCopy;
    private Action actionSelectAll;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        try {
            this.nodeId = Long.parseLong(parts[0]);
            this.toolId = Long.parseLong(parts[1]);
            NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            AbstractObject object = session.findObjectById(this.nodeId);
            this.setPartName(String.valueOf(object.getObjectName()) + " - " + ObjectToolsCache.getInstance().findTool(this.toolId).getDisplayName());
        }
        catch (Exception e) {
            throw new PartInitException("Unexpected initialization failure", (Throwable)e);
        }
    }

    public void createPartControl(Composite parent) {
        this.console = new IOConsole("Console", Activator.getImageDescriptor("icons/console.png"));
        this.viewer = new TextConsoleViewer(parent, (TextConsole)this.console);
        this.viewer.setEditable(false);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                LocalCommandResults.this.actionCopy.setEnabled(LocalCommandResults.this.viewer.canDoOperation(4));
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.activateContext();
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.objecttools.context.LocalCommandResults");
        }
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionClear = new Action(Messages.LocalCommandResults_ClearConsole, SharedIcons.CLEAR_LOG){

            public void run() {
                LocalCommandResults.this.console.clearConsole();
            }
        };
        this.actionClear.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.clear_output");
        handlerService.activateHandler(this.actionClear.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClear));
        Messages.get();
        this.actionScrollLock = new Action(Messages.LocalCommandResults_ScrollLock, 2){

            public void run() {
            }
        };
        this.actionScrollLock.setImageDescriptor(Activator.getImageDescriptor("icons/scroll_lock.gif"));
        this.actionScrollLock.setChecked(false);
        this.actionScrollLock.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.scroll_lock");
        handlerService.activateHandler(this.actionScrollLock.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionScrollLock));
        Messages.get();
        this.actionTerminate = new Action(Messages.LocalCommandResults_Terminate, SharedIcons.TERMINATE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = LocalCommandResults.this.mutex;
                synchronized (object) {
                    if (LocalCommandResults.this.running) {
                        LocalCommandResults.this.process.destroy();
                    }
                }
            }
        };
        this.actionTerminate.setEnabled(false);
        this.actionTerminate.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.terminate_process");
        handlerService.activateHandler(this.actionTerminate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionTerminate));
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                LocalCommandResults.this.runCommand(LocalCommandResults.this.lastCommand);
            }
        };
        this.actionRestart.setEnabled(false);
        Messages.get();
        this.actionCopy = new Action(Messages.LocalCommandResults_Copy){

            public void run() {
                if (LocalCommandResults.this.viewer.canDoOperation(4)) {
                    LocalCommandResults.this.viewer.doOperation(4);
                }
            }
        };
        this.actionCopy.setEnabled(false);
        this.actionCopy.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.copy");
        handlerService.activateHandler(this.actionCopy.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionCopy));
        Messages.get();
        this.actionSelectAll = new Action(Messages.LocalCommandResults_SelectAll){

            public void run() {
                if (LocalCommandResults.this.viewer.canDoOperation(7)) {
                    LocalCommandResults.this.viewer.doOperation(7);
                }
            }
        };
        this.actionSelectAll.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.select_all");
        handlerService.activateHandler(this.actionSelectAll.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSelectAll));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                LocalCommandResults.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    private void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionClear);
        manager.add((IAction)this.actionScrollLock);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSelectAll);
        manager.add((IAction)this.actionCopy);
    }

    public void setFocus() {
        this.viewer.getTextWidget().setFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(final String command) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running) {
                this.process.destroy();
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.running = true;
            this.lastCommand = command;
            this.actionTerminate.setEnabled(true);
            this.actionRestart.setEnabled(false);
        }
        final IOConsoleOutputStream out = this.console.newOutputStream();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LocalCommandResults_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.LocalCommandResults_JobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LocalCommandResults.this.process = Runtime.getRuntime().exec(command);
                InputStream in = LocalCommandResults.this.process.getInputStream();
                try {
                    try {
                        int bytes;
                        byte[] data = new byte[16384];
                        boolean isWindows = Platform.getOS().equals("win32");
                        while ((bytes = in.read(data)) != -1) {
                            String s = new String(Arrays.copyOf(data, bytes));
                            if (isWindows) {
                                out.write(s.replace("\r\r\n", " \r\n"));
                                continue;
                            }
                            out.write(s);
                        }
                        Messages.get();
                        out.write(Messages.LocalCommandResults_Terminated);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                        in.close();
                        out.close();
                    }
                }
                finally {
                    in.close();
                    out.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void jobFinalize() {
                Object object = LocalCommandResults.this.mutex;
                synchronized (object) {
                    LocalCommandResults.this.running = false;
                    LocalCommandResults.this.process = null;
                    LocalCommandResults.this.mutex.notifyAll();
                }
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LocalCommandResults.this.mutex;
                        synchronized (object) {
                            LocalCommandResults.this.actionTerminate.setEnabled(LocalCommandResults.this.running);
                            LocalCommandResults.this.actionRestart.setEnabled(!LocalCommandResults.this.running);
                        }
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running) {
                this.process.destroy();
            }
        }
        super.dispose();
    }
}

