/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.Table;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableContentProvider;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableItemComparator;
import org.netxms.ui.eclipse.objecttools.views.helpers.TableLabelProvider;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableToolResults
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.TableToolResults";
    private NXCSession session;
    private ObjectTool tool;
    private long nodeId;
    private SortableTableViewer viewer;
    private Action actionRefresh;
    private Action actionExportToCsv;
    private Action actionExportAllToCsv;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        String[] parts = site.getSecondaryId().split("&");
        if (parts.length != 2) {
            throw new PartInitException("Internal error");
        }
        this.tool = ObjectToolsCache.getInstance().findTool(Long.parseLong(parts[0]));
        if (this.tool == null) {
            Messages.get();
            throw new PartInitException(Messages.TableToolResults_InvalidToolID);
        }
        this.nodeId = Long.parseLong(parts[1]);
        AbstractObject object = this.session.findObjectById(this.nodeId);
        if (object == null || object.getObjectClass() != 2) {
            Messages.get();
            throw new PartInitException(Messages.TableToolResults_InvalidObjectID);
        }
        this.setPartName(String.valueOf(object.getObjectName()) + ": " + this.tool.getDisplayName());
    }

    public void createPartControl(Composite parent) {
        this.viewer = new SortableTableViewer(parent, 65538);
        this.viewer.setContentProvider((IContentProvider)new TableContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                TableToolResults.this.refreshTable();
            }
        };
        this.actionExportToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, true);
        this.actionExportAllToCsv = new ExportToCsvAction((IViewPart)this, (ColumnViewer)this.viewer, false);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExportAllToCsv);
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                TableToolResults.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionExportToCsv);
    }

    public void setFocus() {
        this.viewer.getTable().setFocus();
    }

    public void refreshTable() {
        this.viewer.setInput(null);
        Messages.get();
        new ConsoleJob(String.format(Messages.TableToolResults_JobTitle, this.tool.getName()), (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Table table = TableToolResults.this.session.executeTableTool(TableToolResults.this.tool.getId(), TableToolResults.this.nodeId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        TableToolResults.this.updateViewer(table);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.TableToolResults_JobError, TableToolResults.this.tool.getName());
            }
        }.start();
    }

    private void updateViewer(Table table) {
        if (!this.viewer.isInitialized()) {
            String[] names = table.getColumnDisplayNames();
            int[] widths = new int[names.length];
            Arrays.fill(widths, 100);
            this.viewer.createColumns(names, widths, 0, 128);
            WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("TableToolResults." + Long.toString(this.tool.getId())));
            this.viewer.getTable().addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    WidgetHelper.saveTableViewerSettings((SortableTableViewer)TableToolResults.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)("TableToolResults." + Long.toString(TableToolResults.this.tool.getId())));
                }
            });
            this.viewer.setComparator((ViewerComparator)new TableItemComparator(table.getColumnDataTypes()));
        }
        this.viewer.setInput((Object)table);
    }
}

