/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.client.maps.configs.SingleDciConfig;
import org.netxms.ui.eclipse.datacollection.widgets.DciSelector;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class DataSourceEditDlg
extends Dialog {
    private SingleDciConfig dci;
    private DciSelector dciSelector;
    private LabeledText name;
    private LabeledText instance;
    private LabeledText dataColumn;
    private LabeledText formatString;

    public DataSourceEditDlg(Shell parentShell, SingleDciConfig dci) {
        super(parentShell);
        this.dci = dci;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit data source");
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.numColumns = 2;
        dialogArea.setLayout((Layout)layout);
        this.dciSelector = new DciSelector(dialogArea, 0, false);
        this.dciSelector.setLabel("Data collection item");
        this.dciSelector.setDciId(this.dci.getNodeId(), this.dci.dciId);
        this.dciSelector.setDcObjectType(this.dci.type);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.widthHint = 400;
        gd.horizontalSpan = 2;
        this.dciSelector.setLayoutData((Object)gd);
        this.name = new LabeledText(dialogArea, 0);
        this.name.setLabel("Name");
        this.name.setText(this.dci.name);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.name.setLayoutData((Object)gd);
        this.formatString = new LabeledText(dialogArea, 0);
        this.formatString.setLabel("Format string");
        this.formatString.setText(this.dci.formatString);
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalSpan = 2;
        this.formatString.setLayoutData((Object)gd);
        if (this.dci.type == 2) {
            Group tableGroup = new Group(dialogArea, 0);
            tableGroup.setText("Table cell");
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            gd.horizontalSpan = 2;
            tableGroup.setLayoutData((Object)gd);
            layout = new GridLayout();
            tableGroup.setLayout((Layout)layout);
            this.dataColumn = new LabeledText((Composite)tableGroup, 0);
            this.dataColumn.setLabel("Data column");
            this.dataColumn.setText(this.dci.getColumn());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.dataColumn.setLayoutData((Object)gd);
            this.instance = new LabeledText((Composite)tableGroup, 0);
            this.instance.setLabel("Instance");
            this.instance.setText(this.dci.getInstance());
            gd = new GridData();
            gd.horizontalAlignment = 4;
            gd.grabExcessHorizontalSpace = true;
            this.instance.setLayoutData((Object)gd);
        }
        return dialogArea;
    }

    protected void okPressed() {
        this.dci.setNodeId(this.dciSelector.getNodeId());
        this.dci.dciId = this.dciSelector.getDciId();
        this.dci.name = this.name.getText();
        this.dci.formatString = this.formatString.getText();
        if (this.dci.type == 2) {
            this.dci.column = this.dataColumn.getText().trim();
            this.dci.instance = this.instance.getText();
        }
        super.okPressed();
    }
}

