/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.epp.views;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.situations.Situation;
import org.netxms.client.situations.SituationInstance;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.epp.Activator;
import org.netxms.ui.eclipse.epp.Messages;
import org.netxms.ui.eclipse.epp.propertypages.helpers.AttributeLabelProvider;
import org.netxms.ui.eclipse.epp.views.helpers.AttributeComparator;
import org.netxms.ui.eclipse.epp.views.helpers.SituationTreeContentProvider;
import org.netxms.ui.eclipse.epp.views.helpers.SituationTreeLabelProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class SituationsManager
extends ViewPart
implements SessionListener {
    public static final String ID = "org.netxms.ui.eclipse.epp.views.SituationsManager";
    private NXCSession session;
    private Map<Long, Situation> situations = new HashMap<Long, Situation>();
    private TreeViewer situationTree;
    private SortableTableViewer details;
    private Action actionRefresh;
    private Action actionCreate;
    private Action actionDelete;

    public void init(IViewSite site) throws PartInitException {
        this.session = (NXCSession)ConsoleSharedData.getSession();
        super.init(site);
    }

    public void createPartControl(Composite parent) {
        final IDialogSettings settings = Activator.getDefault().getDialogSettings();
        final SashForm splitter = new SashForm(parent, 256);
        this.situationTree = new TreeViewer((Composite)splitter, 2050);
        this.situationTree.setContentProvider((IContentProvider)new SituationTreeContentProvider());
        this.situationTree.setLabelProvider((IBaseLabelProvider)new SituationTreeLabelProvider());
        this.situationTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)SituationsManager.this.situationTree.getSelection();
                if (!selection.isEmpty()) {
                    Object object = selection.getFirstElement();
                    if (object instanceof SituationInstance) {
                        SituationsManager.this.details.setInput((Object)((SituationInstance)object).getAttributes().entrySet().toArray());
                    } else {
                        SituationsManager.this.details.setInput((Object)new Object[0]);
                    }
                } else {
                    SituationsManager.this.details.setInput((Object)new Object[0]);
                }
            }
        });
        String[] stringArray = new String[2];
        Messages.get();
        stringArray[0] = Messages.SituationsManager_ColAttribute;
        Messages.get();
        stringArray[1] = Messages.SituationsManager_ColValue;
        String[] names = stringArray;
        int[] widths = new int[]{150, 150};
        this.details = new SortableTableViewer((Composite)splitter, names, widths, 0, 128, 67584);
        this.details.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.details.setLabelProvider((IBaseLabelProvider)new AttributeLabelProvider());
        this.details.setComparator((ViewerComparator)new AttributeComparator());
        this.details.getTable().setHeaderVisible(true);
        this.details.getTable().setLinesVisible(true);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.details, (IDialogSettings)settings, (String)"SituationInstanceDetails");
        this.details.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)SituationsManager.this.details, (IDialogSettings)settings, (String)"SituationInstanceDetails");
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.session.addListener((SessionListener)this);
        int[] weights = new int[]{50, 50};
        weights[0] = SituationsManager.safeGetInt(settings, "SituationManager.weights.0", weights[0]);
        weights[1] = SituationsManager.safeGetInt(settings, "SituationManager.weights.1", weights[1]);
        splitter.setWeights(weights);
        splitter.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int[] weights = splitter.getWeights();
                settings.put("SituationManager.weights.0", weights[0]);
                settings.put("SituationManager.weights.1", weights[1]);
            }
        });
        this.refresh(true);
    }

    private static int safeGetInt(IDialogSettings settings, String key, int defVal) {
        try {
            String v = settings.get(key);
            if (v == null) {
                return defVal;
            }
            return Integer.parseInt(v);
        }
        catch (Exception exception) {
            return defVal;
        }
    }

    private void refresh(final boolean hideOnFailure) {
        Messages.get();
        new ConsoleJob(Messages.SituationsManager_LoadJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final List list = SituationsManager.this.session.getSituations();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        for (Situation s : list) {
                            SituationsManager.this.situations.put(s.getId(), s);
                        }
                        SituationsManager.this.situationTree.setInput((Object)SituationsManager.this.situations);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SituationsManager_LoadJob_Error;
            }

            protected void jobFailureHandler() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (hideOnFailure) {
                            PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().hideView((IViewPart)SituationsManager.this);
                        }
                    }
                });
            }
        }.start();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                SituationsManager.this.refresh(false);
            }
        };
        Messages.get();
        this.actionCreate = new Action(Messages.SituationsManager_Create){

            public void run() {
                SituationsManager.this.createSituation();
            }
        };
        Messages.get();
        this.actionDelete = new Action(Messages.SituationsManager_Delete){

            public void run() {
                SituationsManager.this.deleteSelectedElements();
            }
        };
        this.actionDelete.setImageDescriptor(SharedIcons.DELETE_OBJECT);
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionCreate);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefresh);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                SituationsManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.situationTree.getControl());
        this.situationTree.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.situationTree);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.situationTree.getSelection();
        if (selection.size() > 0) {
            if (selection.size() == 1 && selection.getFirstElement() instanceof String) {
                manager.add((IAction)this.actionCreate);
            } else {
                manager.add((IAction)this.actionDelete);
            }
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IContributionItem)new GroupMarker("additions"));
    }

    public void setFocus() {
        this.situationTree.getTree().setFocus();
    }

    private void createSituation() {
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        InputDialog dlg = new InputDialog(shell, Messages.SituationsManager_CreateDlg_Title, Messages.SituationsManager_CreateDlg_Text, "", new IInputValidator(){

            public String isValid(String newText) {
                if (newText.trim().isEmpty()) {
                    Messages.get();
                    return Messages.SituationsManager_EmptyNameError;
                }
                return null;
            }
        });
        if (dlg.open() == 0) {
            final String name = dlg.getValue().trim();
            Messages.get();
            new ConsoleJob(Messages.SituationsManager_CreateJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    SituationsManager.this.session.createSituation(name, "");
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.SituationsManager_CreateJob_Error;
                }
            }.start();
        }
    }

    private void deleteSelectedElements() {
        IStructuredSelection selection = (IStructuredSelection)this.situationTree.getSelection();
        final Object[] elements = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.SituationsManager_DeleteJob_Title, (IWorkbenchPart)this, "org.netxms.ui.eclipse.epp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Object[] objectArray = elements;
                int n = elements.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (o instanceof Situation) {
                        SituationsManager.this.session.deleteSituation(((Situation)o).getId());
                    } else if (o instanceof SituationInstance) {
                        SituationsManager.this.session.deleteSituationInstance(((SituationInstance)o).getParent().getId(), ((SituationInstance)o).getName());
                    }
                    ++n2;
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SituationsManager_DeleteJob_Error;
            }
        }.start();
    }

    public void notificationHandler(final SessionNotification n) {
        if (n.getCode() == 101 || n.getCode() == 103 || n.getCode() == 102) {
            PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

                @Override
                public void run() {
                    switch (n.getCode()) {
                        case 101: 
                        case 103: {
                            SituationsManager.this.situations.put(n.getSubCode(), (Situation)n.getObject());
                            break;
                        }
                        case 102: {
                            SituationsManager.this.situations.remove(n.getSubCode());
                        }
                    }
                    SituationsManager.this.situationTree.refresh();
                }
            });
        }
    }

    public void dispose() {
        this.session.removeListener((SessionListener)this);
        super.dispose();
    }
}

