/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.datacollection.Messages;
import org.netxms.ui.eclipse.eventmanager.widgets.EventSelector;
import org.netxms.ui.eclipse.nxsl.dialogs.ScriptEditDialog;
import org.netxms.ui.eclipse.tools.NumericTextFieldValidator;
import org.netxms.ui.eclipse.tools.TextFieldValidator;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class EditThresholdDialog
extends Dialog {
    private Threshold threshold;
    private Combo function;
    private Combo operation;
    private Text samples;
    private Text value;
    private LabeledText script;
    private Group conditionGroup;
    private Composite scriptGroup;
    private EventSelector activationEvent;
    private EventSelector deactivationEvent;
    private Text repeatInterval;
    private Button repeatDefault;
    private Button repeatNever;
    private Button repeatCustom;
    private int selectedFunction;
    private String savedScript = null;
    private int savedOperation = -1;
    private String savedValue = null;

    public EditThresholdDialog(Shell parentShell, Threshold threshold) {
        super(parentShell);
        this.threshold = threshold;
        this.selectedFunction = threshold.getFunction();
    }

    protected Control createDialogArea(final Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout dialogLayout = new GridLayout();
        dialogArea.setLayout((Layout)dialogLayout);
        this.conditionGroup = new Group(dialogArea, 0);
        this.conditionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        this.conditionGroup.setText(Messages.EditThresholdDialog_Condition);
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        this.conditionGroup.setLayout((Layout)condLayout);
        Messages.get();
        this.function = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)Messages.EditThresholdDialog_Function, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_LastValue);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_AvgValue);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_MeanDeviation);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_Diff);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_DCError);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_Sum);
        Messages.get();
        this.function.add(Messages.EditThresholdDialog_Script);
        this.function.select(this.threshold.getFunction());
        this.function.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int f = EditThresholdDialog.this.function.getSelectionIndex();
                if (f != 6 && EditThresholdDialog.this.selectedFunction == 6) {
                    EditThresholdDialog.this.disposeScriptGroup();
                    EditThresholdDialog.this.createOperGroup();
                    parent.getParent().layout(true, true);
                } else if (f == 6 && EditThresholdDialog.this.selectedFunction != 6) {
                    EditThresholdDialog.this.disposeOperGroup();
                    EditThresholdDialog.this.createScriptGroup();
                    parent.getParent().layout(true, true);
                }
                EditThresholdDialog.this.selectedFunction = f;
            }
        });
        Messages.get();
        this.samples = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)60, (String)Messages.EditThresholdDialog_Samples, (String)Integer.toString(this.threshold.getSampleCount()), (Object)"WidgetHelper::default_layout_data");
        this.samples.setTextLimit(5);
        if (this.threshold.getFunction() == 6) {
            this.createScriptGroup();
        } else {
            this.createOperGroup();
        }
        Group eventGroup = new Group(dialogArea, 0);
        eventGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        eventGroup.setText(Messages.EditThresholdDialog_Event);
        GridLayout eventLayout = new GridLayout();
        eventGroup.setLayout((Layout)eventLayout);
        this.activationEvent = new EventSelector((Composite)eventGroup, 0);
        Messages.get();
        this.activationEvent.setLabel(Messages.EditThresholdDialog_ActEvent);
        this.activationEvent.setEventCode((long)this.threshold.getFireEvent());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        gd.widthHint = 450;
        this.activationEvent.setLayoutData((Object)gd);
        this.deactivationEvent = new EventSelector((Composite)eventGroup, 0);
        Messages.get();
        this.deactivationEvent.setLabel(Messages.EditThresholdDialog_DeactEvent);
        this.deactivationEvent.setEventCode((long)this.threshold.getRearmEvent());
        this.deactivationEvent.setLayoutData((Object)gd);
        Group repeatGroup = new Group(dialogArea, 0);
        repeatGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        Messages.get();
        repeatGroup.setText(Messages.EditThresholdDialog_RepeatEvent);
        GridLayout repeatLayout = new GridLayout();
        repeatLayout.numColumns = 3;
        repeatGroup.setLayout((Layout)repeatLayout);
        this.repeatDefault = new Button((Composite)repeatGroup, 16);
        Messages.get();
        this.repeatDefault.setText(Messages.EditThresholdDialog_UseDefault);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatDefault.setLayoutData((Object)gd);
        this.repeatDefault.setSelection(this.threshold.getRepeatInterval() == -1);
        this.repeatNever = new Button((Composite)repeatGroup, 16);
        Messages.get();
        this.repeatNever.setText(Messages.EditThresholdDialog_Never);
        gd = new GridData();
        gd.horizontalAlignment = 16384;
        gd.horizontalSpan = 3;
        this.repeatNever.setLayoutData((Object)gd);
        this.repeatNever.setSelection(this.threshold.getRepeatInterval() == 0);
        this.repeatCustom = new Button((Composite)repeatGroup, 16);
        Messages.get();
        this.repeatCustom.setText(Messages.EditThresholdDialog_Every);
        this.repeatCustom.setSelection(this.threshold.getRepeatInterval() > 0);
        this.repeatCustom.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditThresholdDialog.this.repeatInterval.setEnabled(EditThresholdDialog.this.repeatCustom.getSelection());
            }
        });
        this.repeatInterval = new Text((Composite)repeatGroup, 2048);
        this.repeatInterval.setTextLimit(5);
        this.repeatInterval.setText(this.threshold.getRepeatInterval() > 0 ? Integer.toString(this.threshold.getRepeatInterval()) : "3600");
        this.repeatInterval.setEnabled(this.threshold.getRepeatInterval() > 0);
        Label label = new Label((Composite)repeatGroup, 0);
        Messages.get();
        label.setText(Messages.EditThresholdDialog_Seconds);
        return dialogArea;
    }

    private void createOperGroup() {
        Messages.get();
        this.operation = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)Messages.EditThresholdDialog_Operation, (Object)"WidgetHelper::default_layout_data");
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_LT);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_LE);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_EQ);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_GE);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_GT);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_NE);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_LIKE);
        Messages.get();
        this.operation.add(Messages.EditThresholdDialog_NOTLIKE);
        this.operation.select(this.savedOperation != -1 ? this.savedOperation : this.threshold.getOperation());
        Messages.get();
        this.value = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)120, (String)Messages.EditThresholdDialog_Value, (String)(this.savedValue != null ? this.savedValue : this.threshold.getValue()), (Object)"WidgetHelper::default_layout_data");
    }

    private void disposeOperGroup() {
        this.savedOperation = this.operation.getSelectionIndex();
        this.savedValue = this.value.getText();
        this.operation.getParent().dispose();
        this.value.getParent().dispose();
    }

    private void createScriptGroup() {
        this.scriptGroup = new Composite((Composite)this.conditionGroup, 0);
        this.scriptGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false, 2, 1));
        GridLayout scriptLayout = new GridLayout();
        scriptLayout.numColumns = 2;
        scriptLayout.marginHeight = 0;
        scriptLayout.marginWidth = 0;
        scriptLayout.horizontalSpacing = 2;
        this.scriptGroup.setLayout((Layout)scriptLayout);
        this.script = new LabeledText(this.scriptGroup, 0);
        Messages.get();
        this.script.setLabel(Messages.EditThresholdDialog_Script);
        this.script.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.script.setText(this.savedScript != null ? this.savedScript : this.threshold.getScript());
        final Button editButton = new Button(this.scriptGroup, 8);
        editButton.setImage(SharedIcons.IMG_EDIT);
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 4;
        gd.heightHint = this.script.getTextControl().computeSize((int)-1, (int)-1).y;
        editButton.setLayoutData((Object)gd);
        Messages.get();
        editButton.setToolTipText(Messages.EditThresholdDialog_OpenScriptEditor);
        editButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                EditThresholdDialog.this.openScriptEditor();
            }
        });
        final Listener keyListener = new Listener(){
            private boolean disabled = false;

            public void handleEvent(Event e) {
                if ((e.stateMask & SWT.MOD1) == 262144 && e.keyCode == 101) {
                    if (this.disabled) {
                        return;
                    }
                    this.disabled = true;
                    EditThresholdDialog.this.openScriptEditor();
                    this.disabled = false;
                }
            }
        };
        editButton.getDisplay().addFilter(1, keyListener);
        editButton.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                editButton.getDisplay().removeFilter(1, keyListener);
            }
        });
    }

    private void openScriptEditor() {
        ScriptEditDialog dlg = new ScriptEditDialog(this.getShell(), this.script.getText());
        if (dlg.open() == 0) {
            this.script.setText(dlg.getScript());
        }
    }

    private void disposeScriptGroup() {
        this.savedScript = this.script.getText();
        this.scriptGroup.dispose();
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.EditThresholdDialog_Title);
    }

    protected void okPressed() {
        int rpt;
        Messages.get();
        if (!WidgetHelper.validateTextInput((Text)this.samples, (String)Messages.EditThresholdDialog_Samples, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000L), null)) {
            return;
        }
        if (this.repeatDefault.getSelection()) {
            rpt = -1;
        } else if (this.repeatNever.getSelection()) {
            rpt = 0;
        } else {
            Messages.get();
            if (!WidgetHelper.validateTextInput((Text)this.repeatInterval, (String)Messages.EditThresholdDialog_RepeatInterval, (TextFieldValidator)new NumericTextFieldValidator(1L, 1000000L), null)) {
                return;
            }
            rpt = Integer.parseInt(this.repeatInterval.getText());
        }
        this.threshold.setFunction(this.function.getSelectionIndex());
        if (this.threshold.getFunction() == 6) {
            this.threshold.setScript(this.script.getText());
        } else {
            this.threshold.setOperation(this.operation.getSelectionIndex());
            this.threshold.setValue(this.value.getText());
        }
        this.threshold.setSampleCount(Integer.parseInt(this.samples.getText()));
        this.threshold.setRepeatInterval(rpt);
        this.threshold.setFireEvent((int)this.activationEvent.getEventCode());
        this.threshold.setRearmEvent((int)this.deactivationEvent.getEventCode());
        super.okPressed();
    }
}

