/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.dashboard.widgets;

import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.dashboards.DashboardElement;
import org.netxms.client.objects.Dashboard;
import org.netxms.ui.eclipse.dashboard.widgets.DashboardControl;
import org.netxms.ui.eclipse.dashboard.widgets.ElementWidget;
import org.netxms.ui.eclipse.dashboard.widgets.internal.EmbeddedDashboardConfig;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class EmbeddedDashboardElement
extends ElementWidget {
    private Dashboard[] objects;
    private EmbeddedDashboardConfig config;
    private DashboardControl control = null;
    private int current = -1;

    public EmbeddedDashboardElement(DashboardControl parent, DashboardElement element, IViewPart viewPart) {
        super(parent, 0, element, viewPart);
        try {
            this.config = EmbeddedDashboardConfig.createFromXml(element.getData());
        }
        catch (Exception e) {
            e.printStackTrace();
            this.config = new EmbeddedDashboardConfig();
        }
        NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        this.objects = new Dashboard[this.config.getDashboardObjects().length];
        int i = 0;
        while (i < this.objects.length) {
            this.objects[i] = (Dashboard)session.findObjectById(this.config.getDashboardObjects()[i], Dashboard.class);
            ++i;
        }
        FillLayout layout = new FillLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.setLayout((Layout)layout);
        if (this.objects.length > 1) {
            this.nextDashboard();
        } else if (this.objects != null && this.objects.length > 0 && this.objects[0] != null) {
            new DashboardControl((Composite)this, 0, this.objects[0], viewPart, true);
        }
    }

    private void nextDashboard() {
        if (this.control != null) {
            this.control.dispose();
        }
        ++this.current;
        if (this.current >= this.objects.length) {
            this.current = 0;
        }
        this.control = this.objects[this.current] != null ? new DashboardControl((Composite)this, 0, this.objects[this.current], this.viewPart, true) : null;
        this.getParent().layout(true, true);
        this.getDisplay().timerExec(this.config.getDisplayInterval() * 1000, new Runnable(){

            @Override
            public void run() {
                if (EmbeddedDashboardElement.this.isDisposed()) {
                    return;
                }
                EmbeddedDashboardElement.this.nextDashboard();
            }
        });
    }
}

