/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.snmp.dialogs;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.netxms.client.NXCSession;
import org.netxms.client.snmp.SnmpObjectId;
import org.netxms.client.snmp.SnmpValue;
import org.netxms.client.snmp.SnmpWalkListener;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.snmp.Activator;
import org.netxms.ui.eclipse.snmp.Messages;
import org.netxms.ui.eclipse.snmp.views.helpers.SnmpValueLabelProvider;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class MibWalkDialog
extends Dialog
implements SnmpWalkListener {
    private long nodeId;
    private SnmpObjectId rootObject;
    private TableViewer viewer;
    private List<SnmpValue> walkData = new ArrayList<SnmpValue>();
    private SnmpValue value;

    public MibWalkDialog(Shell parentShell, long nodeId, SnmpObjectId rootObject) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.nodeId = nodeId;
        this.rootObject = rootObject;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.MibWalkDialog_Title);
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            newShell.setSize(settings.getInt("MibWalkDialog.cx"), settings.getInt("MibWalkDialog.cy"));
        }
        catch (NumberFormatException numberFormatException) {}
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 5;
        layout.horizontalSpacing = 5;
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        dialogArea.setLayout((Layout)layout);
        this.viewer = new TableViewer(dialogArea, 67588);
        this.viewer.getTable().setLinesVisible(true);
        this.viewer.getTable().setHeaderVisible(true);
        this.setupViewerColumns();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new SnmpValueLabelProvider());
        this.viewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveColumnSettings((Table)MibWalkDialog.this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"MibWalkDialog");
            }
        });
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.verticalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.grabExcessVerticalSpace = true;
        gd.widthHint = 600;
        gd.heightHint = 400;
        this.viewer.getTable().setLayoutData((Object)gd);
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                MibWalkDialog.this.okPressed();
            }
        });
        return dialogArea;
    }

    private void setupViewerColumns() {
        TableColumn tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_OID);
        tc.setWidth(300);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_Type);
        tc.setWidth(100);
        tc = new TableColumn(this.viewer.getTable(), 16384);
        Messages.get();
        tc.setText(Messages.MibExplorer_Value);
        tc.setWidth(300);
        WidgetHelper.restoreColumnSettings((Table)this.viewer.getTable(), (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)"MibWalkDialog");
    }

    public void create() {
        super.create();
        this.startWalk();
    }

    protected void cancelPressed() {
        this.saveSettings();
        super.cancelPressed();
    }

    protected void okPressed() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        this.value = (SnmpValue)selection.getFirstElement();
        this.saveSettings();
        super.okPressed();
    }

    private void saveSettings() {
        Point size = this.getShell().getSize();
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        settings.put("MibWalkDialog.cx", size.x);
        settings.put("MibWalkDialog.cy", size.y);
    }

    private void startWalk() {
        this.getButton(0).setEnabled(false);
        this.getButton(1).setEnabled(false);
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.MibExplorer_WalkJob_Title, null, "org.netxms.ui.eclipse.snmp", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.snmpWalk(MibWalkDialog.this.nodeId, MibWalkDialog.this.rootObject.toString(), (SnmpWalkListener)MibWalkDialog.this);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.MibExplorer_WalkJob_Error;
            }

            protected void jobFinalize() {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        MibWalkDialog.this.getButton(0).setEnabled(true);
                        MibWalkDialog.this.getButton(1).setEnabled(true);
                    }
                });
            }
        }.start();
    }

    public void onSnmpWalkData(final List<SnmpValue> data) {
        this.viewer.getControl().getDisplay().asyncExec(new Runnable(){

            @Override
            public void run() {
                MibWalkDialog.this.walkData.addAll(data);
                MibWalkDialog.this.viewer.setInput((Object)MibWalkDialog.this.walkData.toArray());
                try {
                    MibWalkDialog.this.viewer.getTable().showItem(MibWalkDialog.this.viewer.getTable().getItem(MibWalkDialog.this.viewer.getTable().getItemCount() - 1));
                }
                catch (Exception exception) {}
            }
        });
    }

    public SnmpValue getValue() {
        return this.value;
    }
}

