/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;

public class PhysicalComponent {
    public static final int OTHER = 1;
    public static final int UNKNOWN = 2;
    public static final int CHASSIS = 3;
    public static final int BACKPLANE = 4;
    public static final int CONTAINER = 5;
    public static final int PSU = 6;
    public static final int FAN = 7;
    public static final int SENSOR = 8;
    public static final int MODULE = 9;
    public static final int PORT = 10;
    public static final int STACK = 11;
    private int index;
    private int parentIndex;
    private int ifIndex;
    private int phyClass;
    private String name;
    private String description;
    private String model;
    private String serialNumber;
    private String firmware;
    private String vendor;
    private PhysicalComponent parent;
    private List<PhysicalComponent> subcomponents;
    private long nextVarId;

    protected PhysicalComponent(NXCPMessage msg, long baseId, PhysicalComponent parent) {
        this.parent = parent;
        this.index = msg.getVariableAsInteger(baseId);
        this.parentIndex = msg.getVariableAsInteger(baseId + 1L);
        this.phyClass = msg.getVariableAsInteger(baseId + 2L);
        this.ifIndex = msg.getVariableAsInteger(baseId + 3L);
        this.name = msg.getVariableAsString(baseId + 4L);
        this.description = msg.getVariableAsString(baseId + 5L);
        this.model = msg.getVariableAsString(baseId + 6L);
        this.serialNumber = msg.getVariableAsString(baseId + 7L);
        this.vendor = msg.getVariableAsString(baseId + 8L);
        this.firmware = msg.getVariableAsString(baseId + 9L);
        int count2 = msg.getVariableAsInteger(baseId + 10L);
        this.subcomponents = new ArrayList<PhysicalComponent>(count2);
        long varId = baseId + 11L;
        for (int i = 0; i < count2; ++i) {
            PhysicalComponent c = new PhysicalComponent(msg, varId, this);
            varId = c.nextVarId;
            this.subcomponents.add(c);
        }
        this.nextVarId = varId;
    }

    public int getIndex() {
        return this.index;
    }

    public int getParentIndex() {
        return this.parentIndex;
    }

    public int getIfIndex() {
        return this.ifIndex;
    }

    public int getPhyClass() {
        return this.phyClass;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getModel() {
        return this.model;
    }

    public String getSerialNumber() {
        return this.serialNumber;
    }

    public String getFirmware() {
        return this.firmware;
    }

    public String getVendor() {
        return this.vendor;
    }

    public List<PhysicalComponent> getSubcomponents() {
        return this.subcomponents;
    }

    public PhysicalComponent getParent() {
        return this.parent;
    }
}

