/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.ArrayList;
import java.util.List;
import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DciListConfig;
import org.netxms.client.maps.configs.SingleDciConfig;

public class NetworkMapLink {
    public static final int NORMAL = 0;
    public static final int VPN = 1;
    public static final int MULTILINK = 2;
    public static final int ROUTING_DEFAULT = 0;
    public static final int ROUTING_DIRECT = 1;
    public static final int ROUTING_MANHATTAN = 2;
    public static final int ROUTING_BENDPOINTS = 3;
    private String name;
    private int type;
    private long element1;
    private long element2;
    private String connectorName1;
    private String connectorName2;
    private int color;
    private long statusObject;
    private int routing;
    private long[] bendPoints;
    private String config;
    private int flags;
    private SingleDciConfig[] dciList;

    public NetworkMapLink(String name, int type, long element1, long element2, String connectorName1, String connectorName2, SingleDciConfig[] dciList, int flags) {
        try {
            DciListConfig conf = new DciListConfig();
            conf.setDciList(dciList);
            this.config = conf.createXml();
        }
        catch (Exception e) {
            System.out.println("Impossible to create data from giver sources");
        }
        this.initData(name, type, element1, element2, connectorName1, connectorName2, this.config, flags);
    }

    public NetworkMapLink(String name, int type, long element1, long element2, String connectorName1, String connectorName2, String config, int flags) {
        this.initData(name, type, element1, element2, connectorName1, connectorName2, config, flags);
    }

    public void initData(String name, int type, long element1, long element2, String connectorName1, String connectorName2, String config, int flags) {
        this.name = name;
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = connectorName1;
        this.connectorName2 = connectorName2;
        this.color = -1;
        this.statusObject = 0L;
        this.routing = 0;
        this.bendPoints = null;
        this.config = config;
        this.flags = flags;
        try {
            this.dciList = DciListConfig.createFromXml(config).getDciList();
        }
        catch (Exception e1) {
            this.dciList = null;
        }
    }

    public NetworkMapLink(int type, long element1, long element2) {
        this.name = "";
        this.type = type;
        this.element1 = element1;
        this.element2 = element2;
        this.connectorName1 = "";
        this.connectorName2 = "";
        this.color = -1;
        this.statusObject = 0L;
        this.routing = 0;
        this.bendPoints = null;
        this.config = "";
        this.flags = 0;
        this.dciList = null;
    }

    public NetworkMapLink(NXCPMessage msg, long baseId) {
        this.name = msg.getVariableAsString(baseId + 1L);
        this.type = msg.getVariableAsInteger(baseId);
        this.element1 = msg.getVariableAsInt64(baseId + 4L);
        this.element2 = msg.getVariableAsInt64(baseId + 5L);
        this.connectorName1 = msg.getVariableAsString(baseId + 2L);
        this.connectorName2 = msg.getVariableAsString(baseId + 3L);
        this.color = msg.getVariableAsInteger(baseId + 6L);
        this.statusObject = msg.getVariableAsInt64(baseId + 7L);
        this.routing = msg.getVariableAsInteger(baseId + 8L);
        this.bendPoints = msg.getVariableAsUInt32Array(baseId + 9L);
        this.config = msg.getVariableAsString(baseId + 10L);
        this.flags = msg.getVariableAsInteger(baseId + 11L);
        try {
            this.dciList = DciListConfig.createFromXml(this.config).getDciList();
        }
        catch (Exception e1) {
            this.dciList = null;
        }
    }

    public void fillMessage(NXCPMessage msg, long baseId) {
        long[] lArray;
        msg.setVariableInt16(baseId, this.type);
        msg.setVariable(baseId + 1L, this.name);
        msg.setVariable(baseId + 2L, this.connectorName1);
        msg.setVariable(baseId + 3L, this.connectorName2);
        msg.setVariableInt32(baseId + 4L, (int)this.element1);
        msg.setVariableInt32(baseId + 5L, (int)this.element2);
        msg.setVariableInt32(baseId + 6L, this.color);
        msg.setVariableInt32(baseId + 7L, (int)this.statusObject);
        msg.setVariableInt16(baseId + 8L, this.routing);
        if (this.bendPoints != null) {
            lArray = this.bendPoints;
        } else {
            long[] lArray2 = new long[2];
            lArray2[0] = Integer.MAX_VALUE;
            lArray = lArray2;
            lArray2[1] = Integer.MAX_VALUE;
        }
        msg.setVariable(baseId + 9L, lArray);
        msg.setVariable(baseId + 10L, this.config);
        msg.setVariableInt32(baseId + 11L, this.flags);
    }

    public int getType() {
        return this.type;
    }

    public long getElement1() {
        return this.element1;
    }

    public long getElement2() {
        return this.element2;
    }

    public String getConnectorName1() {
        return this.connectorName1;
    }

    public String getConnectorName2() {
        return this.connectorName2;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        if (this.isUnnamed()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(this.name);
            sb.append(" (");
        }
        sb.append(this.connectorName1 != null && !this.connectorName1.isEmpty() ? this.connectorName1 : "<noname>");
        sb.append(" - ");
        sb.append(this.connectorName2 != null && !this.connectorName2.isEmpty() ? this.connectorName2 : "<noname>");
        if (this.name != null && !this.name.isEmpty()) {
            sb.append(')');
        }
        return sb.toString();
    }

    public boolean hasName() {
        return this.name != null && !this.name.isEmpty();
    }

    public boolean hasConnectorName1() {
        return this.connectorName1 != null && !this.connectorName1.isEmpty();
    }

    public boolean hasConnectorName2() {
        return this.connectorName2 != null && !this.connectorName2.isEmpty();
    }

    public boolean isUnnamed() {
        return !(this.name != null && !this.name.isEmpty() || this.connectorName1 != null && !this.connectorName1.isEmpty() || this.connectorName2 != null && !this.connectorName2.isEmpty());
    }

    public boolean equals(Object obj) {
        if (obj instanceof NetworkMapLink) {
            return ((NetworkMapLink)obj).element1 == this.element1 && ((NetworkMapLink)obj).element2 == this.element2;
        }
        return super.equals(obj);
    }

    public int hashCode() {
        return (int)(this.element1 << 16 | this.element2 & 0xFFFFL);
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int color) {
        this.color = color;
    }

    public long getStatusObject() {
        return this.statusObject;
    }

    public void setStatusObject(long statusObject) {
        this.statusObject = statusObject;
    }

    public int getRouting() {
        return this.routing;
    }

    public void setRouting(int routing) {
        this.routing = routing;
    }

    public long[] getBendPoints() {
        return this.bendPoints;
    }

    public void setBendPoints(long[] bendPoints) {
        this.bendPoints = bendPoints;
    }

    public String getConfig() {
        return this.config;
    }

    public void setConfig(String config) {
        this.config = config;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public boolean hasDciData() {
        return this.dciList != null && this.dciList.length > 0;
    }

    public SingleDciConfig[] getDciList() {
        if (this.hasDciData()) {
            return this.dciList;
        }
        return null;
    }

    public List<SingleDciConfig> getDciAsList() {
        ArrayList<SingleDciConfig> dciList = new ArrayList<SingleDciConfig>();
        if (this.hasDciData()) {
            for (SingleDciConfig dci : this.getDciList()) {
                dciList.add(new SingleDciConfig(dci));
            }
        }
        return dciList;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setConnectorName1(String connectorName1) {
        this.connectorName1 = connectorName1;
    }

    public void setConnectorName2(String connectorName2) {
        this.connectorName2 = connectorName2;
    }

    public String toString() {
        return "NetworkMapLink [name=" + this.name + ", type=" + this.type + ", element1=" + this.element1 + ", element2=" + this.element2 + ", connectorName1=" + this.connectorName1 + ", connectorName2=" + this.connectorName2 + ", color=" + this.color + ", statusObject=" + this.statusObject + ", routing=" + this.routing + ", flags=" + this.flags + "]";
    }
}

