/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.base.NXCommon;
import org.netxms.client.AccessListElement;
import org.netxms.client.NXCSession;

public abstract class AbstractObject {
    public static final int NETWORK = 1;
    public static final int SERVICEROOT = 2;
    public static final int TEMPLATEROOT = 3;
    public static final int ZONE0 = 4;
    public static final int POLICYROOT = 5;
    public static final int NETWORKMAPROOT = 6;
    public static final int DASHBOARDROOT = 7;
    public static final int REPORTROOT = 8;
    public static final int BUSINESSSERVICEROOT = 9;
    public static final int OBJECT_GENERIC = 0;
    public static final int OBJECT_SUBNET = 1;
    public static final int OBJECT_NODE = 2;
    public static final int OBJECT_INTERFACE = 3;
    public static final int OBJECT_NETWORK = 4;
    public static final int OBJECT_CONTAINER = 5;
    public static final int OBJECT_ZONE = 6;
    public static final int OBJECT_SERVICEROOT = 7;
    public static final int OBJECT_TEMPLATE = 8;
    public static final int OBJECT_TEMPLATEGROUP = 9;
    public static final int OBJECT_TEMPLATEROOT = 10;
    public static final int OBJECT_NETWORKSERVICE = 11;
    public static final int OBJECT_VPNCONNECTOR = 12;
    public static final int OBJECT_CONDITION = 13;
    public static final int OBJECT_CLUSTER = 14;
    public static final int OBJECT_POLICYGROUP = 15;
    public static final int OBJECT_POLICYROOT = 16;
    public static final int OBJECT_AGENTPOLICY = 17;
    public static final int OBJECT_AGENTPOLICY_CONFIG = 18;
    public static final int OBJECT_NETWORKMAPROOT = 19;
    public static final int OBJECT_NETWORKMAPGROUP = 20;
    public static final int OBJECT_NETWORKMAP = 21;
    public static final int OBJECT_DASHBOARDROOT = 22;
    public static final int OBJECT_DASHBOARD = 23;
    public static final int OBJECT_BUSINESSSERVICEROOT = 27;
    public static final int OBJECT_BUSINESSSERVICE = 28;
    public static final int OBJECT_NODELINK = 29;
    public static final int OBJECT_SLMCHECK = 30;
    public static final int OBJECT_MOBILEDEVICE = 31;
    public static final int OBJECT_RACK = 32;
    public static final int OBJECT_ACCESSPOINT = 33;
    public static final int OBJECT_CUSTOM = 10000;
    public static final int CALCULATE_DEFAULT = 0;
    public static final int CALCULATE_MOST_CRITICAL = 1;
    public static final int CALCULATE_SINGLE_THRESHOLD = 2;
    public static final int CALCULATE_MULTIPLE_THRESHOLDS = 3;
    public static final int PROPAGATE_DEFAULT = 0;
    public static final int PROPAGATE_UNCHANGED = 1;
    public static final int PROPAGATE_FIXED = 2;
    public static final int PROPAGATE_RELATIVE = 3;
    public static final int PROPAGATE_TRANSLATED = 4;
    protected NXCSession session = null;
    protected long objectId = 0L;
    protected UUID guid;
    protected String objectName;
    protected int objectClass;
    protected int status = 5;
    protected boolean isDeleted = false;
    protected InetAddress primaryIP;
    protected String comments;
    protected GeoLocation geolocation;
    protected UUID image;
    protected long submapId;
    protected HashSet<Long> trustedNodes = new HashSet(0);
    protected boolean inheritAccessRights = true;
    protected HashSet<AccessListElement> accessList = new HashSet(0);
    protected int statusCalculationMethod;
    protected int statusPropagationMethod;
    protected int fixedPropagatedStatus;
    protected int statusShift;
    protected int[] statusTransformation;
    protected int statusSingleThreshold;
    protected int[] statusThresholds;
    protected HashSet<Long> parents = new HashSet(0);
    protected HashSet<Long> children = new HashSet(0);
    protected Map<String, String> customAttributes = new HashMap<String, String>(0);
    private int effectiveRights = 0;
    private boolean effectiveRightsCached = false;

    protected AbstractObject(long id, NXCSession session) {
        this.objectId = id;
        this.session = session;
        this.guid = UUID.randomUUID();
        this.objectName = "unknown";
        this.objectClass = 0;
        try {
            this.primaryIP = InetAddress.getByName("0.0.0.0");
        }
        catch (UnknownHostException e) {
            // empty catch block
        }
        this.comments = "";
        this.geolocation = new GeoLocation(false);
        this.image = NXCommon.EMPTY_GUID;
        this.statusCalculationMethod = 0;
        this.statusPropagationMethod = 0;
        this.fixedPropagatedStatus = 0;
        this.statusShift = 0;
        this.statusTransformation = new int[4];
        this.statusTransformation[0] = 1;
        this.statusTransformation[1] = 2;
        this.statusTransformation[2] = 3;
        this.statusTransformation[3] = 4;
        this.statusSingleThreshold = 75;
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = 75;
        this.statusThresholds[1] = 75;
        this.statusThresholds[2] = 75;
        this.statusThresholds[3] = 75;
    }

    public AbstractObject(NXCPMessage msg, NXCSession session) {
        this.session = session;
        this.objectId = msg.getVariableAsInteger(3L);
        this.guid = msg.getVariableAsUUID(222L);
        this.objectName = msg.getVariableAsString(4L);
        this.objectClass = msg.getVariableAsInteger(5L);
        this.primaryIP = msg.getVariableAsInetAddress(8L);
        this.isDeleted = msg.getVariableAsBoolean(30L);
        this.status = msg.getVariableAsInteger(10L);
        this.comments = msg.getVariableAsString(82L);
        this.geolocation = new GeoLocation(msg);
        this.image = msg.getVariableAsUUID(379L);
        this.submapId = msg.getVariableAsInt64(389L);
        if (this.image == null) {
            this.image = NXCommon.EMPTY_GUID;
        }
        this.statusCalculationMethod = msg.getVariableAsInteger(160L);
        this.statusPropagationMethod = msg.getVariableAsInteger(183L);
        this.fixedPropagatedStatus = msg.getVariableAsInteger(184L);
        this.statusShift = msg.getVariableAsInteger(185L);
        this.statusTransformation = new int[4];
        this.statusTransformation[0] = msg.getVariableAsInteger(186L);
        this.statusTransformation[1] = msg.getVariableAsInteger(187L);
        this.statusTransformation[2] = msg.getVariableAsInteger(188L);
        this.statusTransformation[3] = msg.getVariableAsInteger(189L);
        this.statusSingleThreshold = msg.getVariableAsInteger(190L);
        this.statusThresholds = new int[4];
        this.statusThresholds[0] = msg.getVariableAsInteger(191L);
        this.statusThresholds[1] = msg.getVariableAsInteger(192L);
        this.statusThresholds[2] = msg.getVariableAsInteger(193L);
        this.statusThresholds[3] = msg.getVariableAsInteger(194L);
        if (this.statusShift > Short.MAX_VALUE) {
            this.statusShift -= 65536;
        }
        int count2 = msg.getVariableAsInteger(7L);
        int i = 0;
        long id = 12288L;
        while (i < count2) {
            this.parents.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count2 = msg.getVariableAsInteger(31L);
        i = 0;
        id = 0x80000000L;
        while (i < count2) {
            this.children.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count2 = msg.getVariableAsInteger(306L);
        if (count2 > 0) {
            Long[] nodes = msg.getVariableAsUInt32ArrayEx(307L);
            this.trustedNodes.addAll(Arrays.asList(nodes));
        }
        i = 0;
        id = 0x80000000L;
        while (i < count2) {
            this.children.add(msg.getVariableAsInt64(id));
            ++i;
            ++id;
        }
        count2 = msg.getVariableAsInteger(309L);
        i = 0;
        id = 0x70000000L;
        while (i < count2) {
            this.customAttributes.put(msg.getVariableAsString(id), msg.getVariableAsString(id + 1L));
            ++i;
            id += 2L;
        }
        this.inheritAccessRights = msg.getVariableAsBoolean(33L);
        count2 = msg.getVariableAsInteger(32L);
        i = 0;
        id = 4096L;
        long id2 = 8192L;
        while (i < count2) {
            this.accessList.add(new AccessListElement(msg.getVariableAsInt64(id), msg.getVariableAsInteger(id2)));
            ++i;
            ++id;
            ++id2;
        }
    }

    public boolean isDefaultImage() {
        return this.image.equals(NXCommon.EMPTY_GUID);
    }

    public int getParentCount() {
        return this.parents.size();
    }

    public Iterator<Long> getParents() {
        return this.parents.iterator();
    }

    public Iterator<Long> getChildren() {
        return this.children.iterator();
    }

    public AccessListElement[] getAccessList() {
        return this.accessList.toArray(new AccessListElement[this.accessList.size()]);
    }

    public String getComments() {
        return this.comments;
    }

    public long getObjectId() {
        return this.objectId;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public InetAddress getPrimaryIP() {
        return this.primaryIP;
    }

    public int getStatus() {
        return this.status;
    }

    public boolean isDeleted() {
        return this.isDeleted;
    }

    public boolean isInheritAccessRights() {
        return this.inheritAccessRights;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id == objectId) {
                    rc = true;
                    break;
                }
                AbstractObject object = this.session.findObjectById(id);
                if (object == null || !object.isChildOf(objectId)) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    public boolean isChildOf(long[] objects) {
        for (int i = 0; i < objects.length; ++i) {
            if (!this.isChildOf(objects[i])) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDirectChildOf(long objectId) {
        boolean rc = false;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            for (long id : this.parents) {
                if (id != objectId) continue;
                rc = true;
                break;
            }
        }
        return rc;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getParentsAsArray() {
        HashSet<AbstractObject> list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new HashSet<AbstractObject>(this.children.size());
            Iterator<Long> it = this.parents.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getChildsAsArray() {
        HashSet<AbstractObject> list;
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            list = new HashSet<AbstractObject>(this.children.size());
            Iterator<Long> it = this.children.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                list.add(obj);
            }
        }
        return list.toArray(new AbstractObject[list.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getChildIdList() {
        long[] list;
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            list = new long[this.children.size()];
            int i = 0;
            for (Long id : this.children) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long[] getParentIdList() {
        long[] list;
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            list = new long[this.parents.size()];
            int i = 0;
            for (Long id : this.parents) {
                list[i++] = id;
            }
        }
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllChildsInternal(int classFilter, Set<AbstractObject> set) {
        HashSet<Long> hashSet = this.children;
        synchronized (hashSet) {
            Iterator<Long> it = this.children.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                if (classFilter == -1 || obj.getObjectClass() == classFilter) {
                    set.add(obj);
                }
                obj.getAllChildsInternal(classFilter, set);
            }
        }
    }

    public Set<AbstractObject> getAllChilds(int classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllChildsInternal(classFilter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getAllParentsInternal(int classFilter, Set<AbstractObject> set) {
        HashSet<Long> hashSet = this.parents;
        synchronized (hashSet) {
            Iterator<Long> it = this.parents.iterator();
            while (it.hasNext()) {
                AbstractObject obj = this.session.findObjectById(it.next());
                if (obj == null) continue;
                if (classFilter == -1 || obj.getObjectClass() == classFilter) {
                    set.add(obj);
                }
                obj.getAllParentsInternal(classFilter, set);
            }
        }
    }

    public Set<AbstractObject> getAllParents(int classFilter) {
        HashSet<AbstractObject> result = new HashSet<AbstractObject>();
        this.getAllParentsInternal(classFilter, result);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractObject[] getTrustedNodes() {
        AbstractObject[] list;
        HashSet<Long> hashSet = this.trustedNodes;
        synchronized (hashSet) {
            list = new AbstractObject[this.trustedNodes.size()];
            Iterator<Long> it = this.trustedNodes.iterator();
            int i = 0;
            while (it.hasNext()) {
                list[i] = this.session.findObjectById(it.next());
                ++i;
            }
        }
        return list;
    }

    public boolean hasParents() {
        return this.parents.size() > 0;
    }

    public boolean hasChildren() {
        return this.children.size() > 0;
    }

    public boolean hasAccessibleChildren() {
        for (Long id : this.children) {
            if (this.session.findObjectById(id) == null) continue;
            return true;
        }
        return false;
    }

    public boolean isAllowedOnMap() {
        return false;
    }

    public int getObjectClass() {
        return this.objectClass;
    }

    public String getObjectClassName() {
        return "Class " + Integer.toString(this.objectClass);
    }

    public Map<String, String> getCustomAttributes() {
        return this.customAttributes;
    }

    public GeoLocation getGeolocation() {
        return this.geolocation;
    }

    public int hashCode() {
        return (int)this.objectId;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public UUID getImage() {
        return this.image;
    }

    public long getSubmapId() {
        return this.submapId;
    }

    public int getStatusCalculationMethod() {
        return this.statusCalculationMethod;
    }

    public int getStatusPropagationMethod() {
        return this.statusPropagationMethod;
    }

    public int getFixedPropagatedStatus() {
        return this.fixedPropagatedStatus;
    }

    public int getStatusShift() {
        return this.statusShift;
    }

    public int[] getStatusTransformation() {
        return this.statusTransformation;
    }

    public int getStatusSingleThreshold() {
        return this.statusSingleThreshold;
    }

    public int[] getStatusThresholds() {
        return this.statusThresholds;
    }

    public final void setSession(NXCSession session) {
        this.session = session;
    }

    public int getEffectiveRights() {
        if (this.effectiveRightsCached) {
            return this.effectiveRights;
        }
        try {
            this.effectiveRights = this.session.getEffectiveRights(this.objectId);
            this.effectiveRightsCached = true;
        }
        catch (Exception e) {
            this.effectiveRights = 0;
        }
        return this.effectiveRights;
    }
}

