/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.objects;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.netxms.base.GeoLocation;
import org.netxms.base.NXCPMessage;
import org.netxms.client.NXCSession;
import org.netxms.client.maps.MapLayoutAlgorithm;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.NetworkMapPage;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.objects.GenericObject;

public class NetworkMap
extends GenericObject {
    public static final UUID GEOMAP_BACKGROUND = UUID.fromString("ffffffff-ffff-ffff-ffff-ffffffffffff");
    public static final int TYPE_CUSTOM = 0;
    public static final int TYPE_LAYER2_TOPOLOGY = 1;
    public static final int TYPE_IP_TOPOLOGY = 2;
    public static final int MF_SHOW_STATUS_ICON = 1;
    public static final int MF_SHOW_STATUS_FRAME = 2;
    public static final int MF_SHOW_STATUS_BKGND = 4;
    public static final int MF_SHOW_END_NODES = 8;
    public static final int MF_CALCULATE_STATUS = 16;
    private int mapType;
    private MapLayoutAlgorithm layout;
    private int flags;
    private UUID background;
    private GeoLocation backgroundLocation;
    private int backgroundZoom;
    private long seedObjectId;
    private int defaultLinkColor;
    private int defaultLinkRouting;
    private int backgroundColor;
    private int discoveryRadius;
    private String filter;
    private List<NetworkMapElement> elements;
    private List<NetworkMapLink> links;

    public NetworkMap(NXCPMessage msg, NXCSession session) {
        super(msg, session);
        int i;
        this.mapType = msg.getVariableAsInteger(357L);
        this.layout = MapLayoutAlgorithm.getByValue(msg.getVariableAsInteger(358L));
        this.flags = msg.getVariableAsInteger(13L);
        this.background = msg.getVariableAsUUID(360L);
        this.backgroundLocation = new GeoLocation(msg.getVariableAsReal(385L), msg.getVariableAsReal(386L));
        this.backgroundZoom = msg.getVariableAsInteger(387L);
        this.seedObjectId = msg.getVariableAsInt64(359L);
        this.defaultLinkColor = msg.getVariableAsInteger(417L);
        this.defaultLinkRouting = msg.getVariableAsInteger(423L);
        this.backgroundColor = msg.getVariableAsInteger(424L);
        this.discoveryRadius = msg.getVariableAsInteger(426L);
        this.filter = msg.getVariableAsString(232L);
        int count2 = msg.getVariableAsInteger(361L);
        this.elements = new ArrayList<NetworkMapElement>(count2);
        long varId = 0x10000000L;
        for (i = 0; i < count2; ++i) {
            this.elements.add(NetworkMapElement.createMapElement(msg, varId));
            varId += 100L;
        }
        count2 = msg.getVariableAsInteger(214L);
        this.links = new ArrayList<NetworkMapLink>(count2);
        varId = 0x40000000L;
        for (i = 0; i < count2; ++i) {
            this.links.add(new NetworkMapLink(msg, varId));
            varId += 20L;
        }
    }

    @Override
    public String getObjectClassName() {
        return "NetworkMap";
    }

    @Override
    public boolean isAllowedOnMap() {
        return true;
    }

    public int getMapType() {
        return this.mapType;
    }

    public MapLayoutAlgorithm getLayout() {
        return this.layout;
    }

    public UUID getBackground() {
        return this.background;
    }

    public long getSeedObjectId() {
        return this.seedObjectId;
    }

    public NetworkMapPage createMapPage() {
        NetworkMapPage page = new NetworkMapPage(this.getObjectName());
        page.addAllElements(this.elements);
        page.addAllLinks(this.links);
        return page;
    }

    public GeoLocation getBackgroundLocation() {
        return this.backgroundLocation;
    }

    public int getBackgroundZoom() {
        return this.backgroundZoom;
    }

    public int getFlags() {
        return this.flags;
    }

    public int getDefaultLinkColor() {
        return this.defaultLinkColor;
    }

    public int getDefaultLinkRouting() {
        return this.defaultLinkRouting;
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public final int getDiscoveryRadius() {
        return this.discoveryRadius;
    }

    public String getFilter() {
        return this.filter;
    }
}

