/*
 * Decompiled with CFR 0.152.
 */
package org.python.google.common.net;

import com.google.common.annotations.Beta;
import java.io.Serializable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;
import org.python.google.common.base.Objects;
import org.python.google.common.base.Preconditions;

@Beta
@Immutable
public final class HostAndPort
implements Serializable {
    private static final int NO_PORT = -1;
    private final String host;
    private final int port;
    private final boolean hasBracketlessColons;
    private static final Pattern BRACKET_PATTERN = Pattern.compile("^\\[(.*:.*)\\](?::(\\d*))?$");
    private static final long serialVersionUID = 0L;

    private HostAndPort(String host, int port, boolean hasBracketlessColons) {
        this.host = host;
        this.port = port;
        this.hasBracketlessColons = hasBracketlessColons;
    }

    public String getHostText() {
        return this.host;
    }

    public boolean hasPort() {
        return this.port >= 0;
    }

    public int getPort() {
        Preconditions.checkState(this.hasPort());
        return this.port;
    }

    public int getPortOrDefault(int defaultPort) {
        return this.hasPort() ? this.port : defaultPort;
    }

    public static HostAndPort fromParts(String host, int port) {
        Preconditions.checkArgument(HostAndPort.isValidPort(port));
        HostAndPort parsedHost = HostAndPort.fromString(host);
        Preconditions.checkArgument(!parsedHost.hasPort());
        return new HostAndPort(parsedHost.host, port, parsedHost.hasBracketlessColons);
    }

    /*
     * WARNING - void declaration
     */
    public static HostAndPort fromString(String hostPortString) {
        void port;
        String host;
        Preconditions.checkNotNull(hostPortString);
        Object var1_1 = null;
        boolean portString = false;
        if (hostPortString.startsWith("[")) {
            Matcher hasBracketlessColons = BRACKET_PATTERN.matcher(hostPortString);
            Preconditions.checkArgument(hasBracketlessColons.matches(), "Invalid bracketed host/port: %s", hostPortString);
            String matcher = hasBracketlessColons.group(1);
            host = hasBracketlessColons.group(2);
        } else {
            String colonPos;
            int hasBracketlessColons = hostPortString.indexOf(58);
            if (hasBracketlessColons >= 0 && hostPortString.indexOf(58, hasBracketlessColons + 1) == -1) {
                colonPos = hostPortString.substring(0, hasBracketlessColons);
                host = hostPortString.substring(hasBracketlessColons + 1);
            } else {
                colonPos = hostPortString;
                portString = hasBracketlessColons >= 0;
            }
        }
        int hasBracketlessColons = -1;
        if (host != null) {
            Preconditions.checkArgument(!host.startsWith("+"), "Unparseable port number: %s", hostPortString);
            try {
                hasBracketlessColons = Integer.parseInt(host);
            }
            catch (NumberFormatException e) {
                throw new IllegalArgumentException("Unparseable port number: " + hostPortString);
            }
            Preconditions.checkArgument(HostAndPort.isValidPort(hasBracketlessColons), "Port number out of range: %s", hostPortString);
        }
        return new HostAndPort((String)port, hasBracketlessColons, portString);
    }

    public HostAndPort withDefaultPort(int defaultPort) {
        Preconditions.checkArgument(HostAndPort.isValidPort(defaultPort));
        if (this.hasPort() || this.port == defaultPort) {
            return this;
        }
        return new HostAndPort(this.host, defaultPort, this.hasBracketlessColons);
    }

    public HostAndPort requireBracketsForIPv6() {
        Preconditions.checkArgument(!this.hasBracketlessColons, "Possible bracketless IPv6 literal: %s", this.host);
        return this;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (other instanceof HostAndPort) {
            HostAndPort that = (HostAndPort)other;
            return Objects.equal(this.host, that.host) && this.port == that.port && this.hasBracketlessColons == that.hasBracketlessColons;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode(this.host, this.port, this.hasBracketlessColons);
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.host.length() + 7);
        if (this.host.indexOf(58) >= 0) {
            builder.append('[').append(this.host).append(']');
        } else {
            builder.append(this.host);
        }
        if (this.hasPort()) {
            builder.append(':').append(this.port);
        }
        return builder.toString();
    }

    private static boolean isValidPort(int port) {
        return port >= 0 && port <= 65535;
    }
}

