/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import java.net.InetAddress;
import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;
import org.netxms.client.constants.ConnectionPointType;

public class ConnectionPoint {
    private long localNodeId;
    private long localInterfaceId;
    private MacAddress localMacAddress;
    private InetAddress localIpAddress;
    private long nodeId;
    private long interfaceId;
    private int interfaceIndex;
    private ConnectionPointType type;
    private Object data;

    public ConnectionPoint(NXCPMessage msg) {
        this.nodeId = msg.getVariableAsInt64(3L);
        this.interfaceId = msg.getVariableAsInt64(362L);
        this.interfaceIndex = msg.getVariableAsInteger(11L);
        this.localNodeId = msg.getVariableAsInt64(364L);
        this.localInterfaceId = msg.getVariableAsInt64(363L);
        this.localMacAddress = new MacAddress(msg.getVariableAsBinary(113L));
        this.localIpAddress = msg.getVariableAsInetAddress(8L);
        this.type = ConnectionPointType.getByValue(msg.getVariableAsInteger(418L));
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public long getInterfaceId() {
        return this.interfaceId;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public long getLocalNodeId() {
        return this.localNodeId;
    }

    public long getLocalInterfaceId() {
        return this.localInterfaceId;
    }

    public MacAddress getLocalMacAddress() {
        return this.localMacAddress;
    }

    public Object getData() {
        return this.data;
    }

    public void setData(Object data) {
        this.data = data;
    }

    public InetAddress getLocalIpAddress() {
        return this.localIpAddress;
    }

    public ConnectionPointType getType() {
        return this.type;
    }
}

