/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.users;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.netxms.base.NXCPMessage;

public abstract class AbstractUserObject {
    public static final int MODIFIED = 1;
    public static final int DELETED = 2;
    public static final int DISABLED = 4;
    public static final int CHANGE_PASSWORD = 8;
    public static final int CANNOT_CHANGE_PASSWORD = 16;
    public static final int INTRUDER_LOCKOUT = 32;
    public static final int PASSWORD_NEVER_EXPIRES = 64;
    public static final int LDAP_USER = 128;
    public static final int SYNC_EXCEPTION = 256;
    protected long id;
    protected String name;
    protected UUID guid;
    protected long systemRights;
    protected int flags;
    protected String description;
    protected Map<String, String> customAttributes = new HashMap<String, String>(0);

    public AbstractUserObject(String name) {
        this.name = name;
        this.description = "";
        this.guid = UUID.randomUUID();
    }

    public AbstractUserObject(AbstractUserObject src) {
        this.id = src.id;
        this.name = new String(src.name);
        this.guid = UUID.fromString(src.guid.toString());
        this.systemRights = src.systemRights;
        this.flags = src.flags;
        this.description = src.description;
        this.customAttributes = new HashMap<String, String>(0);
        for (Map.Entry<String, String> e : src.customAttributes.entrySet()) {
            this.customAttributes.put(new String(e.getKey()), new String(e.getValue()));
        }
    }

    public AbstractUserObject(NXCPMessage msg) {
        this.id = msg.getVariableAsInt64(35L);
        this.name = msg.getVariableAsString(34L);
        this.flags = msg.getVariableAsInteger(37L);
        this.systemRights = msg.getVariableAsInt64(36L);
        this.description = msg.getVariableAsString(41L);
        this.guid = msg.getVariableAsUUID(222L);
        int count = msg.getVariableAsInteger(309L);
        long varId = 0x70000000L;
        for (int i = 0; i < count; ++i) {
            String name = msg.getVariableAsString(varId++);
            String value = msg.getVariableAsString(varId++);
            this.customAttributes.put(name, value);
        }
    }

    public void fillMessage(NXCPMessage msg) {
        msg.setVariableInt32(35L, (int)this.id);
        msg.setVariable(34L, this.name);
        msg.setVariableInt16(37L, this.flags);
        msg.setVariableInt64(36L, this.systemRights);
        msg.setVariable(41L, this.description);
        msg.setVariableInt32(309L, this.customAttributes.size());
        long varId = 0x70000000L;
        for (Map.Entry<String, String> e : this.customAttributes.entrySet()) {
            msg.setVariable(varId++, e.getKey());
            msg.setVariable(varId++, e.getValue());
        }
    }

    public boolean isDeleted() {
        return (this.flags & 2) == 2;
    }

    public long getId() {
        return this.id;
    }

    public void setId(long id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UUID getGuid() {
        return this.guid;
    }

    public long getSystemRights() {
        return this.systemRights;
    }

    public void setSystemRights(long systemRights) {
        this.systemRights = systemRights;
    }

    public int getFlags() {
        return this.flags;
    }

    public void setFlags(int flags) {
        this.flags = flags;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getCustomAttribute(String name) {
        return this.customAttributes.get(name);
    }

    public void setCustomAttribute(String name, String value) {
        this.customAttributes.put(name, value);
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isDisabled() {
        return (this.flags & 4) == 4;
    }

    public boolean isPasswordChangeNeeded() {
        return (this.flags & 8) == 8;
    }

    public boolean isPasswordChangeForbidden() {
        return (this.flags & 0x10) == 16;
    }
}

