/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client;

import java.util.Locale;
import java.util.MissingResourceException;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import org.netxms.api.client.NetXMSClientException;

public class NXCException
extends NetXMSClientException {
    private static final long serialVersionUID = -3247688667511123892L;

    public NXCException(int errorCode) {
        super(errorCode);
    }

    public NXCException(int errorCode, String additionalInfo) {
        super(errorCode, additionalInfo);
    }

    @Override
    protected String getErrorMessage(int code, String lang) {
        try {
            ResourceBundle bundle = PropertyResourceBundle.getBundle("messages", new Locale(lang));
            try {
                return String.format(bundle.getString(String.format("RCC_%04d", code)), this.additionalInfo);
            }
            catch (MissingResourceException e) {
                return String.format(bundle.getString("RCC_UNKNOWN"), code);
            }
        }
        catch (Exception e) {
            return "Error " + Integer.toString(code);
        }
    }
}

