/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps.elements;

import org.netxms.base.NXCPMessage;
import org.netxms.client.maps.configs.DCIImageConfiguration;
import org.netxms.client.maps.elements.NetworkMapElement;

public class NetworkMapDCIImage
extends NetworkMapElement {
    private DCIImageConfiguration imageOptions;

    protected NetworkMapDCIImage(NXCPMessage msg, long baseId) {
        super(msg, baseId);
        String DCIImageConfigXML = msg.getVariableAsString(baseId + 10L);
        try {
            this.imageOptions = DCIImageConfiguration.createFromXml(DCIImageConfigXML);
        }
        catch (Exception e) {
            this.imageOptions = new DCIImageConfiguration();
        }
    }

    public NetworkMapDCIImage(long id) {
        super(id);
        this.type = 4;
        this.imageOptions = new DCIImageConfiguration();
    }

    @Override
    public void fillMessage(NXCPMessage msg, long baseId) {
        super.fillMessage(msg, baseId);
        String xml = "";
        try {
            xml = this.imageOptions.createXml();
        }
        catch (Exception e) {
            // empty catch block
        }
        msg.setVariable(baseId + 10L, xml);
    }

    public DCIImageConfiguration getImageOptions() {
        return this.imageOptions;
    }

    public void setImageOptions(DCIImageConfiguration imageOptions) {
        this.imageOptions = imageOptions;
    }
}

