/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.eventmanager.widgets;

import org.eclipse.swt.widgets.Composite;
import org.netxms.client.NXCSession;
import org.netxms.client.events.EventTemplate;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.eventmanager.Messages;
import org.netxms.ui.eclipse.eventmanager.dialogs.EventSelectionDialog;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.widgets.AbstractSelector;

public class EventSelector
extends AbstractSelector {
    private long eventCode = 0L;

    public EventSelector(Composite parent, int style) {
        super(parent, style, 0);
        Messages.get();
        this.setText(Messages.EventSelector_None);
    }

    public EventSelector(Composite parent, int style, boolean useHyperlink) {
        super(parent, style, (useHyperlink ? 1 : 0) | 8);
        Messages.get();
        this.setText(Messages.EventSelector_None);
    }

    protected void selectionButtonHandler() {
        EventSelectionDialog dlg = new EventSelectionDialog(this.getShell());
        dlg.enableMultiSelection(false);
        if (dlg.open() == 0) {
            long prevEventCode = this.eventCode;
            EventTemplate[] events = dlg.getSelectedEvents();
            if (events.length > 0) {
                this.eventCode = events[0].getCode();
                this.setText(events[0].getName());
                this.setImage(StatusDisplayInfo.getStatusImage((int)events[0].getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(events[0]));
            } else {
                this.eventCode = 0L;
                Messages.get();
                this.setText(Messages.EventSelector_None);
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
            if (prevEventCode != this.eventCode) {
                this.fireModifyListeners();
            }
        }
    }

    protected void clearButtonHandler() {
        if (this.eventCode == 0L) {
            return;
        }
        this.eventCode = 0L;
        Messages.get();
        this.setText(Messages.EventSelector_None);
        this.setImage(null);
        this.getTextControl().setToolTipText(null);
        this.fireModifyListeners();
    }

    public long getEventCode() {
        return this.eventCode;
    }

    public void setEventCode(long eventCode) {
        if (this.eventCode == eventCode) {
            return;
        }
        this.eventCode = eventCode;
        if (eventCode != 0L) {
            EventTemplate event = ((NXCSession)ConsoleSharedData.getSession()).findEventTemplateByCode(eventCode);
            if (event != null) {
                this.setText(event.getName());
                this.setImage(StatusDisplayInfo.getStatusImage((int)event.getSeverity()));
                this.getTextControl().setToolTipText(this.generateToolTipText(event));
            } else {
                Messages.get();
                this.setText(Messages.EventSelector_Unknown);
                this.setImage(null);
                this.getTextControl().setToolTipText(null);
            }
        } else {
            Messages.get();
            this.setText(Messages.EventSelector_None);
            this.setImage(null);
            this.getTextControl().setToolTipText(null);
        }
        this.fireModifyListeners();
    }

    private String generateToolTipText(EventTemplate event) {
        StringBuilder sb = new StringBuilder(event.getName());
        sb.append(" [");
        sb.append(event.getCode());
        Messages.get();
        sb.append(Messages.EventSelector_Severity);
        sb.append(StatusDisplayInfo.getStatusText((int)event.getSeverity()));
        sb.append("\n\n");
        sb.append(event.getMessage());
        sb.append("\n\n");
        sb.append(event.getDescription().replace("\r", ""));
        return sb.toString();
    }

    protected String getSelectionButtonToolTip() {
        Messages.get();
        return Messages.EventSelector_Tooltip;
    }
}

