/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.datacollection.views.helpers;

import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.netxms.client.TableRow;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class TableItemComparator
extends ViewerComparator {
    private int[] formats;

    public TableItemComparator(int[] formats) {
        this.formats = formats;
    }

    public int compare(Viewer viewer, Object e1, Object e2) {
        int result;
        int column = (Integer)((SortableTableViewer)viewer).getTable().getSortColumn().getData("ID");
        int format = column < this.formats.length ? this.formats[column] : 4;
        String value1 = ((TableRow)e1).get(column).getValue();
        String value2 = ((TableRow)e2).get(column).getValue();
        switch (format) {
            case 0: 
            case 1: {
                result = TableItemComparator.safeParseInt(value1) - TableItemComparator.safeParseInt(value2);
                break;
            }
            case 2: 
            case 3: {
                result = Long.signum(TableItemComparator.safeParseLong(value1) - TableItemComparator.safeParseLong(value2));
                break;
            }
            case 5: {
                result = (int)Math.signum(TableItemComparator.safeParseDouble(value1) - TableItemComparator.safeParseDouble(value2));
                break;
            }
            default: {
                result = value1.compareToIgnoreCase(value2);
            }
        }
        return ((SortableTableViewer)viewer).getTable().getSortDirection() == 128 ? result : -result;
    }

    private static int safeParseInt(String s) {
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    private static long safeParseLong(String s) {
        try {
            return Long.parseLong(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0L;
        }
    }

    private static double safeParseDouble(String s) {
        try {
            return Double.parseDouble(s);
        }
        catch (NumberFormatException numberFormatException) {
            return 0.0;
        }
    }
}

