/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.networkmaps.dialogs;

import java.util.UUID;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.netxms.base.NXCommon;
import org.netxms.client.maps.configs.DCIImageRule;
import org.netxms.ui.eclipse.imagelibrary.widgets.ImageSelector;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class EditDCIImageRuleDialog
extends Dialog {
    private DCIImageRule rule;
    private Combo operation;
    private Text value;
    private Text comment;
    private UUID selectedImage;
    private Group conditionGroup;
    private ImageSelector image;

    public EditDCIImageRuleDialog(Shell parentShell, DCIImageRule rule) {
        super(parentShell);
        this.rule = rule;
        this.setShellStyle(this.getShellStyle() | 0x10);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.makeColumnsEqualWidth = true;
        dialogArea.setLayout((Layout)layout);
        this.conditionGroup = new Group(dialogArea, 0);
        this.conditionGroup.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.conditionGroup.setText("Condition");
        GridLayout condLayout = new GridLayout();
        condLayout.numColumns = 2;
        this.conditionGroup.setLayout((Layout)condLayout);
        this.operation = WidgetHelper.createLabeledCombo((Composite)this.conditionGroup, (int)2060, (String)"Operation", (Object)"WidgetHelper::default_layout_data");
        this.operation.add("< : less then");
        this.operation.add("<= : less then or equals to");
        this.operation.add("== : equals to");
        this.operation.add(">= : gather then on equals");
        this.operation.add("> : gather then ");
        this.operation.add("!= : not equals to");
        this.operation.add("like");
        this.operation.add("not like");
        this.operation.select(this.rule.getComparisonType() != -1 ? this.rule.getComparisonType() : 0);
        this.value = WidgetHelper.createLabeledText((Composite)this.conditionGroup, (int)2048, (int)120, (String)"Value", (String)this.rule.getCompareValue(), (Object)"WidgetHelper::default_layout_data");
        this.comment = WidgetHelper.createLabeledText((Composite)dialogArea, (int)2048, (int)120, (String)"Comment", (String)this.rule.getComment(), (Object)"WidgetHelper::default_layout_data");
        this.image = new ImageSelector(dialogArea, 0);
        this.image.setLabel("Image");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.image.setLayoutData((Object)gd);
        try {
            this.selectedImage = this.rule.getImage();
            this.image.setImageGuid(this.selectedImage, true);
        }
        catch (Exception exception) {}
        this.image.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                EditDCIImageRuleDialog.this.getShell().setSize(EditDCIImageRuleDialog.this.getShell().computeSize(-1, -1, true));
                EditDCIImageRuleDialog.this.getShell().layout(true, true);
            }
        });
        return dialogArea;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Edit DCI Image Rule");
    }

    protected void okPressed() {
        this.selectedImage = this.image.getImageGuid();
        if (this.selectedImage == null || this.selectedImage == NXCommon.EMPTY_GUID) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Required field is empty", (String)"Image should be selected");
            return;
        }
        String compareValue = this.value.getText();
        if (compareValue == null || compareValue.isEmpty()) {
            MessageDialogHelper.openError((Shell)this.getShell(), (String)"Required field is empty", (String)"Compare value should not be empty");
            return;
        }
        this.rule.setImage(this.selectedImage);
        this.rule.setComparisonType(this.operation.getSelectionIndex());
        this.rule.setCompareValue(compareValue);
        this.rule.setComment(this.comment.getText());
        super.okPressed();
    }
}

