/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ColumnViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCListener;
import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.ExportToCsvAction;
import org.netxms.ui.eclipse.alarmviewer.Activator;
import org.netxms.ui.eclipse.alarmviewer.Messages;
import org.netxms.ui.eclipse.alarmviewer.dialogs.AcknowledgeCustomTimeDialog;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmAcknowledgeTimeFunctions;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmComparator;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmListFilter;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmListLabelProvider;
import org.netxms.ui.eclipse.alarmviewer.widgets.helpers.AlarmToolTip;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objectview.views.TabbedObjectView;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.FilteringMenuManager;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.RefreshTimer;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.CompositeWithMessageBar;
import org.netxms.ui.eclipse.widgets.SortableTableViewer;

public class AlarmList
extends CompositeWithMessageBar {
    public static final String JOB_FAMILY = "AlarmViewJob";
    public static final int COLUMN_SEVERITY = 0;
    public static final int COLUMN_STATE = 1;
    public static final int COLUMN_SOURCE = 2;
    public static final int COLUMN_MESSAGE = 3;
    public static final int COLUMN_COUNT = 4;
    public static final int COLUMN_COMMENTS = 5;
    public static final int COLUMN_HELPDESK_REF = 6;
    public static final int COLUMN_ACK_BY = 7;
    public static final int COLUMN_CREATED = 8;
    public static final int COLUMN_LASTCHANGE = 9;
    private final IViewPart viewPart;
    private NXCSession session = null;
    private NXCListener clientListener = null;
    private RefreshTimer refreshTimer;
    private SortableTableViewer alarmViewer;
    private AlarmListFilter alarmFilter;
    private Point toolTipLocation;
    private Alarm toolTipObject;
    private Map<Long, Alarm> alarmList = new HashMap<Long, Alarm>();
    private List<Alarm> filteredAlarmList = new ArrayList<Alarm>();
    private Action actionCopy;
    private Action actionCopyMessage;
    private Action actionComments;
    private Action actionAcknowledge;
    private Action actionResolve;
    private Action actionStickyAcknowledge;
    private Action actionTerminate;
    private Action actionShowAlarmDetails;
    private Action actionShowObjectDetails;
    private Action actionCreateIssue;
    private Action actionShowIssue;
    private Action actionUnlinkIssue;
    private Action actionExportToCsv;
    private MenuManager timeAcknowledgeMenu;
    private List<Action> timeAcknowledge;
    private Action timeAcknowledgeOther;

    public AlarmList(IViewPart viewPart, Composite parent, int style, final String configPrefix) {
        super(parent, style);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.viewPart = viewPart;
        String[] stringArray = new String[10];
        Messages.get();
        stringArray[0] = Messages.AlarmList_ColumnSeverity;
        Messages.get();
        stringArray[1] = Messages.AlarmList_ColumnState;
        Messages.get();
        stringArray[2] = Messages.AlarmList_ColumnSource;
        Messages.get();
        stringArray[3] = Messages.AlarmList_ColumnMessage;
        Messages.get();
        stringArray[4] = Messages.AlarmList_ColumnCount;
        Messages.get();
        stringArray[5] = Messages.AlarmList_Comments;
        stringArray[6] = "Helpdesk ID";
        Messages.get();
        stringArray[7] = Messages.AlarmList_AckBy;
        Messages.get();
        stringArray[8] = Messages.AlarmList_ColumnCreated;
        Messages.get();
        stringArray[9] = Messages.AlarmList_ColumnLastChange;
        String[] names = stringArray;
        int[] widths = new int[]{100, 100, 150, 300, 70, 70, 120, 100, 100, 100};
        this.alarmViewer = new SortableTableViewer(this.getContent(), names, widths, 0, 1024, -1);
        WidgetHelper.restoreTableViewerSettings((SortableTableViewer)this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
        this.alarmViewer.setLabelProvider((IBaseLabelProvider)new AlarmListLabelProvider());
        this.alarmViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.alarmViewer.setComparator((ViewerComparator)new AlarmComparator());
        this.alarmFilter = new AlarmListFilter();
        this.alarmViewer.getTable().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTableViewerSettings((SortableTableViewer)AlarmList.this.alarmViewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)configPrefix);
            }
        });
        this.alarmViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                AlarmList.this.actionShowAlarmDetails.run();
            }
        });
        final Runnable toolTipTimer = new Runnable(){

            @Override
            public void run() {
                AlarmToolTip t = new AlarmToolTip((Control)AlarmList.this.alarmViewer.getTable(), AlarmList.this.toolTipObject);
                t.show(AlarmList.this.toolTipLocation);
            }
        };
        this.alarmViewer.getTable().addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseHover(MouseEvent e) {
                if (!Activator.getDefault().getPreferenceStore().getBoolean("SHOW_ALARM_TOOLTIPS")) {
                    return;
                }
                Point p = new Point(e.x, e.y);
                TableItem item = AlarmList.this.alarmViewer.getTable().getItem(p);
                if (item == null) {
                    return;
                }
                AlarmList.this.toolTipObject = (Alarm)item.getData();
                p.x -= 10;
                p.y -= 10;
                AlarmList.this.toolTipLocation = p;
                AlarmList.this.getDisplay().timerExec(300, toolTipTimer);
            }

            public void mouseExit(MouseEvent e) {
                AlarmList.this.getDisplay().timerExec(-1, toolTipTimer);
            }
        });
        this.createActions();
        this.createPopupMenu();
        this.refresh();
        this.refreshTimer = new RefreshTimer(this.session.getMinViewRefreshInterval(), this.alarmViewer.getControl(), new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Map map = AlarmList.this.alarmList;
                synchronized (map) {
                    AlarmList.this.alarmViewer.refresh();
                }
            }
        });
        this.clientListener = new NXCListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void notificationHandler(SessionNotification n) {
                switch (n.getCode()) {
                    case 1004: 
                    case 1005: {
                        Map map = AlarmList.this.alarmList;
                        synchronized (map) {
                            AlarmList.this.alarmList.put(((Alarm)n.getObject()).getId(), (Alarm)n.getObject());
                            AlarmList.this.filterAndLimit();
                        }
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                    case 1003: 
                    case 1011: {
                        Map map = AlarmList.this.alarmList;
                        synchronized (map) {
                            AlarmList.this.alarmList.remove(((Alarm)n.getObject()).getId());
                            AlarmList.this.filterAndLimit();
                        }
                        AlarmList.this.refreshTimer.execute();
                        break;
                    }
                }
            }
        };
        this.session.addListener((SessionListener)this.clientListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                if (AlarmList.this.session != null && AlarmList.this.clientListener != null) {
                    AlarmList.this.session.removeListener((SessionListener)AlarmList.this.clientListener);
                }
            }
        });
        final Runnable blinkTimer = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (AlarmList.this.isDisposed()) {
                    return;
                }
                int count = 0;
                Map map = AlarmList.this.alarmList;
                synchronized (map) {
                    for (Alarm a : AlarmList.this.alarmList.values()) {
                        if (a.getState() != 0) continue;
                        ++count;
                    }
                }
                if (count > 0) {
                    ((AlarmListLabelProvider)AlarmList.this.alarmViewer.getLabelProvider()).toggleBlinkState();
                    AlarmList.this.alarmViewer.refresh();
                }
                AlarmList.this.getDisplay().timerExec(500, (Runnable)this);
            }
        };
        final IPreferenceStore ps = Activator.getDefault().getPreferenceStore();
        if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
            this.getDisplay().timerExec(500, blinkTimer);
        }
        ps.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("BLINK_OUTSTANDING_ALARMS")) {
                    if (ps.getBoolean("BLINK_OUTSTANDING_ALARMS")) {
                        AlarmList.this.getDisplay().timerExec(500, blinkTimer);
                    } else {
                        AlarmList.this.getDisplay().timerExec(-1, blinkTimer);
                    }
                }
            }
        });
    }

    public ISelectionProvider getSelectionProvider() {
        return this.alarmViewer;
    }

    private void createActions() {
        Messages.get();
        this.actionCopy = new Action(Messages.AlarmList_CopyToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append('[');
                        sb.append(selection[i].getText(0));
                        sb.append("]\t");
                        sb.append(selection[i].getText(2));
                        sb.append('\t');
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopy.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Copy");
        Messages.get();
        this.actionCopyMessage = new Action(Messages.AlarmList_CopyMsgToClipboard){

            public void run() {
                TableItem[] selection = AlarmList.this.alarmViewer.getTable().getSelection();
                if (selection.length > 0) {
                    String newLine = Platform.getOS().equals("win32") ? "\r\n" : "\n";
                    StringBuilder sb = new StringBuilder();
                    int i = 0;
                    while (i < selection.length) {
                        if (i > 0) {
                            sb.append(newLine);
                        }
                        sb.append(selection[i].getText(3));
                        ++i;
                    }
                    WidgetHelper.copyToClipboard((String)sb.toString());
                }
            }
        };
        this.actionCopyMessage.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.CopyMessage");
        Messages.get();
        this.actionComments = new Action(Messages.AlarmList_Comments, Activator.getImageDescriptor("icons/comments.png")){

            public void run() {
                AlarmList.this.openAlarmDetailsView("org.netxms.ui.eclipse.alarmviewer.views.AlarmComments");
            }
        };
        this.actionComments.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Comments");
        Messages.get();
        this.actionShowAlarmDetails = new Action(Messages.AlarmList_ActionAlarmDetails){

            public void run() {
                AlarmList.this.openAlarmDetailsView("org.netxms.ui.eclipse.alarmviewer.views.AlarmDetails");
            }
        };
        this.actionShowAlarmDetails.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.AlarmDetails");
        Messages.get();
        this.actionAcknowledge = new Action(Messages.AlarmList_Acknowledge, Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(false, 0);
            }
        };
        this.actionAcknowledge.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Acknowledge");
        Messages.get();
        this.actionStickyAcknowledge = new Action(Messages.AlarmList_StickyAck, Activator.getImageDescriptor("icons/acknowledged_sticky.png")){

            public void run() {
                AlarmList.this.acknowledgeAlarms(true, 0);
            }
        };
        this.actionStickyAcknowledge.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.StickyAcknowledge");
        Messages.get();
        this.actionResolve = new Action(Messages.AlarmList_Resolve, Activator.getImageDescriptor("icons/resolved.png")){

            public void run() {
                AlarmList.this.resolveAlarms();
            }
        };
        this.actionResolve.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Resolve");
        Messages.get();
        this.actionTerminate = new Action(Messages.AlarmList_Terminate, Activator.getImageDescriptor("icons/terminated.png")){

            public void run() {
                AlarmList.this.terminateAlarms();
            }
        };
        this.actionTerminate.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.Terminate");
        this.actionCreateIssue = new Action("Create &ticket in helpdesk system", Activator.getImageDescriptor("icons/helpdesk_ticket.png")){

            public void run() {
                AlarmList.this.createIssue();
            }
        };
        this.actionShowIssue = new Action("Show helpdesk ticket in &web browser", SharedIcons.BROWSER){

            public void run() {
                AlarmList.this.showIssue();
            }
        };
        this.actionUnlinkIssue = new Action("Unlink from helpdesk ticket"){

            public void run() {
                AlarmList.this.unlinkIssue();
            }
        };
        Messages.get();
        this.actionShowObjectDetails = new Action(Messages.AlarmList_ActionObjectDetails){

            public void run() {
                AlarmList.this.showObjectDetails();
            }
        };
        this.actionShowObjectDetails.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.ShowObjectDetails");
        this.actionExportToCsv = new ExportToCsvAction(this.viewPart, (ColumnViewer)this.alarmViewer, true);
        this.timeAcknowledgeOther = new Action("Other...", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time;
                AcknowledgeCustomTimeDialog dlg = new AcknowledgeCustomTimeDialog(AlarmList.this.viewPart.getSite().getShell());
                if (dlg.open() == 0 && (time = dlg.getTime()) > 0) {
                    AlarmList.this.acknowledgeAlarms(true, time);
                }
            }
        };
        this.timeAcknowledgeOther.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledgeOther");
    }

    private void initializeTimeAcknowledge() {
        int menuSize;
        IDialogSettings settings = Activator.getDefault().getDialogSettings();
        try {
            menuSize = settings.getInt("AlarmList.ackMenuSize");
        }
        catch (NumberFormatException numberFormatException) {
            settings.put("AlarmList.ackMenuSize", 4);
            this.timeAcknowledge = new ArrayList<Action>(4);
            this.createDefaultIntervals();
            settings.put("AlarmList.ackMenuEntry0", 3600);
            settings.put("AlarmList.ackMenuEntry1", 14400);
            settings.put("AlarmList.ackMenuEntry2", 86400);
            settings.put("AlarmList.ackMenuEntry3", 172800);
            return;
        }
        this.timeAcknowledge = new ArrayList<Action>(menuSize);
        int i = 0;
        while (i < menuSize) {
            final int time = settings.getInt("AlarmList.ackMenuEntry" + Integer.toString(i));
            if (time != 0) {
                String title = AlarmAcknowledgeTimeFunctions.timeToString(time);
                Action action = new Action(title, Activator.getImageDescriptor("icons/acknowledged.png")){

                    public void run() {
                        AlarmList.this.acknowledgeAlarms(true, time);
                    }
                };
                action.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge" + Integer.toString(i) + "ID");
                this.timeAcknowledge.add(action);
            }
            ++i;
        }
    }

    private void createDefaultIntervals() {
        Action act = new Action("1 hour(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 3600;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge0ID");
        this.timeAcknowledge.add(act);
        act = new Action("4 hour(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 14400;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge1ID");
        this.timeAcknowledge.add(act);
        act = new Action("1 day(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 86400;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge2ID");
        this.timeAcknowledge.add(act);
        act = new Action("2 days(s)", Activator.getImageDescriptor("icons/acknowledged.png")){

            public void run() {
                int time = 172800;
                AlarmList.this.acknowledgeAlarms(true, time);
            }
        };
        act.setId("org.netxms.ui.eclipse.alarmviewer.popupActions.TimeAcknowledge3ID");
        this.timeAcknowledge.add(act);
    }

    private void createPopupMenu() {
        FilteringMenuManager menuMgr = new FilteringMenuManager("org.netxms.ui.eclipse.alarmviewer");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AlarmList.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.alarmViewer.getControl());
        this.alarmViewer.getControl().setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu((MenuManager)menuMgr, (ISelectionProvider)this.alarmViewer);
        }
    }

    protected void fillContextMenu(IMenuManager manager) {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        int states = this.getSelectionType(selection.toArray());
        if (states == 2) {
            manager.add((IAction)this.actionAcknowledge);
            manager.add((IAction)this.actionStickyAcknowledge);
            if (this.session.isTimedAlarmAckEnabled()) {
                this.initializeTimeAcknowledge();
                Messages.get();
                this.timeAcknowledgeMenu = new MenuManager(Messages.AlarmList_StickyAckMenutTitle, "timeAcknowledge");
                for (Action act : this.timeAcknowledge) {
                    this.timeAcknowledgeMenu.add((IAction)act);
                }
                this.timeAcknowledgeMenu.add((IContributionItem)new Separator());
                this.timeAcknowledgeMenu.add((IAction)this.timeAcknowledgeOther);
                manager.add((IContributionItem)this.timeAcknowledgeMenu);
            }
        }
        if (states < 4) {
            manager.add((IAction)this.actionResolve);
        }
        if (states == 4 || !this.session.isStrictAlarmStatusFlow()) {
            manager.add((IAction)this.actionTerminate);
        }
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        if (selection.size() == 1) {
            manager.add((IContributionItem)new GroupMarker("objectmgmt"));
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowObjectDetails);
            manager.add((IContributionItem)new Separator());
        }
        manager.add((IAction)this.actionCopy);
        manager.add((IAction)this.actionCopyMessage);
        manager.add((IAction)this.actionExportToCsv);
        if (selection.size() == 1) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)this.actionShowAlarmDetails);
            manager.add((IAction)this.actionComments);
            if (this.session.isHelpdeskLinkActive()) {
                manager.add((IContributionItem)new Separator());
                if (((Alarm)selection.getFirstElement()).getHelpdeskState() == 0) {
                    manager.add((IAction)this.actionCreateIssue);
                } else {
                    manager.add((IAction)this.actionShowIssue);
                    if ((this.session.getUserSystemRights() & 0x10000000L) != 0L) {
                        manager.add((IAction)this.actionUnlinkIssue);
                    }
                }
            }
        }
    }

    private int getSelectionType(Object[] array) {
        int type = 0;
        int i = 0;
        while (i < array.length) {
            type |= ((Alarm)array[i]).getState() + 2;
            ++i;
        }
        return type;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRootObject(long objectId) {
        this.alarmFilter.setRootObject(objectId);
        Map<Long, Alarm> map = this.alarmList;
        synchronized (map) {
            this.filterAndLimit();
        }
    }

    private void filterAndLimit() {
        this.filteredAlarmList.clear();
        for (Alarm alarm : this.alarmList.values()) {
            if (!this.alarmFilter.select(alarm)) continue;
            this.filteredAlarmList.add(alarm);
        }
        Collections.sort(this.filteredAlarmList, new Comparator<Alarm>(){

            @Override
            public int compare(Alarm alarm1, Alarm alarm2) {
                return -alarm1.getLastChangeTime().compareTo(alarm2.getLastChangeTime());
            }
        });
        if (this.session.getAlarmListDisplayLimit() > 0) {
            this.filteredAlarmList = this.filteredAlarmList.subList(0, Math.min(this.session.getAlarmListDisplayLimit(), this.filteredAlarmList.size()));
        }
        this.alarmViewer.getControl().getDisplay().asyncExec(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!AlarmList.this.alarmViewer.getControl().isDisposed()) {
                    Map map = AlarmList.this.alarmList;
                    synchronized (map) {
                        AlarmList.this.alarmViewer.setInput((Object)AlarmList.this.filteredAlarmList);
                    }
                    if (AlarmList.this.session.getAlarmListDisplayLimit() > 0 && AlarmList.this.filteredAlarmList.size() >= AlarmList.this.session.getAlarmListDisplayLimit()) {
                        AlarmList.this.showMessage(0, String.format("Only %d most recent alarms shown", AlarmList.this.filteredAlarmList.size()));
                    } else {
                        AlarmList.this.hideMessage();
                    }
                }
            }
        });
    }

    public void refresh() {
        Messages.get();
        new ConsoleJob(Messages.AlarmList_SyncJobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void runInternal(IProgressMonitor monitor) throws Exception {
                HashMap alarms = AlarmList.this.session.getAlarms();
                Map map = AlarmList.this.alarmList;
                synchronized (map) {
                    AlarmList.this.alarmList.clear();
                    AlarmList.this.alarmList.putAll(alarms);
                    AlarmList.this.filterAndLimit();
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_SyncJobError;
            }
        }.start();
    }

    private void openAlarmDetailsView(String viewId) {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        String secondaryId = Long.toString(((Alarm)selection.getFirstElement()).getId());
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        try {
            page.showView(viewId, secondaryId, 1);
        }
        catch (PartInitException e) {
            Shell shell = this.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmList_Error, (String)(String.valueOf(Messages.AlarmList_ErrorText) + e.getLocalizedMessage()));
        }
    }

    public void setStateFilter(int filter) {
        this.alarmFilter.setStateFilter(filter);
    }

    public void setSeverityFilter(int filter) {
        this.alarmFilter.setSeverityFilter(filter);
    }

    private void acknowledgeAlarms(final boolean sticky, final int time) {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.AcknowledgeAlarm_JobName, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.AcknowledgeAlarm_TaskName, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.acknowledgeAlarm(((Alarm)o).getId(), sticky, time);
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AcknowledgeAlarm_ErrorMessage;
            }
        }.start();
    }

    private void resolveAlarms() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.AlarmList_Resolving, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.AlarmList_ResolveAlarm, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.resolveAlarm(((Alarm)o).getId());
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.AlarmList_CannotResoveAlarm;
            }
        }.start();
    }

    private void terminateAlarms() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() == 0) {
            return;
        }
        final Object[] alarms = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.TerminateAlarm_JobTitle, (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                Messages.get();
                monitor.beginTask(Messages.TerminateAlarm_TaskName, alarms.length);
                Object[] objectArray = alarms;
                int n = alarms.length;
                int n2 = 0;
                while (n2 < n) {
                    Object o = objectArray[n2];
                    if (monitor.isCanceled()) break;
                    if (o instanceof Alarm) {
                        AlarmList.this.session.terminateAlarm(((Alarm)o).getId());
                    }
                    monitor.worked(1);
                    ++n2;
                }
                monitor.done();
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.TerminateAlarm_ErrorMessage;
            }
        }.start();
    }

    private void createIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        new ConsoleJob("Create helpdesk ticket", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmList.this.session.openHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                return "Cannot create helpdesk ticket from alarm";
            }
        }.start();
    }

    private void showIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        new ConsoleJob("Show helpdesk ticket", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final String url = AlarmList.this.session.getHelpdeskIssueUrl(id);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            IWebBrowser browser = PlatformUI.getWorkbench().getBrowserSupport().getExternalBrowser();
                            browser.openURL(new URL(url));
                        }
                        catch (Exception e) {
                            Activator.logError("Exception in AlarmList.showIssue (url=\"" + url + "\")", e);
                            MessageDialogHelper.openError((Shell)AlarmList.this.getShell(), (String)"Error", (String)"Internal error: unable to open web browser");
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Cannot get URL for helpdesk ticket";
            }
        }.start();
    }

    private void unlinkIssue() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final long id = ((Alarm)selection.getFirstElement()).getId();
        new ConsoleJob("Unlink alarm from helpdesk ticket", (IWorkbenchPart)this.viewPart, "org.netxms.ui.eclipse.alarmviewer", JOB_FAMILY){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AlarmList.this.session.unlinkHelpdeskIssue(id);
            }

            protected String getErrorMessage() {
                return "Cannot unlink alarm from helpdesk ticket";
            }
        }.start();
    }

    private void showObjectDetails() {
        IStructuredSelection selection = (IStructuredSelection)this.alarmViewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        AbstractObject object = this.session.findObjectById(((Alarm)selection.getFirstElement()).getSourceObjectId());
        if (object != null) {
            try {
                TabbedObjectView view = (TabbedObjectView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("org.netxms.ui.eclipse.objectview.view.tabbed_object_view");
                view.setObject(object);
            }
            catch (PartInitException e) {
                Shell shell = this.getShell();
                Messages.get();
                Messages.get();
                MessageDialogHelper.openError((Shell)shell, (String)Messages.AlarmList_Error, (String)(String.valueOf(Messages.AlarmList_OpenDetailsError) + e.getLocalizedMessage()));
            }
        }
    }

    public TableViewer getViewer() {
        return this.alarmViewer;
    }
}

