/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.alarmviewer.widgets.helpers;

import org.netxms.client.NXCSession;
import org.netxms.client.events.Alarm;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class AlarmListFilter {
    private long rootObject = 0L;
    private int stateFilter = -1;
    private int severityFilter = 255;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    public boolean select(Alarm alarm) {
        if (this.stateFilter != -1 && alarm.getState() != this.stateFilter) {
            return false;
        }
        if ((1 << alarm.getCurrentSeverity() & this.severityFilter) == 0) {
            return false;
        }
        if (this.rootObject == 0L || this.rootObject == alarm.getSourceObjectId()) {
            return true;
        }
        AbstractObject object = this.session.findObjectById(alarm.getSourceObjectId());
        if (object != null) {
            return object.isChildOf(this.rootObject);
        }
        return false;
    }

    public final void setRootObject(long rootObject) {
        this.rootObject = rootObject;
    }

    public void setStateFilter(int stateFilter) {
        this.stateFilter = stateFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }
}

