/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.api;

import java.io.IOException;
import java.net.URLEncoder;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.netxms.client.AgentFile;
import org.netxms.client.NXCSession;
import org.netxms.client.objecttools.ObjectTool;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.api.NodeInfo;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolHandler;
import org.netxms.ui.eclipse.objecttools.api.ObjectToolsCache;
import org.netxms.ui.eclipse.objecttools.views.BrowserView;
import org.netxms.ui.eclipse.objecttools.views.FileViewer;
import org.netxms.ui.eclipse.objecttools.views.LocalCommandResults;
import org.netxms.ui.eclipse.objecttools.views.TableToolResults;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public final class ObjectToolExecutor {
    private ObjectToolExecutor() {
    }

    public static boolean isToolAllowed(ObjectTool tool, Set<NodeInfo> nodes) {
        if (tool.getType() != 0) {
            return true;
        }
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            for (NodeInfo n : nodes) {
                if (handler.canExecuteOnNode(n.object, tool)) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public static boolean isToolApplicable(ObjectTool tool, Set<NodeInfo> nodes) {
        for (NodeInfo n : nodes) {
            if (tool.isApplicableForNode(n.object)) continue;
            return false;
        }
        return true;
    }

    public static void execute(Set<NodeInfo> nodes, ObjectTool tool) {
        if ((tool.getFlags() & 8) != 0) {
            String message = tool.getConfirmationText();
            if (nodes.size() == 1) {
                NodeInfo node = nodes.iterator().next();
                message = message.replace("%OBJECT_IP_ADDR%", node.object.getPrimaryIP().getHostAddress());
                message = message.replace("%OBJECT_NAME%", node.object.getObjectName());
                message = message.replace("%OBJECT_ID%", Long.toString(node.object.getObjectId()));
            } else {
                Messages.get();
                message = message.replace("%OBJECT_IP_ADDR%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_NAME%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
                Messages.get();
                message = message.replace("%OBJECT_ID%", Messages.ObjectToolsDynamicMenu_MultipleNodes);
            }
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            if (!MessageDialogHelper.openQuestion((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_ConfirmExec, (String)message)) {
                return;
            }
        }
        for (NodeInfo n : nodes) {
            ObjectToolExecutor.executeOnNode(n, tool);
        }
    }

    private static void executeOnNode(NodeInfo node, ObjectTool tool) {
        switch (tool.getType()) {
            case 0: {
                ObjectToolExecutor.executeInternalTool(node, tool);
                break;
            }
            case 5: {
                ObjectToolExecutor.executeLocalCommand(node, tool);
                break;
            }
            case 6: {
                ObjectToolExecutor.executeServerCommand(node, tool);
                break;
            }
            case 1: {
                ObjectToolExecutor.executeAgentAction(node, tool);
                break;
            }
            case 2: 
            case 3: {
                ObjectToolExecutor.executeTableTool(node, tool);
                break;
            }
            case 4: {
                ObjectToolExecutor.openURL(node, tool);
                break;
            }
            case 7: {
                ObjectToolExecutor.executeFileDownload(node, tool);
            }
        }
    }

    private static void executeTableTool(NodeInfo node, ObjectTool tool) {
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            IWorkbenchPage page = window.getActivePage();
            TableToolResults view = (TableToolResults)page.showView("org.netxms.ui.eclipse.objecttools.views.TableToolResults", String.valueOf(Long.toString(tool.getId())) + "&" + Long.toString(node.object.getObjectId()), 1);
            view.refreshTable();
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
        }
    }

    private static void executeAgentAction(final NodeInfo node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        final String action = ObjectToolExecutor.substituteMacros(tool.getData(), node);
        Messages.get();
        new ConsoleJob(String.format(Messages.ObjectToolsDynamicMenu_ExecuteOnNode, node.object.getObjectName()), null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_CannotExecuteOnNode, node.object.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeAction(node.object.getObjectId(), action);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_ToolExecution, (String)String.format(Messages.ObjectToolsDynamicMenu_ExecSuccess, action, node.object.getObjectName()));
                    }
                });
            }
        }.start();
    }

    private static void executeServerCommand(final NodeInfo node, final ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        Messages.get();
        new ConsoleJob(Messages.ObjectToolsDynamicMenu_ExecuteServerCmd, null, "org.netxms.ui.eclipse.objecttools", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                session.executeServerCommand(node.object.getObjectId(), tool.getData());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        Messages.get();
                        Messages.get();
                        MessageDialogHelper.openInformation(null, (String)Messages.ObjectToolsDynamicMenu_Information, (String)Messages.ObjectToolsDynamicMenu_ServerCommandExecuted);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ObjectToolsDynamicMenu_ServerCmdExecError;
            }
        }.start();
    }

    private static void executeLocalCommand(NodeInfo node, ObjectTool tool) {
        block7: {
            String command = ObjectToolExecutor.substituteMacros(tool.getData(), node);
            if ((tool.getFlags() & 0x10) == 0) {
                String os = Platform.getOS();
                try {
                    if (os.equals("win32")) {
                        command = "CMD.EXE /C START \"NetXMS\" " + command;
                        Runtime.getRuntime().exec(command);
                        break block7;
                    }
                    Runtime.getRuntime().exec(new String[]{"/bin/sh", "-c", command});
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            } else {
                String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                try {
                    LocalCommandResults view = (LocalCommandResults)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.LocalCommandResults", secondaryId, 1);
                    view.runCommand(command);
                }
                catch (Exception e) {
                    Shell shell = window.getShell();
                    Messages.get();
                    Messages.get();
                    MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                }
            }
        }
    }

    private static void executeFileDownload(final NodeInfo node, ObjectTool tool) {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        String[] parameters = tool.getData().split("\u007f");
        final String fileName = parameters[0];
        final int maxFileSize = Integer.parseInt(parameters[1]);
        final boolean follow = parameters[2].equals("true");
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.ObjectToolsDynamicMenu_DownloadFromAgent, null, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return String.format(Messages.ObjectToolsDynamicMenu_DownloadError, fileName, node.object.getObjectName());
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFile file = session.downloadFileFromAgent(node.object.getObjectId(), fileName, (long)maxFileSize, follow);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            String secondaryId = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + URLEncoder.encode(fileName, "UTF-8");
                            FileViewer view = (FileViewer)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.FileViewer", secondaryId, 1);
                            view.showFile(file.getFile(), follow, file.getId(), maxFileSize);
                        }
                        catch (Exception e) {
                            Shell shell = window.getShell();
                            Messages.get();
                            Messages.get();
                            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)String.format(Messages.ObjectToolsDynamicMenu_ErrorOpeningView, e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private static void executeInternalTool(NodeInfo node, ObjectTool tool) {
        ObjectToolHandler handler = ObjectToolsCache.findHandler(tool.getData());
        if (handler != null) {
            handler.execute(node.object, tool);
        } else {
            Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)Messages.ObjectToolsDynamicMenu_HandlerNotDefined);
        }
    }

    private static void openURL(NodeInfo node, ObjectTool tool) {
        String url = ObjectToolExecutor.substituteMacros(tool.getData(), node);
        String sid = String.valueOf(Long.toString(node.object.getObjectId())) + "&" + Long.toString(tool.getId());
        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
        try {
            BrowserView view = (BrowserView)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.BrowserView", sid, 1);
            view.openUrl(url);
        }
        catch (PartInitException e) {
            Shell shell = window.getShell();
            Messages.get();
            Messages.get();
            MessageDialogHelper.openError((Shell)shell, (String)Messages.ObjectToolsDynamicMenu_Error, (String)(String.valueOf(Messages.ObjectToolsDynamicMenu_CannotOpenWebBrowser) + e.getLocalizedMessage()));
        }
    }

    private static String substituteMacros(String s, NodeInfo node) {
        StringBuilder sb = new StringBuilder();
        char[] src = s.toCharArray();
        int i = 0;
        while (i < s.length()) {
            if (src[i] == '%') {
                StringBuilder p = new StringBuilder();
                ++i;
                while (src[i] != '%' && i < s.length()) {
                    p.append(src[i]);
                    ++i;
                }
                if (p.length() == 0) {
                    sb.append('%');
                } else {
                    String name = p.toString();
                    if (name.equals("OBJECT_IP_ADDR")) {
                        sb.append(node.object.getPrimaryIP().getHostAddress());
                    } else if (name.equals("OBJECT_NAME")) {
                        sb.append(node.object.getObjectName());
                    } else if (name.equals("OBJECT_ID")) {
                        sb.append(node.object.getObjectId());
                    } else if (name.equals("ALARM_ID")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getId());
                        }
                    } else if (name.equals("ALARM_MESSAGE")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getMessage());
                        }
                    } else if (name.equals("ALARM_SEVERITY")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getCurrentSeverity());
                        }
                    } else if (name.equals("ALARM_SEVERITY_TEXT")) {
                        if (node.alarm != null) {
                            sb.append(StatusDisplayInfo.getStatusText((int)node.alarm.getCurrentSeverity()));
                        }
                    } else if (name.equals("ALARM_STATE")) {
                        if (node.alarm != null) {
                            sb.append(node.alarm.getState());
                        }
                    } else {
                        String custAttr = (String)node.object.getCustomAttributes().get(name);
                        if (custAttr != null) {
                            sb.append(custAttr);
                        }
                    }
                }
            } else {
                sb.append(src[i]);
            }
            ++i;
        }
        return sb.toString();
    }
}

