/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.usermanager.propertypages;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.PropertyPage;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.UserManager;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.usermanager.Messages;

public class SystemRights
extends PropertyPage {
    private UserManager userManager;
    private AbstractUserObject object;
    private Map<Long, Button> buttons = new HashMap<Long, Button>();

    protected Control createContents(Composite parent) {
        this.userManager = (UserManager)ConsoleSharedData.getSession();
        Composite dialogArea = new Composite(parent, 0);
        this.object = (AbstractUserObject)this.getElement().getAdapter(AbstractUserObject.class);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        dialogArea.setLayout((Layout)layout);
        this.addCheckbox(dialogArea, 0x10000000L, "Unlink helpdesk tickets");
        Messages.get();
        this.addCheckbox(dialogArea, 128L, Messages.SystemRights_ConfigureActions);
        Messages.get();
        this.addCheckbox(dialogArea, 32L, Messages.SystemRights_ConfigureEvents);
        Messages.get();
        this.addCheckbox(dialogArea, 16L, Messages.SystemRights_ViewEventConfig);
        Messages.get();
        this.addCheckbox(dialogArea, 65536L, Messages.SystemRights_ConfigureSituations);
        Messages.get();
        this.addCheckbox(dialogArea, 64L, Messages.SystemRights_EditEPP);
        Messages.get();
        this.addCheckbox(dialogArea, 4096L, Messages.SystemRights_ManageScripts);
        Messages.get();
        this.addCheckbox(dialogArea, 2048L, Messages.SystemRights_ConfigureObjTools);
        Messages.get();
        this.addCheckbox(dialogArea, 0x1000000L, Messages.SystemRights_ManageDCISummaryTables);
        Messages.get();
        this.addCheckbox(dialogArea, 4L, Messages.SystemRights_ConfigureTraps);
        Messages.get();
        this.addCheckbox(dialogArea, 32768L, Messages.SystemRights_ManageAgents);
        Messages.get();
        this.addCheckbox(dialogArea, 512L, Messages.SystemRights_ManagePackages);
        Messages.get();
        this.addCheckbox(dialogArea, 1024L, Messages.SystemRights_ViewEventLog);
        Messages.get();
        this.addCheckbox(dialogArea, 16384L, Messages.SystemRights_ViewAuditLog);
        Messages.get();
        this.addCheckbox(dialogArea, 8192L, Messages.SystemRights_ViewTrapLog);
        Messages.get();
        this.addCheckbox(dialogArea, 0x800000L, Messages.SystemRights_ManageMappingTables);
        Messages.get();
        this.addCheckbox(dialogArea, 2L, Messages.SystemRights_EditServerConfig);
        Messages.get();
        this.addCheckbox(dialogArea, 0x100000L, Messages.SystemRights_ReadFiles);
        Messages.get();
        this.addCheckbox(dialogArea, 0x400000L, Messages.SystemRights_ManageFiles);
        Messages.get();
        this.addCheckbox(dialogArea, 0x200000L, Messages.SystemRights_AccessConsole);
        Messages.get();
        this.addCheckbox(dialogArea, 0x4000000L, Messages.SystemRights_ExecuteXMPPCommands);
        Messages.get();
        this.addCheckbox(dialogArea, 8L, Messages.SystemRights_ControlSessions);
        Messages.get();
        this.addCheckbox(dialogArea, 1L, Messages.SystemRights_ManageUsers);
        Messages.get();
        this.addCheckbox(dialogArea, 131072L, Messages.SystemRights_SendSMS);
        Messages.get();
        this.addCheckbox(dialogArea, 524288L, Messages.SystemRights_RegisterAgents);
        Messages.get();
        this.addCheckbox(dialogArea, 262144L, Messages.SystemRights_LoginAsMobile);
        Messages.get();
        this.addCheckbox(dialogArea, 0x8000000L, Messages.SystemRights_ManageImageLibrary);
        return dialogArea;
    }

    private void addCheckbox(Composite parent, long access, String name) {
        Button b = new Button(parent, 32);
        b.setText(name);
        b.setSelection((this.object.getSystemRights() & access) != 0L);
        this.buttons.put(access, b);
    }

    protected void applyChanges(final boolean isApply) {
        if (isApply) {
            this.setValid(false);
        }
        int systemRights = 0;
        for (Map.Entry<Long, Button> e : this.buttons.entrySet()) {
            if (!e.getValue().getSelection()) continue;
            systemRights = (int)((long)systemRights | e.getKey());
        }
        this.object.setSystemRights((long)systemRights);
        Messages.get();
        new ConsoleJob(Messages.SystemRights_JobTitle, null, "org.netxms.ui.eclipse.usermanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                SystemRights.this.userManager.modifyUserDBObject(SystemRights.this.object, 16);
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SystemRights_JobError;
            }

            protected void jobFinalize() {
                if (isApply) {
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            SystemRights.this.setValid(true);
                        }
                    });
                }
            }
        }.start();
    }

    public boolean performOk() {
        this.applyChanges(false);
        return true;
    }

    protected void performApply() {
        this.applyChanges(true);
    }
}

