/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.widgets.LabeledText;

public class RenameFileDialog
extends Dialog {
    private LabeledText textOldFileName;
    private String oldFileName;
    private LabeledText textNewFileName;
    private String newFileName;

    public RenameFileDialog(Shell parentShell, String oldName) {
        super(parentShell);
        this.oldFileName = oldName;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        Messages.get();
        newShell.setText(Messages.StartClientToServerFileUploadDialog_Title);
    }

    protected Control createDialogArea(Composite parent) {
        Composite dialogArea = (Composite)super.createDialogArea(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        layout.verticalSpacing = 5;
        dialogArea.setLayout((Layout)layout);
        this.textOldFileName = new LabeledText(dialogArea, 0);
        this.textOldFileName.setLabel("Old file name");
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textOldFileName.setLayoutData((Object)gd);
        this.textOldFileName.setText(this.oldFileName);
        this.textOldFileName.setEditable(false);
        this.textNewFileName = new LabeledText(dialogArea, 0);
        this.textNewFileName.setLabel("New file name");
        gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        this.textNewFileName.setLayoutData((Object)gd);
        return dialogArea;
    }

    protected void okPressed() {
        this.newFileName = this.textNewFileName.getText();
        if (this.newFileName.contains("/") || this.newFileName.contains("\\")) {
            MessageDialogHelper.openWarning((Shell)this.getShell(), (String)"Rename file error", (String)"File name should not contain '/' and '\\' symbols");
            return;
        }
        super.okPressed();
    }

    public String getNewName() {
        return this.newFileName;
    }
}

