/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.charts.figures;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.birt.chart.api.ChartEngine;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.IGenerator;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.ChartWithAxes;
import org.eclipse.birt.chart.model.ChartWithoutAxes;
import org.eclipse.birt.chart.model.attribute.AxisType;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.ChartDimension;
import org.eclipse.birt.chart.model.attribute.ColorDefinition;
import org.eclipse.birt.chart.model.attribute.Fill;
import org.eclipse.birt.chart.model.attribute.LeaderLineStyle;
import org.eclipse.birt.chart.model.attribute.LegendItemType;
import org.eclipse.birt.chart.model.attribute.LineStyle;
import org.eclipse.birt.chart.model.attribute.Palette;
import org.eclipse.birt.chart.model.attribute.Position;
import org.eclipse.birt.chart.model.attribute.RiserType;
import org.eclipse.birt.chart.model.attribute.Text;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.LineAttributesImpl;
import org.eclipse.birt.chart.model.attribute.impl.PaletteImpl;
import org.eclipse.birt.chart.model.component.Axis;
import org.eclipse.birt.chart.model.component.Series;
import org.eclipse.birt.chart.model.component.impl.SeriesImpl;
import org.eclipse.birt.chart.model.data.DataElement;
import org.eclipse.birt.chart.model.data.DataSet;
import org.eclipse.birt.chart.model.data.NumberDataSet;
import org.eclipse.birt.chart.model.data.SeriesDefinition;
import org.eclipse.birt.chart.model.data.TextDataSet;
import org.eclipse.birt.chart.model.data.impl.NumberDataElementImpl;
import org.eclipse.birt.chart.model.data.impl.NumberDataSetImpl;
import org.eclipse.birt.chart.model.data.impl.SeriesDefinitionImpl;
import org.eclipse.birt.chart.model.data.impl.TextDataSetImpl;
import org.eclipse.birt.chart.model.impl.ChartWithAxesImpl;
import org.eclipse.birt.chart.model.impl.ChartWithoutAxesImpl;
import org.eclipse.birt.chart.model.type.BarSeries;
import org.eclipse.birt.chart.model.type.PieSeries;
import org.eclipse.birt.chart.model.type.impl.BarSeriesImpl;
import org.eclipse.birt.chart.model.type.impl.PieSeriesImpl;
import org.eclipse.birt.core.framework.PlatformConfig;
import org.eclipse.draw2d.Graphics;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.charts.Activator;
import org.netxms.ui.eclipse.charts.api.ChartColor;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.charts.figures.GenericChartFigure;
import org.netxms.ui.eclipse.charts.widgets.internal.DataComparisonElement;
import org.netxms.ui.eclipse.tools.ColorCache;

public class BirtChartFigure
extends GenericChartFigure
implements DataComparisonChart {
    private static final String CHART_FONT_NAME = "Verdana";
    private static final int CHART_FONT_SIZE_TITLE = 8;
    private static final int CHART_FONT_SIZE_LEGEND = 7;
    private static final int CHART_FONT_SIZE_AXIS = 7;
    private int chartType = 0;
    private Chart chart = null;
    private boolean fullRepaint = true;
    private IDeviceRenderer deviceRenderer = null;
    private GC gcImage = null;
    private GeneratedChartState generatedChartState = null;
    private IGenerator generator = null;
    private Image imgChart = null;
    private ColorCache colors;
    private Set<String> errors = new HashSet<String>(0);
    private Image errorImage = null;
    private List<DataComparisonElement> parameters = new ArrayList<DataComparisonElement>(16);
    private Axis xAxis = null;
    private Axis yAxis = null;
    private Series valueSeries = null;
    private boolean transposed = false;
    private boolean labelsVisible = false;
    private double rotation = 0.0;

    public BirtChartFigure(int chartType, ColorCache colors) {
        this.chartType = chartType;
        if (chartType == 1 || chartType == 4) {
            this.labelsVisible = true;
        }
        this.colors = colors;
        try {
            PlatformConfig config = new PlatformConfig();
            config.setBIRTHome("");
            ChartEngine chartEngine = ChartEngine.instance((PlatformConfig)config);
            this.deviceRenderer = chartEngine.getRenderer("dv.SWT");
            this.generator = chartEngine.getGenerator();
        }
        catch (ChartException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.imgChart != null && !this.imgChart.isDisposed()) {
            this.imgChart.dispose();
        }
        if (this.gcImage != null && !this.gcImage.isDisposed()) {
            this.gcImage.dispose();
        }
    }

    protected void recreateChart() {
        this.chart = this.createChart();
        this.fullRepaint = true;
        this.repaint();
    }

    protected Chart createChart() {
        ChartWithoutAxes chart;
        switch (this.chartType) {
            case 0: 
            case 3: {
                chart = this.createChartWithAxes();
                break;
            }
            case 1: {
                chart = this.createChartWithoutAxes();
                break;
            }
            default: {
                chart = ChartWithoutAxesImpl.create();
                chart.getTitle().setVisible(false);
            }
        }
        return chart;
    }

    private Chart createChartWithAxes() {
        ChartWithAxes chart = ChartWithAxesImpl.create();
        chart.setDimension(this.is3DModeEnabled() ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.setTransposed(this.transposed);
        chart.getBlock().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().getClientArea().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.PlotArea"));
        Text tc = chart.getTitle().getLabel().getCaption();
        tc.setValue(this.getChartTitle());
        tc.getFont().setName(CHART_FONT_NAME);
        tc.getFont().setSize(8.0f);
        tc.getFont().setBold(true);
        chart.getTitle().setVisible(this.isTitleVisible());
        chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        chart.getLegend().setVisible(this.isLegendVisible());
        chart.getLegend().setPosition(this.positionFromInt(this.legendPosition));
        chart.getLegend().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getLegend().getText().getFont().setName(CHART_FONT_NAME);
        chart.getLegend().getText().getFont().setSize(7.0f);
        chart.getLegend().getText().getFont().setBold(false);
        this.xAxis = chart.getPrimaryBaseAxes()[0];
        this.xAxis.getTitle().setVisible(false);
        this.xAxis.getLabel().setVisible(false);
        this.yAxis = chart.getPrimaryOrthogonalAxis(this.xAxis);
        this.yAxis.getTitle().setVisible(false);
        this.yAxis.getScale().setMin((DataElement)NumberDataElementImpl.create((double)0.0));
        this.yAxis.getMajorGrid().setLineAttributes(LineAttributesImpl.create((ColorDefinition)this.getColorFromPreferences("Chart.Grid.Y.Color"), (LineStyle)LineStyle.DOTTED_LITERAL, (int)0));
        this.yAxis.setType(this.useLogScale ? AxisType.LOGARITHMIC_LITERAL : AxisType.LINEAR_LITERAL);
        this.yAxis.getLabel().getCaption().getFont().setName(CHART_FONT_NAME);
        this.yAxis.getLabel().getCaption().getFont().setSize(7.0f);
        TextDataSet categoryValues = TextDataSetImpl.create((Object)this.getElementNames());
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)categoryValues);
        SeriesDefinition sdX = SeriesDefinitionImpl.create();
        sdX.setSeriesPalette(this.getBirtPalette());
        this.xAxis.getSeriesDefinitions().add((Object)sdX);
        sdX.getSeries().add((Object)seCategory);
        NumberDataSet valuesDataSet = NumberDataSetImpl.create((Object)this.getElementValues());
        this.valueSeries = this.createSeriesImplementation();
        this.valueSeries.setDataSet((DataSet)valuesDataSet);
        SeriesDefinition sdY = SeriesDefinitionImpl.create();
        this.yAxis.getSeriesDefinitions().add((Object)sdY);
        sdY.getSeries().add((Object)this.valueSeries);
        return chart;
    }

    private Chart createChartWithoutAxes() {
        ChartWithoutAxes chart = ChartWithoutAxesImpl.create();
        chart.setDimension(this.is3DModeEnabled() ? ChartDimension.TWO_DIMENSIONAL_WITH_DEPTH_LITERAL : ChartDimension.TWO_DIMENSIONAL_LITERAL);
        chart.getBlock().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getPlot().getClientArea().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        Text tc = chart.getTitle().getLabel().getCaption();
        tc.setValue(this.getChartTitle());
        tc.getFont().setName(CHART_FONT_NAME);
        tc.getFont().setSize(8.0f);
        tc.getFont().setBold(true);
        chart.getTitle().setVisible(this.isTitleVisible());
        chart.getLegend().setItemType(LegendItemType.CATEGORIES_LITERAL);
        chart.getLegend().setVisible(this.isLegendVisible());
        chart.getLegend().setPosition(this.positionFromInt(this.legendPosition));
        chart.getLegend().setBackground((Fill)this.getColorFromPreferences("Chart.Colors.Background"));
        chart.getLegend().getText().getFont().setName(CHART_FONT_NAME);
        chart.getLegend().getText().getFont().setSize(7.0f);
        chart.getLegend().getText().getFont().setBold(false);
        SeriesDefinition sdCategory = SeriesDefinitionImpl.create();
        sdCategory.setSeriesPalette(this.getBirtPalette());
        Series seCategory = SeriesImpl.create();
        seCategory.setDataSet((DataSet)TextDataSetImpl.create((Object)this.getElementNames()));
        sdCategory.getSeries().add((Object)seCategory);
        chart.getSeriesDefinitions().add((Object)sdCategory);
        SeriesDefinition sdValues = SeriesDefinitionImpl.create();
        NumberDataSet valuesDataSet = NumberDataSetImpl.create((Object)this.getElementValues());
        this.valueSeries = this.createSeriesImplementation();
        this.valueSeries.setDataSet((DataSet)valuesDataSet);
        sdValues.getSeries().add((Object)this.valueSeries);
        sdCategory.getSeriesDefinitions().add((Object)sdValues);
        return chart;
    }

    private Series createSeriesImplementation() {
        switch (this.chartType) {
            case 0: 
            case 3: {
                BarSeries bs = (BarSeries)BarSeriesImpl.create();
                bs.setTranslucent(this.translucent);
                if (this.chartType == 3) {
                    bs.setRiser(RiserType.TUBE_LITERAL);
                }
                bs.getLabel().setVisible(this.labelsVisible);
                return bs;
            }
            case 1: {
                PieSeries ps = (PieSeries)PieSeriesImpl.create();
                ps.setRotation(this.rotation);
                if (this.is3DModeEnabled()) {
                    ps.setExplosion(3);
                    ps.setRatio(0.4);
                } else {
                    ps.setExplosion(0);
                    ps.setRatio(1.0);
                }
                ps.setTranslucent(this.translucent);
                ps.getLabel().setVisible(this.labelsVisible);
                if (this.labelsVisible) {
                    ps.setLabelPosition(Position.OUTSIDE_LITERAL);
                    ps.setLeaderLineStyle(LeaderLineStyle.FIXED_LENGTH_LITERAL);
                    ps.getLeaderLineAttributes().setVisible(true);
                    ps.getLabel().getCaption().getFont().setName(CHART_FONT_NAME);
                    ps.getLabel().getCaption().getFont().setSize(7.0f);
                }
                return ps;
            }
        }
        return null;
    }

    private String[] getElementNames() {
        String[] names = new String[this.parameters.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = this.parameters.get(i).getName();
            ++i;
        }
        return names;
    }

    private double[] getElementValues() {
        double[] values = new double[this.parameters.size()];
        int i = 0;
        while (i < values.length) {
            values[i] = this.parameters.get(i).getValue();
            ++i;
        }
        return values;
    }

    @Override
    public void initializationComplete() {
        this.chart = this.createChart();
        this.fullRepaint = true;
        this.repaint();
    }

    protected ColorDefinition getColorFromPreferences(String name) {
        RGB rgb = PreferenceConverter.getColor((IPreferenceStore)this.preferenceStore, (String)name);
        return ColorDefinitionImpl.create((int)rgb.red, (int)rgb.green, (int)rgb.blue);
    }

    protected Position positionFromInt(int value) {
        switch (value) {
            case 1: {
                return Position.LEFT_LITERAL;
            }
            case 2: {
                return Position.RIGHT_LITERAL;
            }
            case 4: {
                return Position.ABOVE_LITERAL;
            }
            case 8: {
                return Position.BELOW_LITERAL;
            }
        }
        return Position.RIGHT_LITERAL;
    }

    protected void paintFigure(Graphics gc) {
        if (this.chart == null) {
            return;
        }
        Rectangle clientArea = this.getClientArea();
        if (clientArea.width == 0 || clientArea.height == 0) {
            return;
        }
        if (this.fullRepaint) {
            if (this.imgChart != null && !this.imgChart.isDisposed()) {
                this.imgChart.dispose();
            }
            if (this.gcImage != null && !this.gcImage.isDisposed()) {
                this.gcImage.dispose();
            }
            this.imgChart = new Image((Device)Display.getCurrent(), clientArea.width, clientArea.height);
            this.gcImage = new GC((Drawable)this.imgChart);
            this.deviceRenderer.setProperty("device.output.context", (Object)this.gcImage);
            Bounds bounds = BoundsImpl.create((double)0.0, (double)0.0, (double)clientArea.width, (double)clientArea.height);
            bounds.scale(72.0 / (double)this.deviceRenderer.getDisplayServer().getDpiResolution());
            try {
                this.generatedChartState = this.generator.build(this.deviceRenderer.getDisplayServer(), this.chart, bounds, null, null, null);
                this.generator.render(this.deviceRenderer, this.generatedChartState);
            }
            catch (ChartException e) {
                e.printStackTrace();
            }
            this.fullRepaint = false;
        }
        gc.drawImage(this.imgChart, clientArea.x, clientArea.y);
        this.paintErrorIndicator(gc);
    }

    @Override
    public void rebuild() {
        this.recreateChart();
    }

    @Override
    public void setChartTitle(String title) {
        this.title = title;
        if (this.chart != null) {
            this.chart.getTitle().getLabel().getCaption().setValue(title);
            this.refresh();
        }
    }

    @Override
    public void setLegendVisible(boolean visible) {
        this.legendVisible = visible;
        if (this.chart != null) {
            this.chart.getLegend().setVisible(visible);
            this.refresh();
        }
    }

    @Override
    public void setTitleVisible(boolean visible) {
        this.titleVisible = visible;
        if (this.chart != null) {
            this.chart.getTitle().setVisible(visible);
        }
    }

    @Override
    public void set3DModeEnabled(boolean enabled) {
        this.displayIn3D = enabled;
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    protected Palette getBirtPalette() {
        Palette birtPalette = PaletteImpl.create((int)0, (boolean)true);
        ChartColor[] chartColorArray = this.palette;
        int n = this.palette.length;
        int n2 = 0;
        while (n2 < n) {
            ChartColor c = chartColorArray[n2];
            birtPalette.getEntries().add((Object)ColorDefinitionImpl.create((int)c.red, (int)c.green, (int)c.blue, (int)c.alpha));
            ++n2;
        }
        return birtPalette;
    }

    @Override
    public void setLogScaleEnabled(boolean enabled) {
        if (this.useLogScale != enabled) {
            this.useLogScale = enabled;
            if (this.chart != null) {
                this.recreateChart();
            }
        }
    }

    @Override
    public void setTranslucent(boolean translucent) {
        super.setTranslucent(translucent);
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public void addError(String message) {
        if (this.errors.add(message)) {
            this.repaint();
        }
    }

    @Override
    public void clearErrors() {
        if (this.errors.size() > 0) {
            this.errors.clear();
            this.repaint();
        }
    }

    private void paintErrorIndicator(Graphics gc) {
        if (this.errors.size() == 0) {
            return;
        }
        if (this.errorImage == null) {
            this.errorImage = Activator.getImageDescriptor("icons/chart_error.png").createImage();
        }
        gc.setAlpha(127);
        gc.setBackgroundColor(this.colors.create(127, 127, 127));
        gc.fillRectangle(this.getClientArea());
        gc.setAlpha(255);
        gc.drawImage(this.errorImage, 10, 10);
        gc.setForegroundColor(this.colors.create(192, 0, 0));
        Iterator<String> it = this.errors.iterator();
        int y = 12;
        int h = 12;
        while (it.hasNext()) {
            gc.drawText(it.next(), 40, y);
            y += h + 5;
        }
    }

    @Override
    public int getChartType() {
        return this.chartType;
    }

    @Override
    public void setChartType(int chartType) {
        if (this.chartType != chartType && this.chart != null) {
            this.chartType = chartType;
            this.recreateChart();
        } else {
            this.chartType = chartType;
        }
    }

    @Override
    public int addParameter(GraphItem dci, double value) {
        this.parameters.add(new DataComparisonElement(dci, value, null));
        return this.parameters.size() - 1;
    }

    @Override
    public void updateParameter(int index, double value, boolean updateChart) {
        try {
            this.parameters.get(index).setValue(value);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
        if (updateChart) {
            this.refresh();
        }
    }

    @Override
    public void updateParameter(int index, DciDataRow value, int dataType, boolean updateChart) {
        this.updateParameter(index, value.getValueAsDouble(), updateChart);
    }

    @Override
    public void updateParameterThresholds(int index, Threshold[] thresholds) {
        try {
            this.parameters.get(index).setThresholds(thresholds);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {}
    }

    @Override
    public void refresh() {
        if (this.valueSeries == null) {
            return;
        }
        this.valueSeries.setDataSet((DataSet)NumberDataSetImpl.create((Object)this.getElementValues()));
        this.fullRepaint = true;
        this.repaint();
    }

    @Override
    public void setTransposed(boolean transposed) {
        this.transposed = transposed;
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public boolean isTransposed() {
        return this.transposed;
    }

    @Override
    public boolean hasAxes() {
        return this.chartType == 0;
    }

    @Override
    public void setLabelsVisible(boolean visible) {
        this.labelsVisible = visible;
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public boolean isLabelsVisible() {
        return this.labelsVisible;
    }

    @Override
    public void setRotation(double angle) {
        this.rotation = angle;
        if (this.chart != null) {
            this.recreateChart();
        }
    }

    @Override
    public double getRotation() {
        return this.rotation;
    }

    @Override
    public boolean isGridVisible() {
        return false;
    }

    @Override
    public void setGridVisible(boolean visible) {
    }

    @Override
    public void setBackgroundColor(ChartColor color) {
    }

    @Override
    public void setPlotAreaColor(ChartColor color) {
    }

    @Override
    public void setLegendColor(ChartColor foreground, ChartColor background) {
    }

    @Override
    public void setAxisColor(ChartColor color) {
    }

    @Override
    public void setGridColor(ChartColor color) {
    }

    @Override
    public void setYAxisRange(int from, int to) {
        if (from == to) {
            return;
        }
        if (from > to) {
            int tmp = to;
            to = from;
            from = tmp;
        }
        if (this.yAxis == null) {
            this.xAxis = ((ChartWithAxes)this.chart).getPrimaryBaseAxes()[0];
            this.yAxis = ((ChartWithAxes)this.chart).getPrimaryOrthogonalAxis(this.xAxis);
            this.yAxis.getScale().setMin((DataElement)NumberDataElementImpl.create((double)from));
            this.yAxis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)to));
        } else {
            this.yAxis.getScale().setMin((DataElement)NumberDataElementImpl.create((double)from));
            this.yAxis.getScale().setMax((DataElement)NumberDataElementImpl.create((double)to));
        }
    }
}

