/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets.helpers;

import java.text.SimpleDateFormat;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.netxms.api.client.reporting.ReportingJob;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.client.NXCSession;
import org.netxms.ui.eclipse.console.resources.RegionalSettings;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ScheduleLabelProvider
extends LabelProvider
implements ITableLabelProvider {
    private String[] dayOfWeek = new String[]{"MON", "TUE", "WED", "THU", "FRI", "SAT", "SUN"};

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        ReportingJob job = (ReportingJob)element;
        switch (columnIndex) {
            case 1: {
                SimpleDateFormat timeFormat = new SimpleDateFormat("HH:mm");
                String HHmm = timeFormat.format(job.getStartTime().getTime() / 1000L);
                switch (job.getType()) {
                    case 0: {
                        return RegionalSettings.getDateTimeFormat().format(job.getStartTime().getTime() / 1000L);
                    }
                    case 1: {
                        return HHmm;
                    }
                    case 3: {
                        String result = "";
                        int i = 0;
                        while (i < 31) {
                            if ((job.getDaysOfMonth() >> i & 1) != 0) {
                                result = String.valueOf(String.valueOf(31 - i)) + (result.length() > 0 ? "," : "") + result;
                            }
                            ++i;
                        }
                        return String.valueOf(HHmm) + " - " + result;
                    }
                    case 2: {
                        String result1 = "";
                        int i = 0;
                        while (i < 7) {
                            if ((job.getDaysOfWeek() >> i & 1) != 0) {
                                result1 = String.valueOf(this.dayOfWeek[7 - (i + 1)]) + (result1.length() > 0 ? "," : "") + result1;
                            }
                            ++i;
                        }
                        return String.valueOf(HHmm) + " - " + result1;
                    }
                }
                return "<error>";
            }
            case 0: {
                switch (job.getType()) {
                    case 0: {
                        return "once";
                    }
                    case 1: {
                        return "daily";
                    }
                    case 3: {
                        return "monthly";
                    }
                    case 2: {
                        return "weekly";
                    }
                }
                return "<error>";
            }
            case 2: {
                AbstractUserObject user = ((NXCSession)ConsoleSharedData.getSession()).findUserDBObjectById((long)job.getUserId());
                return user != null ? user.getName() : "[" + job.getUserId() + "]";
            }
            case 3: {
                return job.getComments();
            }
        }
        return "<INTERNAL ERROR>";
    }
}

