/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netxms.client.maps.NetworkMapLink;
import org.netxms.client.maps.elements.NetworkMapElement;
import org.netxms.client.maps.elements.NetworkMapObject;

public class NetworkMapPage {
    private String id;
    private long nextElementId;
    private Map<Long, NetworkMapElement> elements = new HashMap<Long, NetworkMapElement>(0);
    private Set<NetworkMapLink> links = new HashSet<NetworkMapLink>(0);

    public NetworkMapPage(String id) {
        this.id = id;
        this.nextElementId = 1L;
    }

    public void addElement(NetworkMapElement element) {
        this.elements.put(element.getId(), element);
        if (element.getId() >= this.nextElementId) {
            this.nextElementId = element.getId() + 1L;
        }
    }

    public void addAllElements(Collection<NetworkMapElement> set) {
        for (NetworkMapElement e : set) {
            this.addElement(e);
        }
    }

    public void addLink(NetworkMapLink link) {
        this.links.add(link);
    }

    public void addAllLinks(Collection<NetworkMapLink> set) {
        this.links.addAll(set);
    }

    public NetworkMapElement getElement(long elementId, Class<? extends NetworkMapElement> requiredClass) {
        NetworkMapElement e = this.elements.get(elementId);
        if (e == null || requiredClass == null) {
            return e;
        }
        return requiredClass.isInstance(e) ? e : null;
    }

    public void removeElement(long elementId) {
        this.elements.remove(elementId);
        Iterator<NetworkMapLink> it = this.links.iterator();
        while (it.hasNext()) {
            NetworkMapLink l = it.next();
            if (l.getElement1() != elementId && l.getElement2() != elementId) continue;
            it.remove();
        }
    }

    public void removeObjectElement(long objectId) {
        long elementId = -1L;
        for (NetworkMapElement element : this.elements.values()) {
            if (!(element instanceof NetworkMapObject) || ((NetworkMapObject)element).getObjectId() != objectId) continue;
            elementId = element.getId();
            break;
        }
        if (elementId != -1L) {
            this.removeElement(elementId);
        }
    }

    public void removeLink(NetworkMapLink link) {
        this.links.remove(link);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Collection<NetworkMapElement> getElements() {
        return this.elements.values();
    }

    public Collection<NetworkMapLink> getLinks() {
        return this.links;
    }

    public long createElementId() {
        return this.nextElementId++;
    }

    public NetworkMapObject findObjectElement(long objectId) {
        for (NetworkMapElement e : this.elements.values()) {
            if (!(e instanceof NetworkMapObject) || ((NetworkMapObject)e).getObjectId() != objectId) continue;
            return (NetworkMapObject)e;
        }
        return null;
    }

    public List<NetworkMapLink> findLinks(NetworkMapElement source, NetworkMapElement destination) {
        ArrayList<NetworkMapLink> result = new ArrayList<NetworkMapLink>();
        for (NetworkMapLink l : this.links) {
            if (l.getElement1() != source.getId() || l.getElement2() != destination.getId()) continue;
            result.add(l);
        }
        return result;
    }

    public List<NetworkMapLink> findLinksWithStatusObject(long objectId) {
        ArrayList<NetworkMapLink> list = null;
        for (NetworkMapLink l : this.links) {
            for (Long obj : l.getStatusObject()) {
                if (obj != objectId) continue;
                if (list == null) {
                    list = new ArrayList<NetworkMapLink>();
                }
                list.add(l);
            }
        }
        return list;
    }

    public boolean areObjectsConnected(long objectId1, long objectId2) {
        for (NetworkMapLink l : this.links) {
            if ((l.getElement1() != objectId1 || l.getElement2() != objectId2) && (l.getElement1() != objectId2 || l.getElement2() != objectId1)) continue;
            return true;
        }
        return false;
    }

    public Object[] getElementsAndLinks() {
        Object[] list = new Object[this.elements.size() + this.links.size()];
        int i = 0;
        for (NetworkMapElement e : this.elements.values()) {
            list[i++] = e;
        }
        for (NetworkMapLink l : this.links) {
            list[i++] = l;
        }
        return list;
    }

    public NetworkMapElement[] getConnectedElements(long root) {
        HashSet<NetworkMapElement> result = new HashSet<NetworkMapElement>(0);
        for (NetworkMapLink link : this.links) {
            long id;
            NetworkMapElement e;
            if (link.getElement1() != root || (e = this.elements.get(id = link.getElement2())) == null) continue;
            result.add(e);
        }
        return result.toArray(new NetworkMapElement[result.size()]);
    }
}

