/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.maps;

import java.util.HashSet;
import java.util.Set;
import org.netxms.base.NXCPMessage;

public class MapDCIInstance {
    private long dciID;
    private long nodeID;
    private int type;
    private String column;
    private String instance;
    private Set<String> mapList = new HashSet<String>();

    public MapDCIInstance(long dciID, long nodeID, String column, String instance, int type, String mapId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn(column);
        this.setInstance(instance);
        this.type = type;
        this.mapList.add(mapId);
    }

    public MapDCIInstance(long dciID, long nodeID, int type, String mapId) {
        this.setDciID(dciID);
        this.setNodeID(nodeID);
        this.setColumn("");
        this.setInstance("");
        this.type = type;
        this.mapList.add(mapId);
    }

    public String getColumn() {
        return this.column;
    }

    public void setColumn(String column) {
        this.column = column;
    }

    public String getInstance() {
        return this.instance;
    }

    public void setInstance(String instance) {
        this.instance = instance;
    }

    public long getDciID() {
        return this.dciID;
    }

    public void setDciID(long dciID) {
        this.dciID = dciID;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public long getNodeID() {
        return this.nodeID;
    }

    public void setNodeID(long nodeID) {
        this.nodeID = nodeID;
    }

    public void fillMessage(NXCPMessage msg, long base) {
        if (this.type == 2 && (this.column.isEmpty() || this.instance.isEmpty())) {
            return;
        }
        msg.setVariableInt32(base++, (int)this.nodeID);
        msg.setVariableInt32(base++, (int)this.dciID);
        if (this.type == 2) {
            msg.setVariable(base++, this.column);
            msg.setVariable(base++, this.instance);
        }
    }

    public void addMap(String id) {
        this.mapList.add(id);
    }

    public boolean removeMap(String id) {
        this.mapList.remove(id);
        return this.mapList.size() == 0;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.column == null || this.type == 2 ? 0 : this.column.hashCode());
        result = 31 * result + (int)(this.dciID ^ this.dciID >>> 32);
        result = 31 * result + (this.instance == null || this.type == 2 ? 0 : this.instance.hashCode());
        result = 31 * result + (int)(this.nodeID ^ this.nodeID >>> 32);
        result = 31 * result + this.type;
        return result;
    }

    public boolean equals(Object object) {
        boolean result;
        if (object == this) {
            return true;
        }
        if (object == null || !(object instanceof MapDCIInstance)) {
            return false;
        }
        MapDCIInstance i = (MapDCIInstance)object;
        if (i.type != this.type) {
            return false;
        }
        boolean bl = result = i.dciID == this.dciID;
        if (result && i.type == 2) {
            result = i.column.equals(this.column) && i.instance.equals(this.instance);
        }
        return result;
    }
}

