/*
 * Decompiled with CFR 0.152.
 */
package com.radensolutions.jira;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.jira.event.issue.IssueEvent;
import com.atlassian.jira.event.type.EventType;
import com.atlassian.jira.issue.Issue;
import com.atlassian.jira.issue.comments.Comment;
import com.radensolutions.jira.NetxmsConnector;
import com.radensolutions.jira.SettingsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class NetxmsEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger log = LoggerFactory.getLogger(NetxmsEventListener.class);
    private final EventPublisher eventPublisher;
    private final NetxmsConnector connector;
    private final SettingsManager settingsManager;

    public NetxmsEventListener(EventPublisher eventPublisher, SettingsManager settingsManager) {
        this.eventPublisher = eventPublisher;
        this.settingsManager = settingsManager;
        this.connector = new NetxmsConnector(settingsManager);
    }

    public void destroy() throws Exception {
        log.debug("Unregister listener");
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        log.debug("Register listener");
        this.eventPublisher.register((Object)this);
    }

    @EventListener
    public void onIssueEvent(IssueEvent issueEvent) {
        String configuredProjectKey;
        if (!this.settingsManager.isEnabled()) {
            log.debug("Plugin is disabled, ignoring event");
            return;
        }
        Long eventTypeId = issueEvent.getEventTypeId();
        Issue issue = issueEvent.getIssue();
        log.debug("Issue {} event: {}", (Object)issue.getId(), (Object)eventTypeId);
        String name = issueEvent.getUser().getName();
        if (name.equalsIgnoreCase(this.settingsManager.getJiraAccount())) {
            return;
        }
        String issueProjectKey = issueEvent.getProject().getKey();
        if (issueProjectKey.equalsIgnoreCase(configuredProjectKey = this.settingsManager.getProjectKey())) {
            log.debug("Project key matched");
            String comment = this.getCommentText(issueEvent.getComment());
            if (eventTypeId.equals(EventType.ISSUE_COMMENTED_ID) || eventTypeId.equals(EventType.ISSUE_COMMENT_EDITED_ID)) {
                this.connector.commentOnAlarm(issue.getKey(), comment);
            } else if (eventTypeId.equals(EventType.ISSUE_DELETED_ID)) {
                this.connector.removeHelpdeskReference(issue.getKey());
            }
        } else {
            log.debug("Issue project key ({}) do not match configured ({}", (Object)issueProjectKey, (Object)configuredProjectKey);
        }
    }

    private String getCommentText(Comment comment) {
        if (comment != null) {
            return comment.getAuthor() + ": " + comment.getBody();
        }
        return null;
    }
}

