/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.api.client.images;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.UUID;
import org.netxms.base.NXCPMessage;

public class LibraryImage
implements Comparable<LibraryImage> {
    private UUID guid;
    private String name;
    private String category;
    private String mimeType;
    private byte[] binaryData;
    private boolean imageProtected;
    private boolean complete = false;

    public LibraryImage(UUID guid) {
        this.guid = guid;
    }

    public LibraryImage(UUID guid, String name, String category, String mimeType, boolean imageProtected) {
        this.guid = guid;
        this.name = name;
        this.category = category;
        this.mimeType = mimeType;
        this.imageProtected = imageProtected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LibraryImage(NXCPMessage msg, File imageFile) {
        this.guid = msg.getVariableAsUUID(222L);
        this.name = msg.getVariableAsString(20L);
        this.category = msg.getVariableAsString(75L);
        this.mimeType = msg.getVariableAsString(372L);
        this.imageProtected = msg.getVariableAsBoolean(370L);
        this.binaryData = new byte[(int)imageFile.length()];
        FileInputStream in = null;
        try {
            in = new FileInputStream(imageFile);
            ((InputStream)in).read(this.binaryData);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (in != null) {
                    ((InputStream)in).close();
                }
                imageFile.delete();
            }
            catch (Exception e) {}
        }
        this.complete = true;
    }

    public LibraryImage() {
    }

    public void fillMessage(NXCPMessage msg) {
        if (this.guid != null) {
            msg.setVariable(222L, this.guid);
        }
        msg.setVariable(20L, this.name);
        if (this.category != null) {
            msg.setVariable(75L, this.category);
        }
    }

    public UUID getGuid() {
        return this.guid;
    }

    public void setGuid(UUID guid) {
        this.guid = guid;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public byte[] getBinaryData() {
        return this.binaryData;
    }

    public void setBinaryData(byte[] binaryData) {
        this.binaryData = binaryData;
    }

    public boolean isProtected() {
        return this.imageProtected;
    }

    public boolean isComplete() {
        return this.complete;
    }

    public String getMimeType() {
        return this.mimeType;
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }

    public String toString() {
        return "LibraryImage [guid=" + this.guid + ", name=" + this.name + ", category=" + this.category + ", mimeType=" + this.mimeType + ", binaryData=" + (this.binaryData == null ? "[null]" : "[not null]") + ", imageProtected=" + this.imageProtected + ", complete=" + this.complete + "]";
    }

    @Override
    public int compareTo(LibraryImage o) {
        return this.name.compareToIgnoreCase(o.getName());
    }
}

