/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;
import java.util.IllegalFormatException;
import org.netxms.base.NXCPMessage;
import org.netxms.client.datacollection.SimpleDciValue;
import org.netxms.client.datacollection.TableDciValue;
import org.netxms.client.datacollection.Threshold;

public abstract class DciValue {
    private long id;
    private long nodeId;
    private long templateDciId;
    private String name;
    private String description;
    private String value;
    private int source;
    private int dataType;
    private int status;
    private int errorCount;
    private int dcObjectType;
    private Date timestamp;
    private Threshold activeThreshold;

    public static DciValue createFromMessage(long nodeId, NXCPMessage msg, long base) {
        int type = msg.getVariableAsInteger(base + 8L);
        switch (type) {
            case 1: {
                return new SimpleDciValue(nodeId, msg, base);
            }
            case 2: {
                return new TableDciValue(nodeId, msg, base);
            }
        }
        return null;
    }

    protected DciValue(long nodeId, NXCPMessage msg, long base) {
        long var = base;
        this.nodeId = nodeId;
        this.id = msg.getVariableAsInt64(var++);
        this.name = msg.getVariableAsString(var++);
        this.description = msg.getVariableAsString(var++);
        this.source = msg.getVariableAsInteger(var++);
        this.dataType = msg.getVariableAsInteger(var++);
        this.value = msg.getVariableAsString(var++);
        this.timestamp = new Date(msg.getVariableAsInt64(var++) * 1000L);
        this.status = msg.getVariableAsInteger(var++);
        this.dcObjectType = msg.getVariableAsInteger(var++);
        this.errorCount = msg.getVariableAsInteger(var++);
        this.templateDciId = msg.getVariableAsInt64(var++);
        this.activeThreshold = msg.getVariableAsBoolean(var++) ? new Threshold(msg, var) : null;
    }

    public DciValue(long id, String value, int dataType, int status) {
        this.id = id;
        this.value = value;
        this.dataType = dataType;
        this.status = status;
    }

    public String format(String formatString) {
        Object v;
        String dciType = "String";
        try {
            switch (this.dataType) {
                case 0: 
                case 1: {
                    dciType = "Integer";
                    v = Integer.parseInt(this.value);
                    break;
                }
                case 5: {
                    dciType = "Float";
                    v = Float.valueOf(Float.parseFloat(this.value));
                    break;
                }
                case 2: 
                case 3: {
                    dciType = "Long";
                    v = Long.parseLong(this.value);
                    break;
                }
                default: {
                    v = this.value;
                    break;
                }
            }
        }
        catch (NumberFormatException e) {
            v = this.value;
        }
        String result = "";
        try {
            result = String.format(formatString, v);
        }
        catch (IllegalFormatException e) {
            result = "String format exception. DCI type " + dciType;
        }
        return result;
    }

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getValue() {
        return this.value;
    }

    public int getSource() {
        return this.source;
    }

    public int getDataType() {
        return this.dataType;
    }

    public int getStatus() {
        return this.status;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public Threshold getActiveThreshold() {
        return this.activeThreshold;
    }

    public int getDcObjectType() {
        return this.dcObjectType;
    }

    public int getErrorCount() {
        return this.errorCount;
    }

    public final long getTemplateDciId() {
        return this.templateDciId;
    }
}

