/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.datacollection;

import java.util.Date;
import org.netxms.base.NXCPMessage;
import org.netxms.client.constants.Severity;

public class Threshold {
    public static final int F_LAST = 0;
    public static final int F_AVERAGE = 1;
    public static final int F_DEVIATION = 2;
    public static final int F_DIFF = 3;
    public static final int F_ERROR = 4;
    public static final int F_SUM = 5;
    public static final int F_SCRIPT = 6;
    public static final int OP_LE = 0;
    public static final int OP_LE_EQ = 1;
    public static final int OP_EQ = 2;
    public static final int OP_GT_EQ = 3;
    public static final int OP_GT = 4;
    public static final int OP_NE = 5;
    public static final int OP_LIKE = 6;
    public static final int OP_NOTLIKE = 7;
    private long id;
    private int fireEvent;
    private int rearmEvent;
    private int sampleCount;
    private int function;
    private int operation;
    private String script;
    private int repeatInterval;
    private String value;
    private boolean active;
    private Severity currentSeverity;
    private Date lastEventTimestamp;

    public Threshold(NXCPMessage msg, long baseId) {
        long varId = baseId;
        this.id = msg.getVariableAsInt64(varId++);
        this.fireEvent = msg.getVariableAsInteger(varId++);
        this.rearmEvent = msg.getVariableAsInteger(varId++);
        this.function = msg.getVariableAsInteger(varId++);
        this.operation = msg.getVariableAsInteger(varId++);
        this.sampleCount = msg.getVariableAsInteger(varId++);
        this.script = msg.getVariableAsString(varId++);
        this.repeatInterval = msg.getVariableAsInteger(varId++);
        this.value = msg.getVariableAsString(varId++);
        this.active = msg.getVariableAsBoolean(varId++);
        this.currentSeverity = Severity.getByValue(msg.getVariableAsInteger(varId++));
        this.lastEventTimestamp = msg.getVariableAsDate(varId);
    }

    public Threshold() {
        this.id = 0L;
        this.fireEvent = 17;
        this.rearmEvent = 18;
        this.sampleCount = 1;
        this.script = null;
        this.function = 0;
        this.operation = 0;
        this.repeatInterval = -1;
        this.value = "0";
        this.active = false;
        this.currentSeverity = Severity.NORMAL;
        this.lastEventTimestamp = new Date(0L);
    }

    public Threshold(Threshold src) {
        this.id = src.id;
        this.fireEvent = src.fireEvent;
        this.rearmEvent = src.rearmEvent;
        this.sampleCount = src.sampleCount;
        this.script = src.script;
        this.function = src.function;
        this.operation = src.operation;
        this.repeatInterval = src.repeatInterval;
        this.value = src.value;
        this.active = src.active;
        this.currentSeverity = src.currentSeverity;
        this.lastEventTimestamp = src.lastEventTimestamp;
    }

    protected void fillMessage(NXCPMessage msg, long baseId) {
        long varId = baseId;
        msg.setVariableInt32(varId++, (int)this.id);
        msg.setVariableInt32(varId++, this.fireEvent);
        msg.setVariableInt32(varId++, this.rearmEvent);
        msg.setVariableInt16(varId++, this.function);
        msg.setVariableInt16(varId++, this.operation);
        msg.setVariableInt32(varId++, this.sampleCount);
        msg.setVariable(varId++, this.script);
        msg.setVariableInt32(varId++, this.repeatInterval);
        msg.setVariable(varId++, this.value);
    }

    public int getFireEvent() {
        return this.fireEvent;
    }

    public void setFireEvent(int fireEvent) {
        this.fireEvent = fireEvent;
    }

    public int getRearmEvent() {
        return this.rearmEvent;
    }

    public void setRearmEvent(int rearmEvent) {
        this.rearmEvent = rearmEvent;
    }

    public int getSampleCount() {
        return this.sampleCount;
    }

    public void setSampleCount(int sampleCount) {
        this.sampleCount = sampleCount;
    }

    public int getFunction() {
        return this.function;
    }

    public void setFunction(int function) {
        this.function = function;
    }

    public int getOperation() {
        return this.operation;
    }

    public void setOperation(int operation) {
        this.operation = operation;
    }

    public int getRepeatInterval() {
        return this.repeatInterval;
    }

    public void setRepeatInterval(int repeatInterval) {
        this.repeatInterval = repeatInterval;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public long getId() {
        return this.id;
    }

    public boolean isActive() {
        return this.active;
    }

    public Severity getCurrentSeverity() {
        return this.currentSeverity;
    }

    public Date getLastEventTimestamp() {
        return this.lastEventTimestamp;
    }

    public String getScript() {
        return this.script;
    }

    public void setScript(String script) {
        this.script = script;
    }
}

