/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.client.topology;

import org.netxms.base.NXCPMessage;
import org.netxms.client.MacAddress;

public class FdbEntry {
    private MacAddress address;
    private int interfaceIndex;
    private String interfaceName;
    private int port;
    private long nodeId;
    private int vlanId;
    private int type;

    public FdbEntry(NXCPMessage msg, long baseId) {
        this.address = new MacAddress(msg.getVariableAsBinary(baseId));
        this.interfaceIndex = msg.getVariableAsInteger(baseId + 1L);
        this.port = msg.getVariableAsInteger(baseId + 2L);
        this.nodeId = msg.getVariableAsInt64(baseId + 3L);
        this.vlanId = msg.getVariableAsInteger(baseId + 4L);
        this.type = msg.getVariableAsInteger(baseId + 5L);
        this.interfaceName = msg.getVariableAsString(baseId + 6L);
    }

    public MacAddress getAddress() {
        return this.address;
    }

    public int getInterfaceIndex() {
        return this.interfaceIndex;
    }

    public int getPort() {
        return this.port;
    }

    public long getNodeId() {
        return this.nodeId;
    }

    public int getVlanId() {
        return this.vlanId;
    }

    public int getType() {
        return this.type;
    }

    public String toString() {
        return "FdbEntry [address=" + this.address + ", interfaceIndex=" + this.interfaceIndex + ", port=" + this.port + ", nodeId=" + this.nodeId + ", vlanId=" + this.vlanId + ", type=" + this.type + "]";
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }
}

