/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.nxsl.views;

import java.io.IOException;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.ISaveablePart2;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.contexts.IContextService;
import org.eclipse.ui.forms.widgets.Form;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.scripts.Script;
import org.netxms.api.client.scripts.ScriptLibraryManager;
import org.netxms.client.NXCSession;
import org.netxms.client.TextOutputListener;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.nxsl.dialogs.CreateScriptDialog;
import org.netxms.ui.eclipse.nxsl.dialogs.SaveScriptDialog;
import org.netxms.ui.eclipse.nxsl.widgets.ScriptEditor;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.TextConsole;

public class ScriptExecutor
extends ViewPart
implements ISaveablePart2,
TextOutputListener {
    public static final String ID = "org.netxms.ui.eclipse.nxsl.views.ScriptExecutor";
    private NXCSession session;
    private ScriptLibraryManager scriptLibraryManager;
    private boolean modified = false;
    private long objectId;
    private Form form;
    private Combo scriptCombo;
    private ScriptEditor scriptEditor;
    private TextConsole output;
    private IOConsoleOutputStream consoleOutputStream;
    private Action actionSave;
    private Action actionSaveAs;
    private Action actionClear;
    private Action actionClearOutput;
    private Action actionReload;
    private Action actionExecute;
    private List<Script> library;
    private int previousSelection = -1;
    private boolean allowSaveAs = false;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.objectId = Long.parseLong(site.getSecondaryId());
        this.scriptLibraryManager = (ScriptLibraryManager)ConsoleSharedData.getSession();
        this.setPartName("Execute Script - " + this.session.getObjectName(this.objectId));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        FormToolkit toolkit = new FormToolkit(this.getSite().getShell().getDisplay());
        Composite formContainer = new Composite(parent, 0);
        formContainer.setLayout((Layout)new FillLayout());
        this.form = toolkit.createForm(formContainer);
        this.form.setText("noname");
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 8;
        this.form.getBody().setLayout((Layout)layout);
        this.scriptCombo = WidgetHelper.createLabeledCombo((Composite)this.form.getBody(), (int)8, (String)"Script from library", (Object)"WidgetHelper::default_layout_data", (FormToolkit)toolkit);
        this.updateScriptList(null);
        this.scriptCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(true)) {
                    return;
                }
                ScriptExecutor.this.getScriptContent();
                ScriptExecutor.this.previousSelection = ScriptExecutor.this.scriptCombo.getSelectionIndex();
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        SashForm splitter = new SashForm(this.form.getBody(), 512);
        splitter.setSashWidth(3);
        GridData gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        splitter.setLayoutData((Object)gridData);
        Composite container = toolkit.createComposite((Composite)splitter);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginBottom = 4;
        container.setLayout((Layout)layout);
        Section section = toolkit.createSection(container, 256);
        section.setText("Source");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gridData);
        this.scriptEditor = new ScriptEditor((Composite)section, 2048, 768, 0);
        section.setClient((Control)this.scriptEditor);
        this.scriptEditor.setText("");
        this.scriptEditor.getTextWidget().addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ScriptExecutor.this.onTextModify();
            }
        });
        container = toolkit.createComposite((Composite)splitter);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginTop = 4;
        container.setLayout((Layout)layout);
        section = toolkit.createSection(container, 256);
        section.setText("Output");
        gridData = new GridData();
        gridData.horizontalAlignment = 4;
        gridData.grabExcessHorizontalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.grabExcessVerticalSpace = true;
        section.setLayoutData((Object)gridData);
        this.output = new TextConsole((Composite)section, 2048);
        section.setClient((Control)this.output);
        this.activateContext();
        this.createActions();
        this.contributeToActionBars();
        this.actionSave.setEnabled(false);
    }

    private void activateContext() {
        IContextService contextService = (IContextService)this.getSite().getService(IContextService.class);
        if (contextService != null) {
            contextService.activateContext("org.netxms.ui.eclipse.nxsl.context.ScriptExecutor");
        }
    }

    private void onTextModify() {
        if (!this.modified) {
            this.modified = true;
            this.firePropertyChange(257);
            if (this.scriptCombo.getSelectionIndex() != -1) {
                this.actionSave.setEnabled(true);
            }
        }
    }

    public void setFocus() {
        this.scriptEditor.setFocus();
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionSave = new Action("Save", SharedIcons.SAVE){

            public void run() {
                ScriptExecutor.this.intermidiateSave(false);
            }
        };
        this.actionSave.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.save");
        handlerService.activateHandler(this.actionSave.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSave));
        this.actionSaveAs = new Action("Save as...", SharedIcons.SAVE_AS){

            public void run() {
                ScriptExecutor.this.createNewScript(false);
            }
        };
        this.actionSaveAs.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.save_as");
        handlerService.activateHandler(this.actionSaveAs.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionSaveAs));
        this.actionClear = new Action("Clear source", SharedIcons.CLEAR){

            public void run() {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(false)) {
                    return;
                }
                ScriptExecutor.this.scriptCombo.deselectAll();
                ScriptExecutor.this.scriptCombo.clearSelection();
                ScriptExecutor.this.scriptEditor.setText("");
                ScriptExecutor.this.output.clear();
                ScriptExecutor.this.form.setText("noname");
            }
        };
        this.actionClearOutput = new Action("Clear output", SharedIcons.CLEAR_LOG){

            public void run() {
                ScriptExecutor.this.output.clear();
            }
        };
        this.actionClearOutput.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.clear_output");
        handlerService.activateHandler(this.actionClearOutput.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionClearOutput));
        this.actionReload = new RefreshAction((IViewPart)this){

            public void run() {
                if (ScriptExecutor.this.modified && ScriptExecutor.this.saveIfRequired(false)) {
                    return;
                }
                ScriptExecutor.this.updateScriptList(null);
                ScriptExecutor.this.getScriptContent();
                ScriptExecutor.this.output.clear();
            }
        };
        this.actionReload.setText("Reload script");
        this.actionExecute = new Action("Execute", SharedIcons.EXECUTE){

            public void run() {
                ScriptExecutor.this.executeScript();
            }
        };
        this.actionExecute.setActionDefinitionId("org.netxms.ui.eclipse.nxsl.commands.execute_script");
        handlerService.activateHandler(this.actionExecute.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionExecute));
    }

    private boolean saveIfRequired(boolean onSelectionChange) {
        SaveScriptDialog dlg = new SaveScriptDialog(this.getSite().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        switch (rc) {
            case 100: {
                this.intermidiateSave(onSelectionChange);
                break;
            }
            case 101: {
                this.createNewScript(onSelectionChange);
                break;
            }
            case 102: {
                this.getScriptContent();
                this.clearDirtyFlags();
                break;
            }
            default: {
                this.scriptCombo.select(this.previousSelection);
            }
        }
        return rc == 1;
    }

    private void createNewScript(final boolean saveOnSelectionChange) {
        final CreateScriptDialog dlg = new CreateScriptDialog(this.getSite().getShell(), null);
        if (dlg.open() == 0) {
            new ConsoleJob("Create new script", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

                protected void runInternal(IProgressMonitor monitor) throws Exception {
                    ScriptExecutor.this.scriptLibraryManager.modifyScript(0L, dlg.getName(), ScriptExecutor.this.scriptEditor.getText());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            Runnable run = new Runnable(){

                                @Override
                                public void run() {
                                    ScriptExecutor.this.scriptCombo.select(ScriptExecutor.this.scriptCombo.indexOf(dlg.getName()));
                                    System.out.println("Trying to set newly created item");
                                }
                            };
                            ScriptExecutor.this.updateScriptList(saveOnSelectionChange ? null : run);
                            ScriptExecutor.this.clearDirtyFlags();
                        }
                    });
                }

                protected String getErrorMessage() {
                    return "Error modifying script";
                }
            }.start();
        }
    }

    protected void getScriptContent() {
        final int index = this.scriptCombo.getSelectionIndex();
        if (index == -1) {
            return;
        }
        new ConsoleJob("Update script content", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final Script script = ScriptExecutor.this.session.getScript(((Script)ScriptExecutor.this.library.get(index)).getId());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.scriptEditor.setText(script.getSource());
                        ScriptExecutor.this.clearDirtyFlags();
                        ScriptExecutor.this.form.setText(script.getName());
                    }
                });
            }

            protected String getErrorMessage() {
                return "Not possible to get script content";
            }
        }.start();
    }

    protected void executeScript() {
        final String script = this.scriptEditor.getText();
        this.consoleOutputStream = this.output.newOutputStream();
        this.actionExecute.setEnabled(false);
        new ConsoleJob("Execute script", null, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.session.executeScript(ScriptExecutor.this.objectId, script, (TextOutputListener)ScriptExecutor.this);
            }

            protected String getErrorMessage() {
                return "Error executing script";
            }

            protected void jobFinalize() {
                try {
                    ScriptExecutor.this.consoleOutputStream.close();
                    ScriptExecutor.this.consoleOutputStream = null;
                }
                catch (IOException iOException) {}
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.actionExecute.setEnabled(true);
                    }
                });
            }
        }.start();
    }

    private void updateScriptList(final Runnable postProcessor) {
        final String selection = this.scriptCombo.getSelectionIndex() != -1 ? this.scriptCombo.getItem(this.scriptCombo.getSelectionIndex()) : null;
        new ConsoleJob("Update script list", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.library = ScriptExecutor.this.scriptLibraryManager.getScriptLibrary();
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.scriptCombo.removeAll();
                        for (Script s : ScriptExecutor.this.library) {
                            ScriptExecutor.this.scriptCombo.add(s.getName());
                        }
                        if (postProcessor != null) {
                            postProcessor.run();
                        } else if (selection != null) {
                            ScriptExecutor.this.scriptCombo.select(ScriptExecutor.this.scriptCombo.indexOf(selection));
                        }
                    }
                });
            }

            protected String getErrorMessage() {
                return "Not possible to get script list";
            }
        }.start();
    }

    public void intermidiateSave(boolean saveOnSelectionChange) {
        final Script s = this.library.get(saveOnSelectionChange ? this.previousSelection : this.scriptCombo.getSelectionIndex());
        new ConsoleJob("Update script", (IWorkbenchPart)this, "org.netxms.ui.eclipse.nxsl", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                ScriptExecutor.this.scriptLibraryManager.modifyScript(s.getId(), s.getName(), ScriptExecutor.this.scriptEditor.getText());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        ScriptExecutor.this.clearDirtyFlags();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Not possible to save script";
            }
        }.start();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void clearDirtyFlags() {
        this.modified = false;
        this.firePropertyChange(257);
        this.actionSave.setEnabled(false);
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionReload);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionExecute);
        manager.add((IAction)this.actionClearOutput);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionSave);
        manager.add((IAction)this.actionSaveAs);
        manager.add((IAction)this.actionClear);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionReload);
    }

    public void doSave(IProgressMonitor monitor) {
        try {
            Script s = this.library.get(this.scriptCombo.getSelectionIndex());
            this.scriptLibraryManager.modifyScript(s.getId(), s.getName(), this.scriptEditor.getText());
        }
        catch (Exception e) {
            MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error", (String)("Error while saving script: " + e.getMessage()));
        }
        this.clearDirtyFlags();
    }

    public void doSaveAs() {
        this.createNewScript(false);
    }

    public boolean isDirty() {
        return this.modified;
    }

    public boolean isSaveAsAllowed() {
        return this.allowSaveAs;
    }

    public boolean isSaveOnCloseNeeded() {
        return this.modified;
    }

    public int promptToSaveOnClose() {
        SaveScriptDialog dlg = new SaveScriptDialog(this.getSite().getShell(), this.actionSave.isEnabled());
        int rc = dlg.open();
        this.modified = rc != 100;
        boolean bl = this.allowSaveAs = rc == 101;
        return rc == 1 ? 2 : (rc == 102 ? 1 : 0);
    }

    public void messageReceived(String text) {
        if (this.consoleOutputStream != null) {
            try {
                this.consoleOutputStream.write(text);
            }
            catch (IOException iOException) {}
        }
    }
}

