/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.perfview.views;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.datacollection.DciData;
import org.netxms.client.datacollection.DciDataRow;
import org.netxms.client.datacollection.GraphItem;
import org.netxms.client.datacollection.Threshold;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.charts.api.ChartFactory;
import org.netxms.ui.eclipse.charts.api.DataComparisonChart;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.perfview.Activator;
import org.netxms.ui.eclipse.perfview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class DataComparisonView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.perfview.views.DataComparisionView";
    private static final String KEY_CHART_TYPE = "chartType";
    private static final String KEY_AUTO_REFRESH = "autoRefresh";
    private static final String KEY_REFRESH_INTERVAL = "refreshInterval";
    private static final String KEY_LOG_SCALE = "logScale";
    private static final String KEY_3D_VIEW = "enable3DView";
    private static final String KEY_TRANSPOSED = "isTransposed";
    private static final String KEY_TRANSLUCENT = "isTRanslucent";
    private static final String KEY_SHOW_LEGEND = "showLegend";
    private static final String KEY_LEGEND_POSITION = "legendPosition";
    private DataComparisonChart chart;
    protected NXCSession session;
    private boolean updateInProgress = false;
    protected ArrayList<GraphItem> items = new ArrayList(8);
    private Runnable refreshTimer;
    private boolean autoRefreshEnabled = true;
    private boolean useLogScale = false;
    private boolean showIn3D = true;
    private int autoRefreshInterval = 30000;
    private int chartType = 0;
    private boolean transposed = false;
    private boolean showLegend = true;
    private int legendPosition = 2;
    private boolean translucent = false;
    private Image[] titleImages = new Image[5];
    private RefreshAction actionRefresh;
    private Action actionAutoRefresh;
    private Action actionShowBarChart;
    private Action actionShowTubeChart;
    private Action actionShowPieChart;
    private Action actionShowIn3D;
    private Action actionShowTranslucent;
    private Action actionUseLogScale;
    private Action actionHorizontal;
    private Action actionVertical;
    private Action actionShowLegend;
    private Action actionLegendLeft;
    private Action actionLegendRight;
    private Action actionLegendTop;
    private Action actionLegendBottom;
    private Action actionCopyImage;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.titleImages[0] = Activator.getImageDescriptor("icons/chart_bar.png").createImage();
        this.titleImages[1] = Activator.getImageDescriptor("icons/chart_pie.png").createImage();
        this.titleImages[2] = Activator.getImageDescriptor("icons/graph.png").createImage();
        this.titleImages[3] = Activator.getImageDescriptor("icons/chart_tube.png").createImage();
        this.titleImages[4] = Activator.getImageDescriptor("icons/chart_dial.png").createImage();
        String id = site.getSecondaryId();
        String[] fields = id.split("&");
        if (!fields[0].equals("org.netxms.ui.eclipse.charts.predefinedGraph")) {
            try {
                this.chartType = Integer.parseInt(fields[1]);
            }
            catch (NumberFormatException numberFormatException) {
                this.chartType = 0;
            }
            int i = 2;
            while (i < fields.length) {
                String[] subfields = fields[i].split("\\@");
                if (subfields.length == 6) {
                    try {
                        this.items.add(new GraphItem(Long.parseLong(subfields[0], 10), Long.parseLong(subfields[1], 10), Integer.parseInt(subfields[2], 10), Integer.parseInt(subfields[3], 10), URLDecoder.decode(subfields[4], "UTF-8"), URLDecoder.decode(subfields[5], "UTF-8")));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                } else if (subfields.length == 8) {
                    try {
                        this.items.add(new GraphItem(Long.parseLong(subfields[0], 10), Long.parseLong(subfields[1], 10), Integer.parseInt(subfields[2], 10), Integer.parseInt(subfields[3], 10), URLDecoder.decode(subfields[4], "UTF-8"), URLDecoder.decode(subfields[5], "UTF-8"), URLDecoder.decode(subfields[6], "UTF-8"), URLDecoder.decode(subfields[7], "UTF-8")));
                    }
                    catch (NumberFormatException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedEncodingException e) {
                        e.printStackTrace();
                    }
                }
                ++i;
            }
        }
        try {
            this.setTitleImage(this.titleImages[this.chartType]);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        this.init(site);
        if (memento != null) {
            this.chartType = DataComparisonView.safeCast(memento.getInteger(KEY_CHART_TYPE), this.chartType);
            this.autoRefreshEnabled = DataComparisonView.safeCast(memento.getBoolean(KEY_AUTO_REFRESH), this.autoRefreshEnabled);
            this.autoRefreshInterval = DataComparisonView.safeCast(memento.getInteger(KEY_REFRESH_INTERVAL), this.autoRefreshInterval);
            this.translucent = DataComparisonView.safeCast(memento.getBoolean(KEY_TRANSLUCENT), this.translucent);
            this.transposed = DataComparisonView.safeCast(memento.getBoolean(KEY_TRANSPOSED), this.transposed);
            this.showLegend = DataComparisonView.safeCast(memento.getBoolean(KEY_SHOW_LEGEND), this.showLegend);
            this.legendPosition = DataComparisonView.safeCast(memento.getInteger(KEY_LEGEND_POSITION), this.legendPosition);
            this.useLogScale = DataComparisonView.safeCast(memento.getBoolean(KEY_LOG_SCALE), this.useLogScale);
            this.showIn3D = DataComparisonView.safeCast(memento.getBoolean(KEY_3D_VIEW), this.showIn3D);
            try {
                this.setTitleImage(this.titleImages[this.chartType]);
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        }
    }

    private static int safeCast(Integer i, int defval) {
        return i != null ? i : defval;
    }

    private static boolean safeCast(Boolean b, boolean defval) {
        return b != null ? b : defval;
    }

    public void saveState(IMemento memento) {
        memento.putInteger(KEY_CHART_TYPE, this.chartType);
        memento.putBoolean(KEY_AUTO_REFRESH, this.autoRefreshEnabled);
        memento.putInteger(KEY_REFRESH_INTERVAL, this.autoRefreshInterval);
        memento.putBoolean(KEY_TRANSLUCENT, this.translucent);
        memento.putBoolean(KEY_TRANSPOSED, this.transposed);
        memento.putBoolean(KEY_SHOW_LEGEND, this.showLegend);
        memento.putInteger(KEY_LEGEND_POSITION, this.legendPosition);
        memento.putBoolean(KEY_LOG_SCALE, this.useLogScale);
        memento.putBoolean(KEY_3D_VIEW, this.showIn3D);
    }

    public void createPartControl(Composite parent) {
        switch (this.chartType) {
            case 0: {
                this.chart = ChartFactory.createBarChart((Composite)parent, (int)0);
                break;
            }
            case 3: {
                this.chart = ChartFactory.createTubeChart((Composite)parent, (int)0);
                break;
            }
            case 1: {
                this.chart = ChartFactory.createPieChart((Composite)parent, (int)0);
            }
        }
        this.chart.setLegendPosition(this.legendPosition);
        this.chart.setLegendVisible(this.showLegend);
        this.chart.set3DModeEnabled(this.showIn3D);
        this.chart.setTransposed(this.transposed);
        this.chart.setTranslucent(this.translucent);
        for (GraphItem item : this.items) {
            this.chart.addParameter(item, 0.0);
        }
        this.chart.initializationComplete();
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.updateChart();
        final Display display = this.getSite().getShell().getDisplay();
        this.refreshTimer = new Runnable(){

            @Override
            public void run() {
                if (((Widget)DataComparisonView.this.chart).isDisposed()) {
                    return;
                }
                DataComparisonView.this.updateChart();
                if (DataComparisonView.this.autoRefreshEnabled) {
                    display.timerExec(DataComparisonView.this.autoRefreshInterval, (Runnable)this);
                }
            }
        };
        if (this.autoRefreshEnabled) {
            display.timerExec(this.autoRefreshInterval, this.refreshTimer);
        }
    }

    public void setFocus() {
        ((Composite)this.chart).setFocus();
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                DataComparisonView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.chart);
        ((Control)this.chart).setMenu(menu);
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction((IViewPart)this){

            public void run() {
                DataComparisonView.this.updateChart();
            }
        };
        Messages.get();
        this.actionAutoRefresh = new Action(Messages.DataComparisonView_AutoRefresh){

            public void run() {
                DataComparisonView.this.autoRefreshEnabled = !DataComparisonView.this.autoRefreshEnabled;
                this.setChecked(DataComparisonView.this.autoRefreshEnabled);
                DataComparisonView.this.getSite().getShell().getDisplay().timerExec(DataComparisonView.this.autoRefreshEnabled ? DataComparisonView.this.autoRefreshInterval : -1, DataComparisonView.this.refreshTimer);
            }
        };
        this.actionAutoRefresh.setChecked(this.autoRefreshEnabled);
        Messages.get();
        this.actionUseLogScale = new Action(Messages.DataComparisonView_LogScale){

            public void run() {
                DataComparisonView.this.useLogScale = !DataComparisonView.this.useLogScale;
                this.setChecked(DataComparisonView.this.useLogScale);
                DataComparisonView.this.chart.setLogScaleEnabled(DataComparisonView.this.useLogScale);
            }
        };
        this.actionUseLogScale.setChecked(this.useLogScale);
        Messages.get();
        this.actionShowIn3D = new Action(Messages.DataComparisonView_3DView){

            public void run() {
                DataComparisonView.this.showIn3D = !DataComparisonView.this.showIn3D;
                this.setChecked(DataComparisonView.this.showIn3D);
                DataComparisonView.this.chart.set3DModeEnabled(DataComparisonView.this.showIn3D);
            }
        };
        this.actionShowIn3D.setChecked(this.showIn3D);
        Messages.get();
        this.actionShowTranslucent = new Action(Messages.DataComparisonView_Translucent){

            public void run() {
                DataComparisonView.this.translucent = !DataComparisonView.this.translucent;
                this.setChecked(DataComparisonView.this.translucent);
                DataComparisonView.this.chart.setTranslucent(DataComparisonView.this.translucent);
            }
        };
        this.actionShowTranslucent.setChecked(this.translucent);
        Messages.get();
        this.actionShowLegend = new Action(Messages.DataComparisonView_ShowLegend){

            public void run() {
                DataComparisonView.this.showLegend = !DataComparisonView.this.showLegend;
                this.setChecked(DataComparisonView.this.showLegend);
                DataComparisonView.this.chart.setLegendVisible(DataComparisonView.this.showLegend);
            }
        };
        this.actionShowLegend.setChecked(this.showLegend);
        Messages.get();
        this.actionLegendLeft = new Action(Messages.DataComparisonView_PlaceOnLeft, 8){

            public void run() {
                DataComparisonView.this.legendPosition = 1;
                DataComparisonView.this.chart.setLegendPosition(DataComparisonView.this.legendPosition);
            }
        };
        this.actionLegendLeft.setChecked(this.legendPosition == 1);
        Messages.get();
        this.actionLegendRight = new Action(Messages.DataComparisonView_PlaceOnRight, 8){

            public void run() {
                DataComparisonView.this.legendPosition = 2;
                DataComparisonView.this.chart.setLegendPosition(DataComparisonView.this.legendPosition);
            }
        };
        this.actionLegendRight.setChecked(this.legendPosition == 2);
        Messages.get();
        this.actionLegendTop = new Action(Messages.DataComparisonView_PlaceOnTop, 8){

            public void run() {
                DataComparisonView.this.legendPosition = 4;
                DataComparisonView.this.chart.setLegendPosition(DataComparisonView.this.legendPosition);
            }
        };
        this.actionLegendTop.setChecked(this.legendPosition == 1);
        Messages.get();
        this.actionLegendBottom = new Action(Messages.DataComparisonView_PlaceOnBottom, 8){

            public void run() {
                DataComparisonView.this.legendPosition = 8;
                DataComparisonView.this.chart.setLegendPosition(DataComparisonView.this.legendPosition);
            }
        };
        this.actionLegendBottom.setChecked(this.legendPosition == 1);
        Messages.get();
        this.actionShowBarChart = new Action(Messages.DataComparisonView_BarChart, 8){

            public void run() {
                DataComparisonView.this.setChartType(0);
            }
        };
        this.actionShowBarChart.setChecked(this.chart.getChartType() == 0);
        this.actionShowBarChart.setImageDescriptor(Activator.getImageDescriptor("icons/chart_bar.png"));
        Messages.get();
        this.actionShowTubeChart = new Action(Messages.DataComparisonView_TubeChart, 8){

            public void run() {
                DataComparisonView.this.setChartType(3);
            }
        };
        this.actionShowTubeChart.setChecked(this.chart.getChartType() == 3);
        this.actionShowTubeChart.setImageDescriptor(Activator.getImageDescriptor("icons/chart_tube.png"));
        Messages.get();
        this.actionShowPieChart = new Action(Messages.DataComparisonView_PieChart, 8){

            public void run() {
                DataComparisonView.this.setChartType(1);
            }
        };
        this.actionShowPieChart.setChecked(this.chart.getChartType() == 1);
        this.actionShowPieChart.setImageDescriptor(Activator.getImageDescriptor("icons/chart_pie.png"));
        Messages.get();
        this.actionHorizontal = new Action(Messages.DataComparisonView_ShowHorizontally, 8){

            public void run() {
                DataComparisonView.this.transposed = true;
                DataComparisonView.this.chart.setTransposed(true);
            }
        };
        this.actionHorizontal.setChecked(this.transposed);
        this.actionHorizontal.setEnabled(this.chart.hasAxes());
        this.actionHorizontal.setImageDescriptor(Activator.getImageDescriptor("icons/bar_horizontal.png"));
        Messages.get();
        this.actionVertical = new Action(Messages.DataComparisonView_ShowVertically, 8){

            public void run() {
                DataComparisonView.this.transposed = false;
                DataComparisonView.this.chart.setTransposed(false);
            }
        };
        this.actionVertical.setChecked(!this.transposed);
        this.actionVertical.setEnabled(this.chart.hasAxes());
        this.actionVertical.setImageDescriptor(Activator.getImageDescriptor("icons/bar_vertical.png"));
        this.actionCopyImage = new Action("Copy map image to clipboard", SharedIcons.COPY){

            public void run() {
                Image image = DataComparisonView.this.chart.takeSnapshot();
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(DataComparisonView.this.getSite().getShell().getDisplay());
                clipboard.setContents(new Object[]{image.getImageData()}, new Transfer[]{imageTransfer});
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        Messages.get();
        MenuManager legend = new MenuManager(Messages.DataComparisonView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowTubeChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionVertical);
        manager.add((IAction)this.actionHorizontal);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowIn3D);
        manager.add((IAction)this.actionShowTranslucent);
        manager.add((IAction)this.actionUseLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillContextMenu(IMenuManager manager) {
        Messages.get();
        MenuManager legend = new MenuManager(Messages.DataComparisonView_Legend);
        legend.add((IAction)this.actionShowLegend);
        legend.add((IContributionItem)new Separator());
        legend.add((IAction)this.actionLegendLeft);
        legend.add((IAction)this.actionLegendRight);
        legend.add((IAction)this.actionLegendTop);
        legend.add((IAction)this.actionLegendBottom);
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowTubeChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionVertical);
        manager.add((IAction)this.actionHorizontal);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionShowIn3D);
        manager.add((IAction)this.actionShowTranslucent);
        manager.add((IAction)this.actionUseLogScale);
        manager.add((IAction)this.actionAutoRefresh);
        manager.add((IContributionItem)legend);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionShowBarChart);
        manager.add((IAction)this.actionShowTubeChart);
        manager.add((IAction)this.actionShowPieChart);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionVertical);
        manager.add((IAction)this.actionHorizontal);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionCopyImage);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void setChartType(int newType) {
        this.chartType = newType;
        this.chart.setLabelsVisible(this.chartType == 1);
        this.chart.setChartType(newType);
        this.actionHorizontal.setEnabled(this.chart.hasAxes());
        this.actionVertical.setEnabled(this.chart.hasAxes());
        try {
            this.setTitleImage(this.titleImages[this.chartType]);
            this.firePropertyChange(1);
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
    }

    private void updateChart() {
        if (this.updateInProgress) {
            return;
        }
        this.updateInProgress = true;
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.DataComparisonView_JobName, (IWorkbenchPart)this, "org.netxms.ui.eclipse.perfview", "org.netxms.ui.eclipse.perfview"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.DataComparisonView_JobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final double[] values = new double[DataComparisonView.this.items.size()];
                int i = 0;
                while (i < DataComparisonView.this.items.size()) {
                    GraphItem item = DataComparisonView.this.items.get(i);
                    DciData data = item.getType() == 1 ? DataComparisonView.this.session.getCollectedData(item.getNodeId(), item.getDciId(), null, null, 1) : DataComparisonView.this.session.getCollectedTableData(item.getNodeId(), item.getDciId(), item.getInstance(), item.getDataColumn(), null, null, 1);
                    DciDataRow value = data.getLastValue();
                    values[i] = value != null ? value.getValueAsDouble() : 0.0;
                    ++i;
                }
                final Threshold[][] thresholds = new Threshold[DataComparisonView.this.items.size()][];
                if (DataComparisonView.this.chartType == 4) {
                    int i2 = 0;
                    while (i2 < DataComparisonView.this.items.size()) {
                        GraphItem item = DataComparisonView.this.items.get(i2);
                        thresholds[i2] = DataComparisonView.this.session.getThresholds(item.getNodeId(), item.getDciId());
                        ++i2;
                    }
                }
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        if (DataComparisonView.this.chartType == 4) {
                            int i = 0;
                            while (i < thresholds.length) {
                                DataComparisonView.this.chart.updateParameterThresholds(i, thresholds[i]);
                                ++i;
                            }
                        }
                        DataComparisonView.this.setChartData(values);
                        DataComparisonView.this.chart.clearErrors();
                        DataComparisonView.this.updateInProgress = false;
                    }
                });
            }

            protected IStatus createFailureStatus(final Exception e) {
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        DataComparisonView.this.chart.addError(String.valueOf(this.getErrorMessage()) + " (" + e.getLocalizedMessage() + ")");
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setUser(false);
        job.start();
    }

    private void setChartData(double[] values) {
        int i = 0;
        while (i < values.length) {
            this.chart.updateParameter(i, values[i], false);
            ++i;
        }
        this.chart.refresh();
    }

    public void dispose() {
        Image[] imageArray = this.titleImages;
        int n = this.titleImages.length;
        int n2 = 0;
        while (n2 < n) {
            Image i = imageArray[n2];
            if (i != null) {
                i.dispose();
            }
            ++n2;
        }
        super.dispose();
    }
}

