/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.objecttabs.helpers;

import org.eclipse.jface.viewers.ITableColorProvider;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.netxms.client.NXCSession;
import org.netxms.client.constants.ObjectStatus;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.Interface;
import org.netxms.ui.eclipse.console.resources.StatusDisplayInfo;
import org.netxms.ui.eclipse.objectview.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class InterfaceListLabelProvider
extends LabelProvider
implements ITableLabelProvider,
ITableColorProvider {
    private static final String[] ifaceExpectedState;
    private AbstractNode node = null;
    private NXCSession session = (NXCSession)ConsoleSharedData.getSession();

    static {
        String[] stringArray = new String[3];
        Messages.get();
        stringArray[0] = Messages.InterfaceListLabelProvider_StateUp;
        Messages.get();
        stringArray[1] = Messages.InterfaceListLabelProvider_StateDown;
        Messages.get();
        stringArray[2] = Messages.InterfaceListLabelProvider_StateIgnore;
        ifaceExpectedState = stringArray;
    }

    public Image getColumnImage(Object element, int columnIndex) {
        return null;
    }

    public String getColumnText(Object element, int columnIndex) {
        if (this.node == null) {
            return null;
        }
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 18: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xBackendStateAsText();
                }
                return null;
            }
            case 17: {
                if (this.node.is8021xSupported() && iface.isPhysicalPort()) {
                    return iface.getDot1xPaeStateAsText();
                }
                return null;
            }
            case 13: {
                return iface.getAdminStateAsText();
            }
            case 6: {
                return iface.getDescription();
            }
            case 15: {
                try {
                    return ifaceExpectedState[iface.getExpectedState()];
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    return null;
                }
            }
            case 0: {
                return Long.toString(iface.getObjectId());
            }
            case 3: {
                return Integer.toString(iface.getIfIndex());
            }
            case 1: {
                return iface.getObjectName();
            }
            case 14: {
                return iface.getOperStateAsText();
            }
            case 5: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getPort());
                }
                return null;
            }
            case 4: {
                if (iface.isPhysicalPort()) {
                    return Integer.toString(iface.getSlot());
                }
                return null;
            }
            case 16: {
                return StatusDisplayInfo.getStatusText((ObjectStatus)iface.getStatus());
            }
            case 2: {
                return Integer.toString(iface.getIfType());
            }
            case 7: {
                return iface.getMacAddress().toString();
            }
            case 8: {
                return iface.getPrimaryIP().isAnyLocalAddress() ? null : String.valueOf(iface.getPrimaryIP().getHostAddress()) + "/" + iface.getSubnetMaskBits();
            }
            case 9: {
                return this.getPeerName(iface);
            }
            case 10: {
                return this.getPeerMacAddress(iface);
            }
            case 11: {
                return this.getPeerIpAddress(iface);
            }
            case 12: {
                return this.getPeerProtocol(iface);
            }
        }
        return null;
    }

    private String getPeerIpAddress(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        if (peer == null) {
            return null;
        }
        if (peer.getPrimaryIP().isAnyLocalAddress()) {
            return null;
        }
        return peer.getPrimaryIP().getHostAddress();
    }

    private String getPeerMacAddress(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? peer.getMacAddress().toString() : null;
    }

    private String getPeerProtocol(Interface iface) {
        Interface peer = (Interface)this.session.findObjectById(iface.getPeerInterfaceId(), Interface.class);
        return peer != null ? iface.getPeerDiscoveryProtocol().toString() : null;
    }

    private String getPeerName(Interface iface) {
        AbstractNode peer = (AbstractNode)this.session.findObjectById(iface.getPeerNodeId(), AbstractNode.class);
        return peer != null ? peer.getObjectName() : null;
    }

    public void setNode(AbstractNode node) {
        this.node = node;
    }

    public Color getForeground(Object element, int columnIndex) {
        Interface iface = (Interface)element;
        switch (columnIndex) {
            case 16: {
                return StatusDisplayInfo.getStatusColor((ObjectStatus)iface.getStatus());
            }
            case 14: {
                switch (iface.getOperState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)(iface.getAdminState() == 2 ? ObjectStatus.DISABLED : ObjectStatus.CRITICAL));
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
            case 13: {
                switch (iface.getAdminState()) {
                    case 1: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.NORMAL);
                    }
                    case 2: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.DISABLED);
                    }
                    case 3: {
                        return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.TESTING);
                    }
                }
                return StatusDisplayInfo.getStatusColor((ObjectStatus)ObjectStatus.UNKNOWN);
            }
        }
        return null;
    }

    public Color getBackground(Object element, int columnIndex) {
        return null;
    }
}

