/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectview.widgets;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.window.IShellProvider;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.dialogs.PropertyDialogAction;
import org.netxms.api.client.SessionListener;
import org.netxms.api.client.SessionNotification;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractNode;
import org.netxms.client.objects.AbstractObject;
import org.netxms.client.objects.Cluster;
import org.netxms.client.objects.Container;
import org.netxms.client.objects.ServiceRoot;
import org.netxms.ui.eclipse.console.resources.SharedColors;
import org.netxms.ui.eclipse.objectview.api.ObjectDetailsProvider;
import org.netxms.ui.eclipse.objectview.widgets.NodeStatusWidget;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class ObjectStatusMap
extends ScrolledComposite
implements ISelectionProvider {
    private IViewPart viewPart;
    private long rootObjectId;
    private NXCSession session;
    private Composite dataArea;
    private List<Composite> sections = new ArrayList<Composite>();
    private Map<Long, NodeStatusWidget> nodes = new HashMap<Long, NodeStatusWidget>();
    private ISelection selection = null;
    private Set<ISelectionChangedListener> selectionListeners = new HashSet<ISelectionChangedListener>();
    private MenuManager menuManager;
    private Font titleFont;
    private boolean groupObjects = true;
    private int severityFilter = 255;
    private SortedMap<Integer, ObjectDetailsProvider> detailsProviders = new TreeMap<Integer, ObjectDetailsProvider>();

    public ObjectStatusMap(IViewPart viewPart, Composite parent, int style) {
        super(parent, style | 0x200);
        this.initDetailsProviders();
        this.viewPart = viewPart;
        this.session = (NXCSession)ConsoleSharedData.getSession();
        final SessionListener sessionListener = new SessionListener(){

            public void notificationHandler(SessionNotification n) {
                if (n.getCode() == 4) {
                    ObjectStatusMap.this.onObjectChange((AbstractObject)n.getObject());
                } else if (n.getCode() == 99) {
                    ObjectStatusMap.this.onObjectDelete(n.getSubCode());
                }
            }
        };
        this.session.addListener(sessionListener);
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                ObjectStatusMap.this.session.removeListener(sessionListener);
            }
        });
        this.setBackground(SharedColors.getColor((String)"ObjectTab.Background", (Display)this.getDisplay()));
        this.setExpandHorizontal(true);
        this.setExpandVertical(true);
        this.addControlListener((ControlListener)new ControlAdapter(){

            public void controlResized(ControlEvent e) {
                Rectangle r = ObjectStatusMap.this.getClientArea();
                ObjectStatusMap.this.setMinSize(ObjectStatusMap.this.dataArea.computeSize(r.width, -1));
            }
        });
        this.getVerticalBar().setIncrement(30);
        this.dataArea = new Composite((Composite)this, 0);
        this.setContent((Control)this.dataArea);
        GridLayout layout = new GridLayout();
        layout.verticalSpacing = 10;
        this.dataArea.setLayout((Layout)layout);
        this.dataArea.setBackground(this.getBackground());
        if (Platform.getOS().equals("win32")) {
            this.titleFont = new Font((Device)parent.getDisplay(), "Verdana", 10, 1);
            this.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    ObjectStatusMap.this.titleFont.dispose();
                }
            });
        } else {
            this.titleFont = JFaceResources.getFontRegistry().getBold("org.eclipse.jface.bannerfont");
        }
        this.menuManager = new MenuManager();
        this.menuManager.setRemoveAllWhenShown(true);
        this.menuManager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ObjectStatusMap.this.fillContextMenu(manager);
            }
        });
    }

    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IContributionItem)new GroupMarker("objectcreation"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectmgmt"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("objectbinding"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("additions"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("topology"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("datacollection"));
        manager.add((IContributionItem)new Separator());
        manager.add((IContributionItem)new GroupMarker("properties"));
        if (this.viewPart != null) {
            manager.add((IAction)new PropertyDialogAction((IShellProvider)this.viewPart.getSite(), (ISelectionProvider)this));
        }
    }

    public void setRootObject(long objectId) {
        this.rootObjectId = objectId;
        this.refresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh() {
        Object s2;
        for (Object s2 : this.sections) {
            s2.dispose();
        }
        this.sections.clear();
        s2 = this.nodes;
        synchronized (s2) {
            this.nodes.clear();
        }
        if (this.groupObjects) {
            this.buildSection(this.rootObjectId, "");
        } else {
            this.buildFlatView();
        }
        this.dataArea.layout(true, true);
        Rectangle r = this.getClientArea();
        this.setMinSize(this.dataArea.computeSize(r.width, -1));
    }

    private void buildFlatView() {
        AbstractObject root = this.session.findObjectById(this.rootObjectId);
        if (root == null || !(root instanceof Container) && !(root instanceof ServiceRoot)) {
            return;
        }
        ArrayList objects = new ArrayList(root.getAllChilds(2));
        if ((this.severityFilter & 0x1F) != 31) {
            Iterator it = objects.iterator();
            while (it.hasNext()) {
                AbstractObject o = (AbstractObject)it.next();
                if ((1 << o.getStatus().getValue() & this.severityFilter) != 0) continue;
                it.remove();
            }
        }
        Collections.sort(objects, new Comparator<AbstractObject>(){

            @Override
            public int compare(AbstractObject o1, AbstractObject o2) {
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        Composite clientArea = new Composite(this.dataArea, 0);
        clientArea.setBackground(this.getBackground());
        GridData gd = new GridData();
        gd.grabExcessHorizontalSpace = true;
        gd.horizontalAlignment = 4;
        clientArea.setLayoutData((Object)gd);
        RowLayout clayout = new RowLayout();
        clayout.marginBottom = 0;
        clayout.marginTop = 0;
        clayout.marginLeft = 0;
        clayout.marginRight = 0;
        clayout.type = 256;
        clayout.wrap = true;
        clayout.pack = false;
        clientArea.setLayout((Layout)clayout);
        this.sections.add(clientArea);
        for (AbstractObject o : objects) {
            if (!(o instanceof AbstractNode)) continue;
            this.addNodeElement(clientArea, (AbstractNode)o);
        }
    }

    private void buildSection(long rootId, String namePrefix) {
        AbstractObject root = this.session.findObjectById(rootId);
        if (root == null || !(root instanceof Container) && !(root instanceof ServiceRoot)) {
            return;
        }
        ArrayList<AbstractObject> objects = new ArrayList<AbstractObject>(Arrays.asList(root.getChildsAsArray()));
        Collections.sort(objects, new Comparator<AbstractObject>(){

            @Override
            public int compare(AbstractObject o1, AbstractObject o2) {
                return o1.getObjectName().compareToIgnoreCase(o2.getObjectName());
            }
        });
        Composite section = null;
        Composite clientArea = null;
        for (AbstractObject o : objects) {
            if (!(o instanceof AbstractNode) || (1 << o.getStatus().getValue() & this.severityFilter) == 0) continue;
            if (section == null) {
                section = new Composite(this.dataArea, 0);
                section.setBackground(this.getBackground());
                GridData gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                section.setLayoutData((Object)gd);
                GridLayout layout = new GridLayout();
                layout.marginHeight = 0;
                layout.marginWidth = 0;
                section.setLayout((Layout)layout);
                Label title = new Label(section, 0);
                title.setBackground(this.getBackground());
                title.setFont(this.titleFont);
                title.setText(String.valueOf(namePrefix) + root.getObjectName());
                clientArea = new Composite(section, 0);
                clientArea.setBackground(this.getBackground());
                gd = new GridData();
                gd.grabExcessHorizontalSpace = true;
                gd.horizontalAlignment = 4;
                clientArea.setLayoutData((Object)gd);
                RowLayout clayout = new RowLayout();
                clayout.marginBottom = 0;
                clayout.marginTop = 0;
                clayout.marginLeft = 0;
                clayout.marginRight = 0;
                clayout.type = 256;
                clayout.wrap = true;
                clayout.pack = false;
                clientArea.setLayout((Layout)clayout);
                this.sections.add(section);
            }
            this.addNodeElement(clientArea, (AbstractNode)o);
        }
        for (AbstractObject o : objects) {
            if (!(o instanceof Container) && !(o instanceof ServiceRoot)) continue;
            this.buildSection(o.getObjectId(), String.valueOf(namePrefix) + root.getObjectName() + " / ");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNodeElement(Composite parent, final AbstractNode node) {
        NodeStatusWidget w = new NodeStatusWidget(parent, node);
        w.setBackground(this.getBackground());
        w.addMouseListener(new MouseListener(){

            public void mouseUp(MouseEvent e) {
            }

            public void mouseDown(MouseEvent e) {
                ObjectStatusMap.this.setSelection((ISelection)new StructuredSelection((Object)node));
                if (e.button == 1) {
                    ObjectStatusMap.this.callDetailsProvider(node);
                }
            }

            public void mouseDoubleClick(MouseEvent e) {
            }
        });
        Menu menu = this.menuManager.createContextMenu((Control)w);
        w.setMenu(menu);
        if (this.viewPart != null) {
            this.viewPart.getSite().registerContextMenu(this.menuManager, (ISelectionProvider)this);
        }
        Map<Long, NodeStatusWidget> map = this.nodes;
        synchronized (map) {
            this.nodes.put(node.getObjectId(), w);
        }
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionListeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        for (ISelectionChangedListener l : this.selectionListeners) {
            l.selectionChanged(event);
        }
    }

    public boolean isGroupObjects() {
        return this.groupObjects;
    }

    public void setGroupObjects(boolean groupObjects) {
        this.groupObjects = groupObjects;
    }

    private void initDetailsProviders() {
        IExtensionRegistry reg = Platform.getExtensionRegistry();
        IConfigurationElement[] elements = reg.getConfigurationElementsFor("org.netxms.ui.eclipse.objectview.objectDetailsProvider");
        int i = 0;
        while (i < elements.length) {
            try {
                int priority;
                ObjectDetailsProvider provider = (ObjectDetailsProvider)elements[i].createExecutableExtension("class");
                try {
                    priority = Integer.parseInt(elements[i].getAttribute("priority"));
                }
                catch (NumberFormatException numberFormatException) {
                    priority = 65535;
                }
                this.detailsProviders.put(priority, provider);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++i;
        }
    }

    private void callDetailsProvider(AbstractNode node) {
        for (ObjectDetailsProvider p : this.detailsProviders.values()) {
            if (!p.canProvideDetails((AbstractObject)node)) continue;
            p.provideDetails((AbstractObject)node, this.viewPart);
            break;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectChange(final AbstractObject object) {
        if (!(object instanceof AbstractNode || object instanceof Container || object instanceof Cluster || object instanceof ServiceRoot)) {
            return;
        }
        Map<Long, NodeStatusWidget> map = this.nodes;
        synchronized (map) {
            final NodeStatusWidget w = this.nodes.get(object.getObjectId());
            if (w != null) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!w.isDisposed()) {
                            w.updateObject((AbstractNode)object);
                        }
                    }
                });
            } else if (object.getObjectId() == this.rootObjectId || object.isChildOf(this.rootObjectId)) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ObjectStatusMap.this.isDisposed()) {
                            ObjectStatusMap.this.refresh();
                        }
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onObjectDelete(long objectId) {
        Map<Long, NodeStatusWidget> map = this.nodes;
        synchronized (map) {
            if (this.nodes.containsKey(objectId)) {
                this.getDisplay().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (!ObjectStatusMap.this.isDisposed()) {
                            ObjectStatusMap.this.refresh();
                        }
                    }
                });
            }
        }
    }

    public int getSeverityFilter() {
        return this.severityFilter;
    }

    public void setSeverityFilter(int severityFilter) {
        this.severityFilter = severityFilter;
    }
}

