/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.filemanager.views;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.List;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.LocalSelectionTransfer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.viewers.ViewerDropAdapter;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.handlers.IHandlerService;
import org.eclipse.ui.part.ViewPart;
import org.netxms.api.client.ProgressListener;
import org.netxms.client.AgentFile;
import org.netxms.client.NXCSession;
import org.netxms.client.ServerFile;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.filemanager.Activator;
import org.netxms.ui.eclipse.filemanager.Messages;
import org.netxms.ui.eclipse.filemanager.dialogs.RenameFileDialog;
import org.netxms.ui.eclipse.filemanager.dialogs.StartClientToServerFileUploadDialog;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileComparator;
import org.netxms.ui.eclipse.filemanager.views.helpers.AgentFileFilter;
import org.netxms.ui.eclipse.filemanager.views.helpers.ServerFileLabelProvider;
import org.netxms.ui.eclipse.filemanager.views.helpers.ViewAgentFilesProvider;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.views.FileViewer;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;
import org.netxms.ui.eclipse.tools.WidgetHelper;
import org.netxms.ui.eclipse.widgets.FilterText;
import org.netxms.ui.eclipse.widgets.SortableTreeViewer;

public class AgentFileManager
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.filemanager.views.AgentFileManager";
    private static final String TABLE_CONFIG_PREFIX = "AgentFileManager";
    public static final int COLUMN_NAME = 0;
    public static final int COLUMN_TYPE = 1;
    public static final int COLUMN_SIZE = 2;
    public static final int COLUMN_MODIFYED = 3;
    private boolean filterEnabled = false;
    private Composite content;
    private ServerFile[] files;
    private AgentFileFilter filter;
    private FilterText filterText;
    private SortableTreeViewer viewer;
    private NXCSession session;
    private Action actionRefreshAll;
    private Action actionUpload;
    private Action actionDelete;
    private Action actionRename;
    private Action actionRefreshDirectory;
    private Action actionShowFilter;
    private Action actionDownloadFile;
    private Action actionTailFile;
    private long objectId = 0L;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.objectId = Long.parseLong(site.getSecondaryId());
        this.setPartName(String.format("File Manager - %s", this.session.getObjectName(this.objectId)));
    }

    public void createPartControl(Composite parent) {
        this.content = new Composite(parent, 0);
        this.content.setLayout((Layout)new FormLayout());
        this.filterText = new FilterText(this.content, 0);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AgentFileManager.this.onFilterModify();
            }
        });
        this.filterText.setCloseAction(new Action(){

            public void run() {
                AgentFileManager.this.enableFilter(false);
            }
        });
        String[] columnNames = new String[]{"Name", "Type", "Size", "Date modified"};
        int[] columnWidths = new int[]{300, 120, 150, 150};
        this.viewer = new SortableTreeViewer(this.content, columnNames, columnWidths, 0, 128, -1);
        WidgetHelper.restoreTreeViewerSettings((SortableTreeViewer)this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)TABLE_CONFIG_PREFIX);
        this.viewer.setContentProvider((IContentProvider)new ViewAgentFilesProvider());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerFileLabelProvider());
        this.viewer.setComparator((ViewerComparator)new AgentFileComparator());
        this.filter = new AgentFileFilter();
        this.viewer.addFilter((ViewerFilter)this.filter);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                if (selection != null) {
                    AgentFileManager.this.actionDelete.setEnabled(selection.size() > 0);
                }
            }
        });
        this.viewer.getTree().addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                WidgetHelper.saveTreeViewerSettings((SortableTreeViewer)AgentFileManager.this.viewer, (IDialogSettings)Activator.getDefault().getDialogSettings(), (String)AgentFileManager.TABLE_CONFIG_PREFIX);
            }
        });
        this.enableDragSupport();
        this.enableDropSupport();
        FormData fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment((Control)this.filterText);
        fd.right = new FormAttachment(100, 0);
        fd.bottom = new FormAttachment(100, 0);
        this.viewer.getTree().setLayoutData((Object)fd);
        fd = new FormData();
        fd.left = new FormAttachment(0, 0);
        fd.top = new FormAttachment(0, 0);
        fd.right = new FormAttachment(100, 0);
        this.filterText.setLayoutData((Object)fd);
        this.createActions();
        this.contributeToActionBars();
        this.createPopupMenu();
        this.filterText.setCloseAction(this.actionShowFilter);
        if (this.filterEnabled) {
            this.filterText.setFocus();
        } else {
            this.enableFilter(false);
        }
        this.refreshFileList();
    }

    public void enableDragSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDragSupport(3, transfers, (DragSourceListener)new DragSourceAdapter(){

            public void dragStart(DragSourceEvent event) {
                LocalSelectionTransfer.getTransfer().setSelection(AgentFileManager.this.viewer.getSelection());
                event.doit = true;
            }

            public void dragSetData(DragSourceEvent event) {
                event.data = LocalSelectionTransfer.getTransfer().getSelection();
            }
        });
    }

    public void enableDropSupport() {
        Transfer[] transfers = new Transfer[]{LocalSelectionTransfer.getTransfer()};
        this.viewer.addDropSupport(3, transfers, (DropTargetListener)new ViewerDropAdapter((Viewer)this.viewer){

            public boolean performDrop(Object data) {
                IStructuredSelection selection = (IStructuredSelection)data;
                List movableSelection = selection.toList();
                int i = 0;
                while (i < movableSelection.size()) {
                    ServerFile movableObject = (ServerFile)movableSelection.get(i);
                    AgentFileManager.this.moveFile((ServerFile)this.getCurrentTarget(), movableObject);
                    ++i;
                }
                return true;
            }

            public boolean validateDrop(Object target, int operation, TransferData transferType) {
                if (target == null || !LocalSelectionTransfer.getTransfer().isSupportedType(transferType)) {
                    return false;
                }
                IStructuredSelection selection = (IStructuredSelection)LocalSelectionTransfer.getTransfer().getSelection();
                if (selection.isEmpty()) {
                    return false;
                }
                for (Object object : selection.toList()) {
                    if (object instanceof ServerFile) continue;
                    return false;
                }
                if (!(target instanceof ServerFile)) {
                    return false;
                }
                return ((ServerFile)target).isDirectory();
            }
        });
    }

    private void createActions() {
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        this.actionRefreshDirectory = new Action("Refresh this folder", SharedIcons.REFRESH){

            public void run() {
                AgentFileManager.this.refreshFileOrDirectory();
            }
        };
        this.actionRefreshAll = new RefreshAction((IViewPart)this){

            public void run() {
                AgentFileManager.this.refreshFileList();
            }
        };
        this.actionUpload = new Action("&Upload..."){

            public void run() {
                AgentFileManager.this.uploadFile();
            }
        };
        this.actionDelete = new Action("&Delete", SharedIcons.DELETE_OBJECT){

            public void run() {
                AgentFileManager.this.deleteFile();
            }
        };
        this.actionRename = new Action("&Rename"){

            public void run() {
                AgentFileManager.this.renameFile();
            }
        };
        Messages.get();
        this.actionShowFilter = new Action(Messages.ViewServerFile_ShowFilterAction, 2){

            public void run() {
                AgentFileManager.this.enableFilter(!AgentFileManager.this.filterEnabled);
                AgentFileManager.this.actionShowFilter.setChecked(AgentFileManager.this.filterEnabled);
            }
        };
        this.actionShowFilter.setChecked(this.filterEnabled);
        this.actionShowFilter.setActionDefinitionId("org.netxms.ui.eclipse.datacollection.commands.show_dci_filter");
        ActionHandler showFilterHandler = new ActionHandler((IAction)this.actionShowFilter);
        handlerService.activateHandler(this.actionShowFilter.getActionDefinitionId(), (IHandler)showFilterHandler);
        this.actionDownloadFile = new Action("&Download..."){

            public void run() {
                AgentFileManager.this.downloadFile();
            }
        };
        this.actionTailFile = new Action("&Show"){

            public void run() {
                AgentFileManager.this.tailFile();
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionShowFilter);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefreshAll);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionRefreshAll);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                AgentFileManager.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    protected void fillContextMenu(IMenuManager mgr) {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        if (selection.size() == 1) {
            if (((ServerFile)selection.getFirstElement()).isDirectory()) {
                mgr.add((IAction)this.actionUpload);
            } else {
                mgr.add((IAction)this.actionDownloadFile);
                mgr.add((IAction)this.actionTailFile);
            }
            mgr.add((IContributionItem)new Separator());
        }
        mgr.add((IAction)this.actionRename);
        mgr.add((IAction)this.actionDelete);
        mgr.add((IContributionItem)new Separator());
        mgr.add((IContributionItem)new GroupMarker("additions"));
        if (selection.size() == 1 && ((ServerFile)selection.getFirstElement()).isDirectory()) {
            mgr.add((IContributionItem)new Separator());
            mgr.add((IAction)this.actionRefreshDirectory);
        }
    }

    private void refreshFileList() {
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.files = AgentFileManager.this.session.listAgentFiles(null, "/", AgentFileManager.this.objectId);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentFileManager.this.viewer.setInput((Object)AgentFileManager.this.files);
                    }
                });
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void refreshFileOrDirectory() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.SelectServerFileDialog_JobTitle, null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    if (!((ServerFile)objects[i]).isDirectory()) {
                        objects[i] = ((ServerFile)objects[i]).getParent();
                    }
                    final ServerFile sf = (ServerFile)objects[i];
                    sf.setChildren(AgentFileManager.this.session.listAgentFiles(sf, sf.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)sf);
                        }
                    });
                    ++i;
                }
            }

            protected String getErrorMessage() {
                Messages.get();
                return Messages.SelectServerFileDialog_JobError;
            }
        }.start();
    }

    private void uploadFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        final ServerFile upladFolder = ((ServerFile)objects[0]).isDirectory() ? (ServerFile)objects[0] : ((ServerFile)objects[0]).getParent();
        final StartClientToServerFileUploadDialog dlg = new StartClientToServerFileUploadDialog(this.getSite().getShell());
        if (dlg.open() == 0) {
            final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
            new ConsoleJob("Upload file to agent", null, "org.netxms.ui.eclipse.filemanager", null){

                protected void runInternal(final IProgressMonitor monitor) throws Exception {
                    session.uploadLocalFileToAgent(dlg.getLocalFile(), String.valueOf(upladFolder.getFullName()) + "/" + dlg.getRemoteFileName(), AgentFileManager.this.objectId, new ProgressListener(){
                        private long prevWorkDone = 0L;

                        public void setTotalWorkAmount(long workTotal) {
                            Messages.get();
                            monitor.beginTask(String.valueOf(Messages.UploadFileToServer_TaskNamePrefix) + dlg.getLocalFile().getAbsolutePath(), (int)workTotal);
                        }

                        public void markProgress(long workDone) {
                            monitor.worked((int)(workDone - this.prevWorkDone));
                            this.prevWorkDone = workDone;
                        }
                    });
                    monitor.done();
                    upladFolder.setChildren(session.listAgentFiles(upladFolder, upladFolder.getFullName(), AgentFileManager.this.objectId));
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            AgentFileManager.this.viewer.refresh((Object)upladFolder, true);
                        }
                    });
                }

                protected String getErrorMessage() {
                    Messages.get();
                    return Messages.UploadFileToServer_JobError;
                }
            }.start();
        }
    }

    private void deleteFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Shell shell = this.getSite().getShell();
        Messages.get();
        Messages.get();
        if (!MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.ViewServerFile_DeleteConfirmation, (String)Messages.ViewServerFile_DeletAck)) {
            return;
        }
        final Object[] objects = selection.toArray();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.ViewServerFile_ErrorDeleteFileJob;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int i = 0;
                while (i < objects.length) {
                    final ServerFile sf = (ServerFile)objects[i];
                    AgentFileManager.this.session.deleteAgentFile(AgentFileManager.this.objectId, sf.getFullName());
                    this.runInUIThread(new Runnable(){

                        @Override
                        public void run() {
                            sf.getParent().removeChield(sf);
                            AgentFileManager.this.viewer.refresh((Object)sf.getParent());
                        }
                    });
                    ++i;
                }
            }
        }.start();
    }

    private void tailFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        Object[] objects = selection.toArray();
        if (((ServerFile)objects[0]).isDirectory()) {
            return;
        }
        final ServerFile sf = (ServerFile)objects[0];
        ConsoleJob job = new ConsoleJob("Download file from agent", null, "org.netxms.ui.eclipse.filemanager", null){

            protected String getErrorMessage() {
                return String.format("Error while downloading %s file from %d node.", sf.getFullName(), AgentFileManager.this.objectId);
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final AgentFile file = AgentFileManager.this.session.downloadFileFromAgent(AgentFileManager.this.objectId, sf.getFullName(), 0L, true);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                        try {
                            String secondaryId = String.valueOf(Long.toString(AgentFileManager.this.objectId)) + "&" + URLEncoder.encode(sf.getName(), "UTF-8");
                            FileViewer view = (FileViewer)window.getActivePage().showView("org.netxms.ui.eclipse.objecttools.views.FileViewer", secondaryId, 1);
                            view.showFile(file.getFile(), true, file.getId(), 0);
                        }
                        catch (Exception e) {
                            MessageDialogHelper.openError((Shell)window.getShell(), (String)"Error opening view.", (String)String.format("Error opening view: %s", e.getLocalizedMessage()));
                        }
                    }
                });
            }
        };
        job.start();
    }

    private void downloadFile() {
        String selected;
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.size() != 1) {
            return;
        }
        final ServerFile sf = (ServerFile)selection.getFirstElement();
        if (sf.isDirectory()) {
            return;
        }
        do {
            FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
            fd.setText("Select how to save file");
            String[] filterExtensions = new String[]{"*.*"};
            fd.setFilterExtensions(filterExtensions);
            String[] filterNames = new String[]{"ALL"};
            fd.setFilterNames(filterNames);
            fd.setFileName(sf.getName());
            selected = fd.open();
            if (selected != null) continue;
            return;
        } while (selected.isEmpty());
        final String name = selected;
        ConsoleJob job = new ConsoleJob("Download file from agent", null, "org.netxms.ui.eclipse.filemanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                int len;
                AgentFile file = AgentFileManager.this.session.downloadFileFromAgent(AgentFileManager.this.objectId, sf.getFullName(), 0L, false);
                File outputFile = new File(name);
                outputFile.createNewFile();
                FileInputStream in = new FileInputStream(file.getFile());
                FileOutputStream out = new FileOutputStream(outputFile);
                byte[] buf = new byte[1024];
                while ((len = ((InputStream)in).read(buf)) > 0) {
                    ((OutputStream)out).write(buf, 0, len);
                }
                ((InputStream)in).close();
                ((OutputStream)out).close();
            }

            protected String getErrorMessage() {
                return String.format("Error while downloading file %s from node %s [%d]", sf.getFullName(), AgentFileManager.this.session.getObjectName(AgentFileManager.this.objectId), AgentFileManager.this.objectId);
            }
        };
        job.start();
    }

    private void renameFile() {
        IStructuredSelection selection = (IStructuredSelection)this.viewer.getSelection();
        if (selection.isEmpty()) {
            return;
        }
        final Object[] objects = selection.toArray();
        RenameFileDialog dlg = new RenameFileDialog(this.getSite().getShell(), ((ServerFile)objects[0]).getName());
        if (dlg.open() != 0) {
            return;
        }
        final String newName = dlg.getNewName();
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                return "Error while rename file job";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                final ServerFile sf = (ServerFile)objects[0];
                AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, sf.getFullName(), String.valueOf(sf.getParent().getFullName()) + "/" + newName);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        sf.setName(newName);
                        AgentFileManager.this.viewer.refresh((Object)sf, true);
                    }
                });
            }
        }.start();
    }

    private void moveFile(final ServerFile target, final ServerFile object) {
        Messages.get();
        new ConsoleJob(Messages.ViewServerFile_DeletFileFromServerJob, (IWorkbenchPart)this, "org.netxms.ui.eclipse.filemanager", "org.netxms.ui.eclipse.filemanager"){

            protected String getErrorMessage() {
                return "Error while move file job";
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentFileManager.this.session.renameAgentFile(AgentFileManager.this.objectId, object.getFullName(), String.valueOf(target.getFullName()) + "/" + object.getName());
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        object.getParent().removeChield(object);
                        AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                        object.setParent(target);
                        target.addChield(object);
                        AgentFileManager.this.viewer.refresh((Object)object.getParent(), true);
                    }
                });
            }
        }.start();
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    private void enableFilter(boolean enable) {
        this.filterEnabled = enable;
        this.filterText.setVisible(this.filterEnabled);
        FormData fd = (FormData)this.viewer.getTree().getLayoutData();
        fd.top = enable ? new FormAttachment((Control)this.filterText) : new FormAttachment(0, 0);
        this.content.layout();
        if (enable) {
            this.filterText.setFocus();
        } else {
            this.filterText.setText("");
            this.onFilterModify();
        }
    }

    private void onFilterModify() {
        String text = this.filterText.getText();
        this.filter.setFilterString(text);
        this.viewer.refresh(false);
    }
}

