/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.agentmanager.views;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.ImageTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.actions.RefreshAction;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class AgentScreenshotView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.agentmanager.views.AgentScreenshotView";
    private NXCSession session;
    private long nodeId;
    private Image image;
    private Canvas canvas;
    private RefreshAction actionRefresh;
    private Action actionCopyToClipboard;
    private Action actionSaveImage;
    private byte[] byteImage;

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        this.session = (NXCSession)ConsoleSharedData.getSession();
        this.nodeId = Long.parseLong(site.getSecondaryId());
        AbstractObject object = this.session.findObjectById(this.nodeId);
        this.setPartName("View screenshot " + (object != null ? object.getObjectName() : Long.toString(this.nodeId)));
    }

    public void createPartControl(Composite parent) {
        parent.setLayout((Layout)new FillLayout());
        this.canvas = new Canvas(parent, 0);
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (AgentScreenshotView.this.image != null) {
                    GC gc = e.gc;
                    gc.drawImage(AgentScreenshotView.this.image, 10, 10);
                }
            }
        });
        this.createActions();
        this.contributeToActionBars();
        this.refresh();
    }

    public void refresh() {
        final NXCSession session = (NXCSession)ConsoleSharedData.getSession();
        new ConsoleJob("Get screenshot", (IWorkbenchPart)this, "org.netxms.ui.eclipse.agentmanager", null){

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                AgentScreenshotView.this.byteImage = session.takeScreenshot(AgentScreenshotView.this.nodeId, "Console");
                ImageData data = new ImageData((InputStream)new ByteArrayInputStream(AgentScreenshotView.this.byteImage));
                AgentScreenshotView.this.image = new Image((Device)this.getDisplay(), data);
                this.runInUIThread(new Runnable(){

                    @Override
                    public void run() {
                        AgentScreenshotView.this.canvas.redraw();
                    }
                });
            }

            protected String getErrorMessage() {
                return "Screenshot could not be loaded";
            }
        }.start();
    }

    private void createActions() {
        this.actionRefresh = new RefreshAction(){

            public void run() {
                AgentScreenshotView.this.refresh();
            }
        };
        this.actionCopyToClipboard = new Action("Copy to clipboard", SharedIcons.COPY){

            public void run() {
                ImageTransfer imageTransfer = ImageTransfer.getInstance();
                Clipboard clipboard = new Clipboard(AgentScreenshotView.this.canvas.getDisplay());
                clipboard.setContents(new Object[]{AgentScreenshotView.this.image.getImageData()}, new Transfer[]{imageTransfer});
            }
        };
        this.actionSaveImage = new Action("Save image", SharedIcons.SAVE){

            public void run() {
                AgentScreenshotView.this.saveImage();
            }
        };
    }

    private void saveImage() {
        String name;
        do {
            FileDialog fd = new FileDialog(this.getSite().getShell(), 8192);
            fd.setText("Select how to save file");
            String[] filterExtensions = new String[]{"*.*"};
            fd.setFilterExtensions(filterExtensions);
            String[] filterNames = new String[]{"ALL"};
            fd.setFilterNames(filterNames);
            fd.setFileName("screenshot.png");
            name = fd.open();
            if (name != null) continue;
            return;
        } while (name.isEmpty());
        File outputFile = new File(name);
        try {
            outputFile.createNewFile();
        }
        catch (IOException e) {
            MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error creating file", (String)String.format("Error creating file %s: %s", name, e.getLocalizedMessage()));
        }
        try {
            BufferedImage bi = ImageIO.read(new ByteArrayInputStream(this.byteImage));
            ImageIO.write((RenderedImage)bi, "png", outputFile);
        }
        catch (IOException e) {
            MessageDialogHelper.openError((Shell)this.getViewSite().getShell(), (String)"Error saving picture", (String)String.format("Error saving picture %s: %s", name, e.getLocalizedMessage()));
        }
    }

    public void setFocus() {
        this.canvas.setFocus();
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionSaveImage);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionSaveImage);
        manager.add((IAction)this.actionCopyToClipboard);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionRefresh);
    }
}

