/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.osm.views;

import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.ViewPart;
import org.netxms.base.GeoLocation;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.osm.Messages;
import org.netxms.ui.eclipse.osm.dialogs.TimeSelectionDialog;
import org.netxms.ui.eclipse.osm.tools.MapAccessor;
import org.netxms.ui.eclipse.osm.widgets.GeoMapViewer;
import org.netxms.ui.eclipse.osm.widgets.helpers.GeoMapListener;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;

public class HistoryView
extends ViewPart {
    public static final String ID = "org.netxms.ui.eclipse.osm.views.HistoryView";
    public static final String JOB_FAMILY = "MapViewJob";
    private static final int[] presetUnits;
    private static final int[] presetRanges;
    private static final String[] presetNames;
    protected GeoMapViewer map;
    private MapAccessor mapAccessor;
    private int zoomLevel = 15;
    private Action actionZoomIn;
    private Action actionZoomOut;
    private Action[] presetActions;
    private Action setConfigurableTime;
    private AbstractObject object;

    static {
        int[] nArray = new int[12];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 1;
        nArray[5] = 1;
        nArray[6] = 2;
        nArray[7] = 2;
        nArray[8] = 2;
        nArray[9] = 2;
        nArray[10] = 2;
        nArray[11] = 2;
        presetUnits = nArray;
        presetRanges = new int[]{10, 30, 1, 2, 4, 12, 1, 2, 5, 7, 31, 365};
        presetNames = new String[]{"10 minutes", "30 minutes", "1 hour", "2 hours", "4 hours", "12 hours", "Today", "Last 2 days", "Last 5 days", "This week", "This month", "This Year"};
    }

    protected GeoLocation getInitialCenterPoint() {
        return this.object.getGeolocation();
    }

    protected int getInitialZoomLevel() {
        return 15;
    }

    public void init(IViewSite site) throws PartInitException {
        super.init(site);
        try {
            Platform.getAdapterManager().loadAdapter((Object)((NXCSession)ConsoleSharedData.getSession()).getTopLevelObjects()[0], "org.eclipse.ui.model.IWorkbenchAdapter");
        }
        catch (Exception exception) {}
        try {
            long id = Long.parseLong(site.getSecondaryId());
            this.object = ((NXCSession)ConsoleSharedData.getSession()).findObjectById(id);
            Messages.get();
            this.setPartName(String.valueOf(Messages.LocationMap_PartNamePrefix) + this.object.getObjectName());
        }
        catch (Exception e) {
            Messages.get();
            throw new PartInitException(Messages.LocationMap_InitError1, (Throwable)e);
        }
        if (this.object == null) {
            Messages.get();
            throw new PartInitException(Messages.LocationMap_InitError2);
        }
    }

    public void createPartControl(Composite parent) {
        this.map = new GeoMapViewer(parent, 2048, true, this.object);
        this.map.setViewPart((IViewPart)this);
        this.createActions(parent);
        this.contributeToActionBars();
        this.createPopupMenu();
        this.mapAccessor = new MapAccessor(this.getInitialCenterPoint());
        this.zoomLevel = this.getInitialZoomLevel();
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.map.addMapListener(new GeoMapListener(){

            @Override
            public void onZoom(int zoomLevel) {
                HistoryView.this.zoomLevel = zoomLevel;
                HistoryView.this.mapAccessor.setZoom(zoomLevel);
                HistoryView.this.actionZoomIn.setEnabled(zoomLevel < 18);
                HistoryView.this.actionZoomOut.setEnabled(zoomLevel > 0);
            }

            @Override
            public void onPan(GeoLocation centerPoint) {
                HistoryView.this.mapAccessor.setLatitude(centerPoint.getLatitude());
                HistoryView.this.mapAccessor.setLongitude(centerPoint.getLongitude());
            }
        });
    }

    protected void createActions(final Composite parent) {
        Messages.get();
        this.actionZoomIn = new Action(Messages.AbstractGeolocationView_ZoomIn){

            public void run() {
                HistoryView.this.setZoomLevel(HistoryView.this.zoomLevel + 1);
            }
        };
        this.actionZoomIn.setImageDescriptor(SharedIcons.ZOOM_IN);
        Messages.get();
        this.actionZoomOut = new Action(Messages.AbstractGeolocationView_ZoomOut){

            public void run() {
                HistoryView.this.setZoomLevel(HistoryView.this.zoomLevel - 1);
            }
        };
        this.actionZoomOut.setImageDescriptor(SharedIcons.ZOOM_OUT);
        this.presetActions = new Action[presetRanges.length];
        int i = 0;
        while (i < presetRanges.length) {
            final Integer presetIndex = i;
            this.presetActions[i] = new Action(presetNames[i]){

                public void run() {
                    HistoryView.this.map.changeTimePeriod(presetRanges[presetIndex], presetUnits[presetIndex]);
                }
            };
            ++i;
        }
        this.setConfigurableTime = new Action("Set time frame"){

            public void run() {
                TimeSelectionDialog dialog = new TimeSelectionDialog(parent.getShell(), HistoryView.this.map.getTimePeriod());
                int result = dialog.open();
                if (result == 1) {
                    return;
                }
                HistoryView.this.map.setTimePeriod(dialog.getTimePeriod());
            }
        };
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalPullDown(bars.getMenuManager());
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    protected void fillLocalPullDown(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.setConfigurableTime);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    private void createPopupMenu() {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                HistoryView.this.fillContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu((Control)this.map);
        this.map.setMenu(menu);
    }

    protected void fillContextMenu(IMenuManager manager) {
        MenuManager presets = new MenuManager("&Presets");
        int i = 0;
        while (i < this.presetActions.length) {
            presets.add((IAction)this.presetActions[i]);
            ++i;
        }
        manager.add((IContributionItem)presets);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.setConfigurableTime);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.actionZoomIn);
        manager.add((IAction)this.actionZoomOut);
    }

    public void setFocus() {
        this.map.setFocus();
    }

    private void setZoomLevel(int newLevel) {
        if (newLevel < 0 || newLevel > 18) {
            return;
        }
        this.zoomLevel = newLevel;
        this.mapAccessor.setZoom(this.zoomLevel);
        this.map.showMap(this.mapAccessor);
        this.actionZoomIn.setEnabled(this.zoomLevel < 18);
        this.actionZoomOut.setEnabled(this.zoomLevel > 0);
    }

    protected MapAccessor getMapAccessor() {
        return this.mapAccessor;
    }
}

