/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objecttools.views;

import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import org.eclipse.core.commands.IHandler;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.commands.ActionHandler;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.console.IOConsoleOutputStream;
import org.eclipse.ui.handlers.IHandlerService;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.jobs.ConsoleJob;
import org.netxms.ui.eclipse.objecttools.Activator;
import org.netxms.ui.eclipse.objecttools.Messages;
import org.netxms.ui.eclipse.objecttools.views.AbstractCommandResults;

public class LocalCommandResults
extends AbstractCommandResults {
    public static final String ID = "org.netxms.ui.eclipse.objecttools.views.LocalCommandResults";
    private Process process;
    private boolean running = false;
    private String lastCommand = null;
    private Object mutex = new Object();
    private Action actionTerminate;
    private Action actionRestart;

    @Override
    protected void createActions() {
        super.createActions();
        IHandlerService handlerService = (IHandlerService)this.getSite().getService(IHandlerService.class);
        Messages.get();
        this.actionTerminate = new Action(Messages.LocalCommandResults_Terminate, SharedIcons.TERMINATE){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                Object object = LocalCommandResults.this.mutex;
                synchronized (object) {
                    if (LocalCommandResults.this.running) {
                        LocalCommandResults.this.process.destroy();
                    }
                }
            }
        };
        this.actionTerminate.setEnabled(false);
        this.actionTerminate.setActionDefinitionId("org.netxms.ui.eclipse.objecttools.commands.terminate_process");
        handlerService.activateHandler(this.actionTerminate.getActionDefinitionId(), (IHandler)new ActionHandler((IAction)this.actionTerminate));
        Messages.get();
        this.actionRestart = new Action(Messages.LocalCommandResults_Restart, SharedIcons.RESTART){

            public void run() {
                LocalCommandResults.this.runCommand(LocalCommandResults.this.lastCommand);
            }
        };
        this.actionRestart.setEnabled(false);
    }

    @Override
    protected void fillLocalPullDown(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalPullDown(manager);
    }

    @Override
    protected void fillLocalToolBar(IToolBarManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillLocalToolBar(manager);
    }

    @Override
    protected void fillContextMenu(IMenuManager manager) {
        manager.add((IAction)this.actionTerminate);
        manager.add((IAction)this.actionRestart);
        manager.add((IContributionItem)new Separator());
        super.fillContextMenu(manager);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void runCommand(final String command) {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running) {
                this.process.destroy();
                try {
                    this.mutex.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            this.running = true;
            this.lastCommand = command;
            this.actionTerminate.setEnabled(true);
            this.actionRestart.setEnabled(false);
        }
        final IOConsoleOutputStream out = this.console.newOutputStream();
        Messages.get();
        ConsoleJob job = new ConsoleJob(Messages.LocalCommandResults_JobTitle, (IWorkbenchPart)this, "org.netxms.ui.eclipse.objecttools", null){

            protected String getErrorMessage() {
                Messages.get();
                return Messages.LocalCommandResults_JobError;
            }

            protected void runInternal(IProgressMonitor monitor) throws Exception {
                LocalCommandResults.this.process = Runtime.getRuntime().exec(command);
                InputStream in = LocalCommandResults.this.process.getInputStream();
                try {
                    try {
                        int bytes;
                        byte[] data = new byte[16384];
                        boolean isWindows = Platform.getOS().equals("win32");
                        while ((bytes = in.read(data)) != -1) {
                            String s = new String(Arrays.copyOf(data, bytes));
                            if (isWindows) {
                                out.write(s.replace("\r\r\n", " \r\n"));
                                continue;
                            }
                            out.write(s);
                        }
                        Messages.get();
                        out.write(Messages.LocalCommandResults_Terminated);
                    }
                    catch (IOException e) {
                        Activator.logError("Exception while running local command", e);
                        in.close();
                        out.close();
                    }
                }
                finally {
                    in.close();
                    out.close();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected void jobFinalize() {
                Object object = LocalCommandResults.this.mutex;
                synchronized (object) {
                    LocalCommandResults.this.running = false;
                    LocalCommandResults.this.process = null;
                    LocalCommandResults.this.mutex.notifyAll();
                }
                this.runInUIThread(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        Object object = LocalCommandResults.this.mutex;
                        synchronized (object) {
                            LocalCommandResults.this.actionTerminate.setEnabled(LocalCommandResults.this.running);
                            LocalCommandResults.this.actionRestart.setEnabled(!LocalCommandResults.this.running);
                        }
                    }
                });
            }
        };
        job.setUser(false);
        job.setSystem(true);
        job.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Object object = this.mutex;
        synchronized (object) {
            if (this.running) {
                this.process.destroy();
            }
        }
        super.dispose();
    }
}

