/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.objectmanager.actions;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.handlers.HandlerUtil;
import org.netxms.client.NXCSession;
import org.netxms.client.objects.AbstractObject;
import org.netxms.ui.eclipse.objectmanager.Messages;
import org.netxms.ui.eclipse.shared.ConsoleSharedData;
import org.netxms.ui.eclipse.tools.MessageDialogHelper;

public class DeleteObject
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        String question;
        IWorkbenchWindow window = HandlerUtil.getActiveWorkbenchWindow((ExecutionEvent)event);
        ISelection selection = window.getActivePage().getSelection();
        if (selection == null || !(selection instanceof IStructuredSelection) || selection.isEmpty()) {
            return null;
        }
        if (((IStructuredSelection)selection).size() == 1) {
            Messages.get();
            question = String.format(Messages.DeleteObject_ConfirmQuestionSingular, ((AbstractObject)((IStructuredSelection)selection).getFirstElement()).getObjectName());
        } else {
            Messages.get();
            question = Messages.DeleteObject_ConfirmQuestionPlural;
        }
        Shell shell = window.getShell();
        Messages.get();
        boolean confirmed = MessageDialogHelper.openConfirm((Shell)shell, (String)Messages.DeleteObject_ConfirmDelete, (String)question);
        if (confirmed) {
            for (Object o : ((IStructuredSelection)selection).toList()) {
                if (!(o instanceof AbstractObject)) continue;
                try {
                    ((NXCSession)ConsoleSharedData.getSession()).deleteObject(((AbstractObject)o).getObjectId());
                }
                catch (Exception e) {
                    MessageDialogHelper.openError((Shell)window.getShell(), (String)"Error on deleting object", (String)("Error on deleting object: " + e.getMessage()));
                }
            }
        }
        return null;
    }
}

