/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import java.util.Calendar;
import java.util.Date;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DateTime;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.netxms.api.client.reporting.ReportParameter;
import org.netxms.ui.eclipse.reporter.Activator;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.tools.ImageCache;
import org.netxms.ui.eclipse.tools.WidgetHelper;

public class DateFieldEditor
extends FieldEditor {
    private static final int FIELD_YEAR = 0;
    private static final int FIELD_MONTH = 1;
    private static final int FIELD_DAY = 2;
    private Combo[] dateElements;

    public DateFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent) {
        super(parameter, toolkit, parent);
    }

    @Override
    protected Control createContent(Composite parent) {
        ImageCache imageCache = new ImageCache((Control)this);
        Composite content = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 4;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.horizontalSpacing = 2;
        layout.makeColumnsEqualWidth = true;
        content.setLayout((Layout)layout);
        Calendar dateTime = Calendar.getInstance();
        try {
            dateTime.setTime(new Date(Long.parseLong(this.parameter.getDefaultValue()) * 1000L));
        }
        catch (NumberFormatException numberFormatException) {
            dateTime.setTime(new Date());
        }
        String[] dateElementNames = new String[]{"Year", "Month", "Day"};
        this.dateElements = new Combo[dateElementNames.length];
        int idx = 0;
        while (idx < dateElementNames.length) {
            Combo cb = WidgetHelper.createLabeledCombo((Composite)content, (int)2048, (String)dateElementNames[idx], (Object)"WidgetHelper::default_layout_data");
            cb.setText(this.getDateTimeText(idx, dateTime));
            cb.add("current");
            cb.add("previous");
            cb.add("next");
            this.dateElements[idx] = cb;
            ++idx;
        }
        final ImageHyperlink link = this.toolkit.createImageHyperlink(content, 0);
        link.setImage(imageCache.add(Activator.getImageDescriptor("icons/calendar.png")));
        link.setToolTipText("Calendar");
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                DateFieldEditor.this.createPopupCalendar((Control)link);
            }
        });
        GridData gd = new GridData();
        gd.verticalAlignment = 1024;
        gd.horizontalAlignment = 16384;
        link.setLayoutData((Object)gd);
        return content;
    }

    @Override
    public String getValue() {
        String value = null;
        int idx = 0;
        while (idx < 3) {
            value = idx == 0 ? this.dateElements[idx].getText() : String.valueOf(value) + ";" + this.dateElements[idx].getText();
            ++idx;
        }
        return value;
    }

    private String getDateTimeText(int fieldIdx, Calendar dateTime) {
        int value;
        switch (fieldIdx) {
            case 0: {
                value = dateTime.get(1);
                break;
            }
            case 1: {
                value = dateTime.get(2) + 1;
                break;
            }
            case 2: {
                value = dateTime.get(5);
                break;
            }
            default: {
                value = 0;
            }
        }
        return String.valueOf(value);
    }

    private void createPopupCalendar(Control anchor) {
        final Shell popup = new Shell(this.getShell(), 16392);
        final DateTime calendar = new DateTime((Composite)popup, 33792);
        Point size = calendar.computeSize(-1, -1);
        popup.setSize(size);
        calendar.setSize(size);
        calendar.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                popup.close();
            }

            public void focusGained(FocusEvent e) {
            }
        });
        calendar.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                Calendar date = Calendar.getInstance();
                date.set(calendar.getYear(), calendar.getMonth(), calendar.getDay(), calendar.getHours(), calendar.getMinutes(), calendar.getSeconds());
                int idx = 0;
                while (idx < DateFieldEditor.this.dateElements.length) {
                    DateFieldEditor.this.dateElements[idx].setText(DateFieldEditor.this.getDateTimeText(idx, date));
                    ++idx;
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                popup.close();
            }
        });
        Rectangle rect = this.getDisplay().map((Control)anchor.getParent(), null, anchor.getBounds());
        popup.setLocation(rect.x, rect.y + rect.height);
        popup.open();
    }
}

