/*
 * Decompiled with CFR 0.152.
 */
package org.netxms.ui.eclipse.reporter.widgets;

import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.model.WorkbenchLabelProvider;
import org.netxms.api.client.reporting.ReportParameter;
import org.netxms.api.client.users.AbstractUserObject;
import org.netxms.api.client.users.User;
import org.netxms.ui.eclipse.console.resources.SharedIcons;
import org.netxms.ui.eclipse.reporter.widgets.FieldEditor;
import org.netxms.ui.eclipse.usermanager.dialogs.SelectUserDialog;

public class UserFieldEditor
extends FieldEditor {
    private static final String EMPTY_SELECTION_TEXT = "<none>";
    private WorkbenchLabelProvider labelProvider;
    private CLabel text;
    private boolean returnName;
    private AbstractUserObject user;

    public UserFieldEditor(ReportParameter parameter, FormToolkit toolkit, Composite parent, boolean returnName) {
        super(parameter, toolkit, parent);
        this.returnName = returnName;
        this.labelProvider = new WorkbenchLabelProvider();
        this.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                UserFieldEditor.this.labelProvider.dispose();
            }
        });
    }

    @Override
    protected Control createContent(Composite parent) {
        Composite content = this.toolkit.createComposite(parent, 2048);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.horizontalSpacing = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        content.setLayout((Layout)layout);
        this.text = new CLabel(content, 0);
        this.toolkit.adapt((Composite)this.text);
        GridData gd = new GridData();
        gd.horizontalAlignment = 4;
        gd.grabExcessHorizontalSpace = true;
        gd.verticalAlignment = 128;
        this.text.setLayoutData((Object)gd);
        this.text.setText(EMPTY_SELECTION_TEXT);
        ImageHyperlink selectionLink = this.toolkit.createImageHyperlink(content, 0);
        selectionLink.setImage(SharedIcons.IMG_FIND);
        selectionLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                UserFieldEditor.this.selectUser();
            }
        });
        return content;
    }

    protected void selectUser() {
        SelectUserDialog dialog = new SelectUserDialog(this.getShell(), User.class);
        if (dialog.open() == 0) {
            AbstractUserObject[] selection = dialog.getSelection();
            if (selection.length > 0) {
                AbstractUserObject user;
                this.user = user = selection[0];
                this.text.setText(user.getName());
                this.text.setImage(this.labelProvider.getImage((Object)user));
            } else {
                this.user = null;
                this.text.setText(EMPTY_SELECTION_TEXT);
                this.text.setImage(null);
            }
        }
    }

    @Override
    public String getValue() {
        if (this.user != null) {
            if (this.returnName) {
                return this.user.getName();
            }
            return Long.toString(this.user.getId());
        }
        return null;
    }
}

